/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QMainWindow>
#include <QSortFilterProxyModel>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>
#include <MsXpS/libXpertMassCore/Ionizer.hpp>
#include <MsXpS/libXpertMassCore/OligomerCollection.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "../nongui/globals.hpp"
#include "ui_MzCalculationDlg.h"
#include "MzCalculationTreeViewSortProxyModel.hpp"


namespace MsXpS
{
namespace MassXpert
{


class MzCalculationTreeViewModel;
class MzCalculationTreeViewSortProxyModel;
class PolChemDef;

class MzCalculationDlg : public QDialog
{
  Q_OBJECT

  public:
  MzCalculationDlg(QWidget *parent,
                   const QString &config_settings_file_path,
                   const libXpertMassCore::PolChemDefCstSPtr pol_chem_def_csp,
                   const QString &application_name,
                   const QString &description,
                   const libXpertMassCore::Ionizer &ionizer,
                   double = 0,
                   double = 0);

  ~MzCalculationDlg();

  void setupTreeView();

  bool getSrcIonizerData(libXpertMassCore::Ionizer &ionizer);
  bool getDestIonizerData(libXpertMassCore::Ionizer &ionizer);

  double getSourceMass(libXpertMassCore::Enums::MassType mass_type, bool &ok);

  // The results-exporting functions. ////////////////////////////////
  void prepareResultsTxtString();
  bool exportResultsClipboard();
  bool exportResultsFile();
  bool selectResultsFile();
  bool calculateSpectrum();
  //////////////////////////////////// The results-exporting functions.

  public slots:
  void calculate();
  void formulaCheckBoxToggled(bool);
  void exportResults(int);

  protected:
  Ui::MzCalculationDlg m_ui;

  // The results-exporting strings. ////////////////////////////////
  QString m_resultsString;
  QString m_resultsFilePath;
  //////////////////////////////////// The results-exporting strings.

  QString m_configSettingsFilePath;

  libXpertMassCore::PolChemDefCstSPtr mcsp_polChemDef;

  libXpertMassCore::Formula m_formula;

  libXpertMassCore::Ionizer m_ionizer;

  std::vector<IonSPtr> m_ions;

  MzCalculationTreeViewModel *mpa_mzTreeViewModel;
  MzCalculationTreeViewSortProxyModel *mpa_mzProxyModel;

  void closeEvent(QCloseEvent *event);
};


} // namespace MassXpert
} // namespace MsXpS
