{%MainUnit cocoaconfig.pas}

{
  default config of Cocoa.
  we can modify the default config in the APP.

  for example, when a FileDialog is first opened, .App Bundles appear as
  a single file by default, and their internal contents are inaccessible.

  if we want access to the contents of File Packages by default when
  the FileDialog is first opened, we can add the code to the project.lpr:

    uses CocoaConfig;
    CocoaConfigFileDialog.open.allowsFilePackagesContents:= True;
}

var
  CocoaConfigMenu: TCocoaConfigMenu = (
    menuItem: (
      defaultCheckImageName: nil;     // set in cocoaconfig.pas
      defaultRadioImageName: nil      // set in cocoaconfig.pas
    );

    // Application interface provided to facilitate APP to operate App Menu.
    // it's easy to set About, Preferences, and customized menus,
    // only the LCL TMenuItem is needed to pass in.
    // and we can control whether Cocoa is needed to automatically add
    // Hide, Hide Others, Show All, and Quit menu items.
    appMenu: (
      aboutItem: nil;
      preferencesItem: nil;
      customMenus: nil;
      onCreate: nil;
      dontAutoCreateItems: False;
    );

    // Application interface provided to facilitate APP to operate Dock Menu.
    // only the LCL TMenuItem is needed to pass in.
    dockMenu: (
      customMenus: nil;
    );
  );

var
  CocoaConfigApplication: TCocoaConfigApplication = (
    events: (
      // highest priority event handler
      highestHandler: nil;
      // Event to call when there is no MainForm with MainForm.close
      onQuitApp: nil;
      // Platform key Event modification function
      keyEventToVK: nil;
    );
  );

var
  CocoaConfigGlobal: TCocoaConfigGlobal = (
    // for compatiblity with LCL 1.8 release. The macOS base is 72ppi
    basePPI: 96;

    // if set to true, then WS would not assign icons via TCocoaWSForm SetIcon
    // The icon would have to be changed manually. By default LCL behaviour is used
    useIcon: False;

    // some localized named might be too long to be returned properly by APIs
    useLocalizedFontName: False;
  );

var
  CocoaConfigFileDialog: TCocoaConfigFileDialog = (

    open: (
      // whether to treat File Packages as a directory
      // so that users can access File Packages Contents in the FileDialog.
      // it is useful, for example, if users want to select the executable file
      // or the configuration file in the App Bundles.
      // this is the default setting when opening the FileDialog.
      // by 'showsFilePackagesSwitch', APP can set whether to show a switch
      // for the user to dynamically configure.
      allowsFilePackagesContents: False;  // the default is OFF

      accessoryView: (
        // whether to add the "Show File Packages Contents" switch in FileDialog,
        // allowing users to change it themselves.
        showsFilePackagesSwitch: False;

        minWidth: 300;
        baseY: 0;
        horzSpacing: 10;
        vertSpacing: 10;
      );
    );

    save: (
      allowsFilePackagesContents: False;
      accessoryView: (
        showsFilePackagesSwitch: False;
        minWidth: 300;
        baseY: 6;
        horzSpacing: 10;
        vertSpacing: 10;
      );
    );

    selectDirectory: (
      allowsFilePackagesContents: False;
      accessoryView: (
        showsFilePackagesSwitch: False;
        minWidth: 300;
        baseY: 0;
        horzSpacing: 10;
        vertSpacing: 10;
      );
    );
  );

var
  CocoaConfigComboBox: TCocoaConfigComboBox = (
    readOnly: (
      minWidth: 38;
      item: ( defaultHeight: 18 )
    );
  );

var
  CocoaConfigListView: TCocoaConfigListView = (
    vsReport: (
      tableViewStyle: NSTableViewStyleAutomatic;
      row: ( defaultHeight: 16; imageLineSpacing: 4*2 );
      column: ( controlSpacing: 4; textFieldMinWidth: 16 );
      columnAutoFit: ( maxCalcRows: 100; minWidth: 20; headerAdditionalWidth: 4 );
    );
    vsIcon: (
      interitemSpacing: 4;
      lineSpacing: 4;
      item: (
        minSize: ( width:64; height:68 );
        controlSpacing: 2;
        textFieldAlignment: NSTextAlignmentCenter;
        checkBoxOccupiedWidth: 24
      );
      imageView: ( minSize: ( width: 32; height: 32 ); padding: 10; );
      textField: ( defaultHeight: 15 );
    );
    vsSmallIcon: (
      interitemSpacing: 10;
      lineSpacing: 0;
      item: (
        minSize: ( width:150; height:28 );
        controlSpacing: 2;
        textFieldAlignment: 0;       // NSTextAlignmentLeft
        checkBoxOccupiedWidth: 24
      );
      imageView: ( minSize: ( width: 16; height: 16 ); padding: 4; );
      textField: ( iconWidthFactor: 3; baseWidth: 0; minWidth: 128 );
    );
    vsList: (
      interitemSpacing: 0;
      lineSpacing: 10;
      item: (
        minSize: ( width:146; height:24 );
        controlSpacing: 4;
        textFieldAlignment: 0;       // NSTextAlignmentLeft
        checkBoxOccupiedWidth: 24
      );
    );
  );

var
  CocoaConfigScroller: TCocoaConfigScroller = (
    // the style of the TCocoaScrollBar managed by TCocoaManualScrollView,
    // the default value is System Preferred.
    // note: TCocoaScrollBar not managed by TCocoaManualScrollView is always
    //       Legacy Style.
    preferredStyle: -1;

    // fade in/out time interval, in Seconds
    fadeTimeInterval: 0.02;

    legacy: (
      knob: (
        radius: 4;               // Knob Radius, in Dots
        color: @getCocoaScrollerDefaultKnobColor;
        pos: 3;                  // Knob Position, in Dots
        shrunkSize: 5;           // Knob Shrunk Size, in Dots
        alpha: 0.25;             // Knob Alpha in Normal
        alphaBlack: 0.5;         // Knob Alpha when mouse enters
        fadeStep: 0.05;          // Knob Alpha Step when fading in/out
      );
    );

    overlay: (
      bar: (
        // Overly Style Scroller Auto Show Delay Time, in Seconds
        // used when the Scroller is triggered by double-finger tapping the touchpad
        autoShowDelayTime: 0.2;
        autoHideDelayTime: 0.9;    // Bar Auto Hide Delay Time, in Seconds
        alpha: 0.5;                // Bar Alpha in Normal
        alphaFadeStep: -0.1;       // Bar Alpha Step when fading out
        alphaFadeTo: 0;            // Bar Alpha when fade out ends
        expandTimeInterval: 0.03;  // Bar Expands time interval, in Seconds
        expandSize: 4;             // Bar Expands when the mouse enters, in Dots
      );
      knob: (
        radius: 4;                 // Knob Radius, in Dots
        color: @getCocoaScrollerDefaultKnobColor;
        pos: 5;                    // Knob Position, in Dots
        shrunkSize: 6;             // Knob Shrunk Size, in Dots
        // in extreme cases, the normally calculated Knob size of Overlay Scroller
        // may be too small, keep the min size.
        // min height for the Knob of VerticalScroller
        // min width for the Knob of HorizontalScroller
        minSize: 25;
      );
    );
  );

var
  CocoaConfigEdit: TCocoaConfigEdit = (
    // to compensate for the lack of TEdit vertical alignment property in VCL/LCL.
    // to maintain compatibility, no adjustments are made by default,
    // the text is aligned to the top on Cocoa.
    // setting it to True will vertically center the text in TEdit.
    vertAlignCenter: False;
  );

var
  CocoaConfigToggleBox: TCocoaConfigToggleBox = (
    bezelStyle: NSRoundedBezelStyle;
    buttonType: NSPushOnPushOffButton;
  );

var
  CocoaConfigPanel: TCocoaConfigPanel = (
    // False: Frame3dBox() for TCustomPanel
    // True:  Frame3dClassic() for TCustomPanel
    classicFrame3d: False;
  );

var
  CocoaConfigDragImage: TCocoaConfigDragImage = (
    alpha: 0.8;
  );

var
  CocoaConfigMouse: TCocoaConfigMouse = (
    // False: Control-Left-Click passes straight through
    // True: Control-Left-Click will become Right Click
    controlLeftToRightClick: False;
  );

var
  CocoaConfigNotification: TCocoaConfigNotification = (
    // by default on macOS, Notification is only Presented when the APP is
    // in the background.
    // when CocoaAlwaysPresentNotification is set to True, Notification is
    // always Presented.
    alwaysPresent: True;
  );
