/*
 * Copyright (C) 2021-2023 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/source/helpers/populate_factory.h"
#include "shared/source/xe_hpc_core/hw_cmds.h"
#include "shared/test/common/libult/ult_command_stream_receiver.h"
#include "shared/test/common/mocks/mock_l0_debugger.h"

namespace NEO {

typedef XeHpcCoreFamily Family;

constexpr auto gfxCore = IGFX_XE_HPC_CORE;

extern CommandStreamReceiverCreateFunc commandStreamReceiverFactory[2 * IGFX_MAX_CORE];

template <>
void populateFactoryTable<UltCommandStreamReceiver<Family>>() {
    commandStreamReceiverFactory[IGFX_MAX_CORE + gfxCore] = UltCommandStreamReceiver<Family>::create;
}

struct EnableXeHpcCore {
    EnableXeHpcCore() {
        populateFactoryTable<UltCommandStreamReceiver<Family>>();
    }
};

static EnableXeHpcCore enable;
static MockDebuggerL0HwPopulateFactory<gfxCore, Family> mockDebuggerXeHpcCore;

template class UltCommandStreamReceiver<XeHpcCoreFamily>;
} // namespace NEO
