"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readGlyphStore = readGlyphStore;
const ot_metadata_1 = require("@ot-builder/ot-metadata");
const stat_glyphs_1 = require("@ot-builder/stat-glyphs");
const read_1 = require("../shared-metrics/read");
function readGlyphStore(sfnt, cfg, md, gsf, cb) {
    const { head, maxp, fvar, hhea, vhea } = md;
    const designSpace = fvar ? fvar.getDesignSpace() : null;
    const hor = (0, read_1.readHMetric)(sfnt, maxp, hhea, designSpace);
    const hmStartsAtZero = !!(head.flags & ot_metadata_1.Head.Flags.LeftSidebearingAtX0);
    let coStat = new stat_glyphs_1.HmtxCoStat(hmStartsAtZero, hor.hmtx, hor.hvar);
    const ver = (0, read_1.readVMetric)(sfnt, maxp, vhea, designSpace);
    if (ver)
        coStat = new stat_glyphs_1.VmtxCoStat(ver.vmtx, ver.vvar, ver.vorg, coStat);
    const glyphs = gsf.createStoreFromSize(maxp.numGlyphs);
    const gOrd = glyphs.decideOrder();
    const coGlyphs = cb.readGlyphs(sfnt, cfg, gOrd, {
        head,
        maxp,
        designSpace: designSpace,
        coStat,
        hMetricVariable: !!hor.hvar,
        vMetricVariable: !!(ver && ver.vvar)
    });
    return { glyphs, gOrd, coGlyphs };
}
//# sourceMappingURL=read.js.map