import { IVec2 } from "./interface";
export declare class Offset2 implements IVec2 {
    private _m_vector_type;
    x: number;
    y: number;
    constructor(x?: number, y?: number);
    clone(): Offset2;
    dot(z: IVec2): number;
    add(b: IVec2): Offset2;
    addScale(s: number, b: IVec2): Offset2;
    minus(b: IVec2): Offset2;
    mix(b: Offset2, t: number): Offset2;
    angle(): number;
    mag(): number;
    isAlmostZero(ep?: number): boolean;
    scale(t: number): Offset2;
    scaleXY(tx: number, ty: number): Offset2;
    toLength(d: number): Offset2;
    static from(p: IVec2): Offset2;
    static differenceFrom(a: IVec2, b: IVec2): Offset2;
    static dot(a: IVec2, b: IVec2): number;
    static cross(a: IVec2, b: IVec2): number;
}
export declare class Point2 implements IVec2 {
    private _m_vector_type;
    x: number;
    y: number;
    constructor(x?: number, y?: number);
    clone(): Point2;
    mix(b: Point2, t: number): Point2;
    add(b: Offset2): Point2;
    addScale(s: number, b: Offset2): Point2;
    minus(b: Point2): Offset2;
    scaleAround(z: Point2, t: number): Point2;
    scaleAroundXY(z: Point2, tx: number, ty: number): Point2;
    isClose(b: IVec2, tolerance: number): boolean;
    static intersect(a: IVec2, b: IVec2, c: IVec2, d: IVec2, fInfinite?: boolean): Point2 | null;
    static rayIntersection(p1: IVec2, _d1: IVec2, _d2: IVec2, p2: IVec2): Point2 | null;
    static project(a: IVec2, b: IVec2, p: IVec2): Point2;
    static scalarProject(a: IVec2, b: IVec2, p: IVec2): number;
    static cosAngle(a: IVec2, b: IVec2, p: IVec2): number;
    static squareDist(a: IVec2, b: IVec2): number;
    static areClose(a: IVec2, b: IVec2, t: number): boolean;
    static dist(a: IVec2, b: IVec2): number;
    static signedPointLineDist(a: IVec2, b: IVec2, p: IVec2): number;
    static pointLineDist(a: IVec2, b: IVec2, p: IVec2): number;
    static from(p: IVec2): Point2;
}
