/// <reference types="node" />
import { CffLimits } from "../../../../context/write";
import { Mir, MirNonTerminal } from "../../mir";
export declare class Rule {
    parts: Mir[];
    constructor(parts: Mir[]);
    stated: boolean;
    subrId: number;
    depth: number;
    staticSize: number;
    selfSize: number;
    expandedSize: number;
    refCount: number;
    inputRefCount: number;
    nonTerminalRefCount: Map<number, number>;
    resetStat(): void;
    utility(limits: CffLimits, scEst: number, rc: number): number;
}
export declare class NTRuleStub {
    symbol: MirNonTerminal;
    parts: Mir[];
    constructor(symbol: MirNonTerminal, parts: Mir[]);
}
export declare class RuleSet {
    inputRules: Rule[];
    nonTerminalRules: Rule[];
    private statRule;
    private staticStatRule;
    private staticStatRules;
    private dpOptimize;
    statRules(scEst: number): void;
    private currentSidPlan;
    optimize(limits: CffLimits): void;
    private compileRule;
    private encodeRule;
    compile(limits: CffLimits): {
        subroutines: Buffer[];
        charStrings: Buffer[];
    };
    private printRule;
    private ruleHeaderStart;
    printPlan(): string;
}
//# sourceMappingURL=rule-set.d.ts.map