/* The contents of this file was automatically generated by dump_modes.c
   with arguments: 48000 960
   It contains static definitions for some pre-defined modes. */
#include "modes.h"
#include "rate.h"

#ifdef HAVE_ARM_NE10
#define OVERRIDE_FFT 1
#include "static_modes_fixed_arm_ne10.h"
#endif

#ifndef DEF_WINDOW120
#define DEF_WINDOW120
static const celt_coef window120[120] = {
#ifdef ENABLE_QEXT
144497, 1300330, 3611201, 7075520, 11690888,
17454086, 24361057, 32406886, 41585775, 51891010,
63314937, 75848919, 89483305, 104207389, 120009370,
136876310, 154794092, 173747378, 193719571, 214692768,
236647730, 259563841, 283419076, 308189974, 333851610,
360377579, 387739975, 415909390, 444854905, 474544098,
504943052, 536016380, 567727246, 600037405, 632907246,
666295841, 700161014, 734459402, 769146541, 804176949,
839504226, 875081151, 910859801, 946791664, 982827766,
1018918806, 1055015289, 1091067669, 1127026498, 1162842572,
1198467087, 1233851789, 1268949131, 1303712427, 1338096005,
1372055357, 1405547287, 1438530057, 1470963523, 1502809271,
1534030739, 1564593342, 1594464576, 1623614127, 1652013955,
1679638381, 1706464157, 1732470523, 1757639262, 1781954728,
1805403878, 1827976281, 1849664119, 1870462176, 1890367815,
1909380945, 1927503971, 1944741740, 1961101474, 1976592691,
1991227121, 2005018606, 2017983003, 2030138066, 2041503334,
2052100005, 2061950805, 2071079860, 2079512552, 2087275383,
2094395834, 2100902217, 2106823531, 2112189320, 2117029526,
2121374346, 2125254091, 2128699048, 2131739342, 2134404803,
2136724837, 2138728300, 2140443379, 2141897477, 2143117096,
2144127739, 2144953806, 2145618501, 2146143740, 2146550076,
2146856617, 2147080957, 2147239112, 2147345466, 2147412715,
2147451824, 2147471990, 2147480610, 2147483253, 2147483642,
#else
2, 20, 55, 108, 178,
266, 372, 494, 635, 792,
966, 1157, 1365, 1590, 1831,
2089, 2362, 2651, 2956, 3276,
3611, 3961, 4325, 4703, 5094,
5499, 5916, 6346, 6788, 7241,
7705, 8179, 8663, 9156, 9657,
10167, 10684, 11207, 11736, 12271,
12810, 13353, 13899, 14447, 14997,
15547, 16098, 16648, 17197, 17744,
18287, 18827, 19363, 19893, 20418,
20936, 21447, 21950, 22445, 22931,
23407, 23874, 24330, 24774, 25208,
25629, 26039, 26435, 26819, 27190,
27548, 27893, 28224, 28541, 28845,
29135, 29411, 29674, 29924, 30160,
30384, 30594, 30792, 30977, 31151,
31313, 31463, 31602, 31731, 31849,
31958, 32057, 32148, 32229, 32303,
32370, 32429, 32481, 32528, 32568,
32604, 32634, 32661, 32683, 32701,
32717, 32729, 32740, 32748, 32754,
32758, 32762, 32764, 32766, 32767,
32767, 32767, 32767, 32767, 32767,
#endif
};
#endif

#ifndef DEF_LOGN400
#define DEF_LOGN400
static const opus_int16 logN400[21] = {
0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 16, 16, 16, 21, 21, 24, 29, 34, 36, };
#endif

#ifndef DEF_PULSE_CACHE50
#define DEF_PULSE_CACHE50
static const opus_int16 cache_index50[105] = {
-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 41, 41, 41,
82, 82, 123, 164, 200, 222, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 123, 123, 123, 164, 164, 240, 266, 283, 295, 41, 41, 41,
41, 41, 41, 41, 41, 123, 123, 123, 123, 240, 240, 240, 266, 266, 305,
318, 328, 336, 123, 123, 123, 123, 123, 123, 123, 123, 240, 240, 240, 240,
305, 305, 305, 318, 318, 343, 351, 358, 364, 240, 240, 240, 240, 240, 240,
240, 240, 305, 305, 305, 305, 343, 343, 343, 351, 351, 370, 376, 382, 387,
};
static const unsigned char cache_bits50[392] = {
40, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 40, 15, 23, 28,
31, 34, 36, 38, 39, 41, 42, 43, 44, 45, 46, 47, 47, 49, 50,
51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 63, 65,
66, 67, 68, 69, 70, 71, 71, 40, 20, 33, 41, 48, 53, 57, 61,
64, 66, 69, 71, 73, 75, 76, 78, 80, 82, 85, 87, 89, 91, 92,
94, 96, 98, 101, 103, 105, 107, 108, 110, 112, 114, 117, 119, 121, 123,
124, 126, 128, 40, 23, 39, 51, 60, 67, 73, 79, 83, 87, 91, 94,
97, 100, 102, 105, 107, 111, 115, 118, 121, 124, 126, 129, 131, 135, 139,
142, 145, 148, 150, 153, 155, 159, 163, 166, 169, 172, 174, 177, 179, 35,
28, 49, 65, 78, 89, 99, 107, 114, 120, 126, 132, 136, 141, 145, 149,
153, 159, 165, 171, 176, 180, 185, 189, 192, 199, 205, 211, 216, 220, 225,
229, 232, 239, 245, 251, 21, 33, 58, 79, 97, 112, 125, 137, 148, 157,
166, 174, 182, 189, 195, 201, 207, 217, 227, 235, 243, 251, 17, 35, 63,
86, 106, 123, 139, 152, 165, 177, 187, 197, 206, 214, 222, 230, 237, 250,
25, 31, 55, 75, 91, 105, 117, 128, 138, 146, 154, 161, 168, 174, 180,
185, 190, 200, 208, 215, 222, 229, 235, 240, 245, 255, 16, 36, 65, 89,
110, 128, 144, 159, 173, 185, 196, 207, 217, 226, 234, 242, 250, 11, 41,
74, 103, 128, 151, 172, 191, 209, 225, 241, 255, 9, 43, 79, 110, 138,
163, 186, 207, 227, 246, 12, 39, 71, 99, 123, 144, 164, 182, 198, 214,
228, 241, 253, 9, 44, 81, 113, 142, 168, 192, 214, 235, 255, 7, 49,
90, 127, 160, 191, 220, 247, 6, 51, 95, 134, 170, 203, 234, 7, 47,
87, 123, 155, 184, 212, 237, 6, 52, 97, 137, 174, 208, 240, 5, 57,
106, 151, 192, 231, 5, 59, 111, 158, 202, 243, 5, 55, 103, 147, 187,
224, 5, 60, 113, 161, 206, 248, 4, 65, 122, 175, 224, 4, 67, 127,
182, 234, };
static const unsigned char cache_caps50[168] = {
224, 224, 224, 224, 224, 224, 224, 224, 160, 160, 160, 160, 185, 185, 185,
178, 178, 168, 134, 61, 37, 224, 224, 224, 224, 224, 224, 224, 224, 240,
240, 240, 240, 207, 207, 207, 198, 198, 183, 144, 66, 40, 160, 160, 160,
160, 160, 160, 160, 160, 185, 185, 185, 185, 193, 193, 193, 183, 183, 172,
138, 64, 38, 240, 240, 240, 240, 240, 240, 240, 240, 207, 207, 207, 207,
204, 204, 204, 193, 193, 180, 143, 66, 40, 185, 185, 185, 185, 185, 185,
185, 185, 193, 193, 193, 193, 193, 193, 193, 183, 183, 172, 138, 65, 39,
207, 207, 207, 207, 207, 207, 207, 207, 204, 204, 204, 204, 201, 201, 201,
188, 188, 176, 141, 66, 40, 193, 193, 193, 193, 193, 193, 193, 193, 193,
193, 193, 193, 194, 194, 194, 184, 184, 173, 139, 65, 39, 204, 204, 204,
204, 204, 204, 204, 204, 201, 201, 201, 201, 198, 198, 198, 187, 187, 175,
140, 66, 40, };
#endif

#ifndef FFT_TWIDDLES48000_960
#define FFT_TWIDDLES48000_960
static const kiss_twiddle_cpx fft_twiddles48000_960[480] = {
#ifdef ENABLE_QEXT
{2147483647, 0}, {2147299667, -28109692},
{2146747758, -56214568}, {2145828015, -84309812},
{2144540595, -112390610}, {2142885720, -140452150},
{2140863672, -168489625}, {2138474798, -196498230},
{2135719507, -224473166}, {2132598272, -252409639},
{2129111627, -280302863}, {2125260169, -308148059},
{2121044560, -335940456}, {2116465520, -363675290},
{2111523835, -391347811}, {2106220351, -418953276},
{2100555977, -446486956}, {2094531684, -473944133},
{2088148503, -501320101}, {2081407529, -528610171},
{2074309916, -555809667}, {2066856881, -582913927},
{2059049701, -609918308}, {2050889713, -636818183},
{2042378316, -663608942}, {2033516968, -690285995},
{2024307187, -716844771}, {2014750552, -743280720},
{2004848699, -769589311}, {1994603326, -795766037},
{1984016188, -821806413}, {1973089099, -847705976},
{1961823931, -873460290}, {1950222615, -899064940},
{1938287138, -924515540}, {1926019546, -949807729},
{1913421940, -974937174}, {1900496479, -999899568},
{1887245378, -1024690635}, {1873670907, -1049306126},
{1859775393, -1073741823}, {1845561215, -1097993541},
{1831030810, -1122057123}, {1816186667, -1145928447},
{1801031330, -1169603421}, {1785567395, -1193077990},
{1769797513, -1216348131}, {1753724385, -1239409858},
{1737350766, -1262259217}, {1720679460, -1284892295},
{1703713325, -1307305214}, {1686455267, -1329494132},
{1668908244, -1351455249}, {1651075262, -1373184800},
{1632959376, -1394679063}, {1614563692, -1415934356},
{1595891360, -1436947035}, {1576945581, -1457713501},
{1557729600, -1478230195}, {1538246710, -1498493602},
{1518500249, -1518500249}, {1498493602, -1538246710},
{1478230195, -1557729600}, {1457713501, -1576945581},
{1436947035, -1595891360}, {1415934356, -1614563692},
{1394679063, -1632959376}, {1373184800, -1651075262},
{1351455249, -1668908244}, {1329494132, -1686455267},
{1307305214, -1703713325}, {1284892295, -1720679460},
{1262259217, -1737350766}, {1239409858, -1753724385},
{1216348131, -1769797513}, {1193077990, -1785567395},
{1169603421, -1801031330}, {1145928447, -1816186667},
{1122057123, -1831030810}, {1097993541, -1845561215},
{1073741824, -1859775393}, {1049306126, -1873670907},
{1024690635, -1887245378}, {999899568, -1900496479},
{974937174, -1913421940}, {949807729, -1926019546},
{924515540, -1938287138}, {899064940, -1950222615},
{873460290, -1961823931}, {847705976, -1973089099},
{821806413, -1984016188}, {795766037, -1994603326},
{769589311, -2004848699}, {743280720, -2014750552},
{716844771, -2024307187}, {690285995, -2033516968},
{663608942, -2042378316}, {636818183, -2050889713},
{609918308, -2059049701}, {582913927, -2066856881},
{555809667, -2074309916}, {528610171, -2081407529},
{501320101, -2088148503}, {473944133, -2094531684},
{446486956, -2100555977}, {418953276, -2106220351},
{391347811, -2111523835}, {363675290, -2116465520},
{335940456, -2121044560}, {308148059, -2125260169},
{280302863, -2129111627}, {252409639, -2132598272},
{224473166, -2135719507}, {196498230, -2138474798},
{168489625, -2140863672}, {140452150, -2142885720},
{112390610, -2144540595}, {84309812, -2145828015},
{56214568, -2146747758}, {28109692, -2147299667},
{0, -2147483647}, {-28109692, -2147299667},
{-56214568, -2146747758}, {-84309812, -2145828015},
{-112390610, -2144540595}, {-140452150, -2142885720},
{-168489625, -2140863672}, {-196498230, -2138474798},
{-224473166, -2135719507}, {-252409639, -2132598272},
{-280302863, -2129111627}, {-308148059, -2125260169},
{-335940456, -2121044560}, {-363675290, -2116465520},
{-391347811, -2111523835}, {-418953276, -2106220351},
{-446486956, -2100555977}, {-473944133, -2094531684},
{-501320101, -2088148503}, {-528610171, -2081407529},
{-555809667, -2074309916}, {-582913927, -2066856881},
{-609918308, -2059049701}, {-636818183, -2050889713},
{-663608942, -2042378316}, {-690285995, -2033516968},
{-716844771, -2024307187}, {-743280720, -2014750552},
{-769589311, -2004848699}, {-795766037, -1994603326},
{-821806413, -1984016188}, {-847705976, -1973089099},
{-873460290, -1961823931}, {-899064940, -1950222615},
{-924515540, -1938287138}, {-949807729, -1926019546},
{-974937174, -1913421940}, {-999899568, -1900496479},
{-1024690635, -1887245378}, {-1049306126, -1873670907},
{-1073741823, -1859775393}, {-1097993541, -1845561215},
{-1122057123, -1831030810}, {-1145928447, -1816186667},
{-1169603421, -1801031330}, {-1193077990, -1785567395},
{-1216348131, -1769797513}, {-1239409858, -1753724385},
{-1262259217, -1737350766}, {-1284892295, -1720679460},
{-1307305214, -1703713325}, {-1329494132, -1686455267},
{-1351455249, -1668908244}, {-1373184800, -1651075262},
{-1394679063, -1632959376}, {-1415934356, -1614563692},
{-1436947035, -1595891360}, {-1457713501, -1576945581},
{-1478230195, -1557729600}, {-1498493602, -1538246710},
{-1518500249, -1518500249}, {-1538246710, -1498493602},
{-1557729600, -1478230195}, {-1576945581, -1457713501},
{-1595891360, -1436947035}, {-1614563692, -1415934356},
{-1632959376, -1394679063}, {-1651075262, -1373184800},
{-1668908244, -1351455249}, {-1686455267, -1329494132},
{-1703713325, -1307305214}, {-1720679460, -1284892295},
{-1737350766, -1262259217}, {-1753724385, -1239409858},
{-1769797513, -1216348131}, {-1785567395, -1193077990},
{-1801031330, -1169603421}, {-1816186667, -1145928447},
{-1831030810, -1122057123}, {-1845561215, -1097993541},
{-1859775393, -1073741824}, {-1873670907, -1049306126},
{-1887245378, -1024690635}, {-1900496479, -999899568},
{-1913421940, -974937174}, {-1926019546, -949807729},
{-1938287138, -924515540}, {-1950222615, -899064940},
{-1961823931, -873460290}, {-1973089099, -847705976},
{-1984016188, -821806413}, {-1994603326, -795766037},
{-2004848699, -769589311}, {-2014750552, -743280720},
{-2024307187, -716844771}, {-2033516968, -690285995},
{-2042378316, -663608942}, {-2050889713, -636818183},
{-2059049701, -609918308}, {-2066856881, -582913927},
{-2074309916, -555809667}, {-2081407529, -528610171},
{-2088148503, -501320101}, {-2094531684, -473944133},
{-2100555977, -446486956}, {-2106220351, -418953276},
{-2111523835, -391347811}, {-2116465520, -363675290},
{-2121044560, -335940456}, {-2125260169, -308148059},
{-2129111627, -280302863}, {-2132598272, -252409639},
{-2135719507, -224473166}, {-2138474798, -196498230},
{-2140863672, -168489625}, {-2142885720, -140452150},
{-2144540595, -112390610}, {-2145828015, -84309812},
{-2146747758, -56214568}, {-2147299667, -28109692},
{-2147483647, 0}, {-2147299667, 28109692},
{-2146747758, 56214568}, {-2145828015, 84309812},
{-2144540595, 112390610}, {-2142885720, 140452150},
{-2140863672, 168489625}, {-2138474798, 196498230},
{-2135719507, 224473166}, {-2132598272, 252409639},
{-2129111627, 280302863}, {-2125260169, 308148059},
{-2121044560, 335940456}, {-2116465520, 363675290},
{-2111523835, 391347811}, {-2106220351, 418953276},
{-2100555977, 446486956}, {-2094531684, 473944133},
{-2088148503, 501320101}, {-2081407529, 528610171},
{-2074309916, 555809667}, {-2066856881, 582913927},
{-2059049701, 609918308}, {-2050889713, 636818183},
{-2042378316, 663608942}, {-2033516968, 690285995},
{-2024307187, 716844771}, {-2014750552, 743280720},
{-2004848699, 769589311}, {-1994603326, 795766037},
{-1984016188, 821806413}, {-1973089099, 847705976},
{-1961823931, 873460290}, {-1950222615, 899064940},
{-1938287138, 924515540}, {-1926019546, 949807729},
{-1913421940, 974937174}, {-1900496479, 999899568},
{-1887245378, 1024690635}, {-1873670907, 1049306126},
{-1859775393, 1073741823}, {-1845561215, 1097993541},
{-1831030810, 1122057123}, {-1816186667, 1145928447},
{-1801031330, 1169603421}, {-1785567395, 1193077990},
{-1769797513, 1216348131}, {-1753724385, 1239409858},
{-1737350766, 1262259217}, {-1720679460, 1284892295},
{-1703713325, 1307305214}, {-1686455267, 1329494132},
{-1668908244, 1351455249}, {-1651075262, 1373184800},
{-1632959376, 1394679063}, {-1614563692, 1415934356},
{-1595891360, 1436947035}, {-1576945581, 1457713501},
{-1557729600, 1478230195}, {-1538246710, 1498493602},
{-1518500249, 1518500249}, {-1498493602, 1538246710},
{-1478230195, 1557729600}, {-1457713501, 1576945581},
{-1436947035, 1595891360}, {-1415934356, 1614563692},
{-1394679063, 1632959376}, {-1373184800, 1651075262},
{-1351455249, 1668908244}, {-1329494132, 1686455267},
{-1307305214, 1703713325}, {-1284892295, 1720679460},
{-1262259217, 1737350766}, {-1239409858, 1753724385},
{-1216348131, 1769797513}, {-1193077990, 1785567395},
{-1169603421, 1801031330}, {-1145928447, 1816186667},
{-1122057123, 1831030810}, {-1097993541, 1845561215},
{-1073741824, 1859775393}, {-1049306126, 1873670907},
{-1024690635, 1887245378}, {-999899568, 1900496479},
{-974937174, 1913421940}, {-949807729, 1926019546},
{-924515540, 1938287138}, {-899064940, 1950222615},
{-873460290, 1961823931}, {-847705976, 1973089099},
{-821806413, 1984016188}, {-795766037, 1994603326},
{-769589311, 2004848699}, {-743280720, 2014750552},
{-716844771, 2024307187}, {-690285995, 2033516968},
{-663608942, 2042378316}, {-636818183, 2050889713},
{-609918308, 2059049701}, {-582913927, 2066856881},
{-555809667, 2074309916}, {-528610171, 2081407529},
{-501320101, 2088148503}, {-473944133, 2094531684},
{-446486956, 2100555977}, {-418953276, 2106220351},
{-391347811, 2111523835}, {-363675290, 2116465520},
{-335940456, 2121044560}, {-308148059, 2125260169},
{-280302863, 2129111627}, {-252409639, 2132598272},
{-224473166, 2135719507}, {-196498230, 2138474798},
{-168489625, 2140863672}, {-140452150, 2142885720},
{-112390610, 2144540595}, {-84309812, 2145828015},
{-56214568, 2146747758}, {-28109692, 2147299667},
{0, 2147483647}, {28109692, 2147299667},
{56214568, 2146747758}, {84309812, 2145828015},
{112390610, 2144540595}, {140452150, 2142885720},
{168489625, 2140863672}, {196498230, 2138474798},
{224473166, 2135719507}, {252409639, 2132598272},
{280302863, 2129111627}, {308148059, 2125260169},
{335940456, 2121044560}, {363675290, 2116465520},
{391347811, 2111523835}, {418953276, 2106220351},
{446486956, 2100555977}, {473944133, 2094531684},
{501320101, 2088148503}, {528610171, 2081407529},
{555809667, 2074309916}, {582913927, 2066856881},
{609918308, 2059049701}, {636818183, 2050889713},
{663608942, 2042378316}, {690285995, 2033516968},
{716844771, 2024307187}, {743280720, 2014750552},
{769589311, 2004848699}, {795766037, 1994603326},
{821806413, 1984016188}, {847705976, 1973089099},
{873460290, 1961823931}, {899064940, 1950222615},
{924515540, 1938287138}, {949807729, 1926019546},
{974937174, 1913421940}, {999899568, 1900496479},
{1024690635, 1887245378}, {1049306126, 1873670907},
{1073741823, 1859775393}, {1097993541, 1845561215},
{1122057123, 1831030810}, {1145928447, 1816186667},
{1169603421, 1801031330}, {1193077990, 1785567395},
{1216348131, 1769797513}, {1239409858, 1753724385},
{1262259217, 1737350766}, {1284892295, 1720679460},
{1307305214, 1703713325}, {1329494132, 1686455267},
{1351455249, 1668908244}, {1373184800, 1651075262},
{1394679063, 1632959376}, {1415934356, 1614563692},
{1436947035, 1595891360}, {1457713501, 1576945581},
{1478230195, 1557729600}, {1498493602, 1538246710},
{1518500249, 1518500249}, {1538246710, 1498493602},
{1557729600, 1478230195}, {1576945581, 1457713501},
{1595891360, 1436947035}, {1614563692, 1415934356},
{1632959376, 1394679063}, {1651075262, 1373184800},
{1668908244, 1351455249}, {1686455267, 1329494132},
{1703713325, 1307305214}, {1720679460, 1284892295},
{1737350766, 1262259217}, {1753724385, 1239409858},
{1769797513, 1216348131}, {1785567395, 1193077990},
{1801031330, 1169603421}, {1816186667, 1145928447},
{1831030810, 1122057123}, {1845561215, 1097993541},
{1859775393, 1073741824}, {1873670907, 1049306126},
{1887245378, 1024690635}, {1900496479, 999899568},
{1913421940, 974937174}, {1926019546, 949807729},
{1938287138, 924515540}, {1950222615, 899064940},
{1961823931, 873460290}, {1973089099, 847705976},
{1984016188, 821806413}, {1994603326, 795766037},
{2004848699, 769589311}, {2014750552, 743280720},
{2024307187, 716844771}, {2033516968, 690285995},
{2042378316, 663608942}, {2050889713, 636818183},
{2059049701, 609918308}, {2066856881, 582913927},
{2074309916, 555809667}, {2081407529, 528610171},
{2088148503, 501320101}, {2094531684, 473944133},
{2100555977, 446486956}, {2106220351, 418953276},
{2111523835, 391347811}, {2116465520, 363675290},
{2121044560, 335940456}, {2125260169, 308148059},
{2129111627, 280302863}, {2132598272, 252409639},
{2135719507, 224473166}, {2138474798, 196498230},
{2140863672, 168489625}, {2142885720, 140452150},
{2144540595, 112390610}, {2145828015, 84309812},
{2146747758, 56214568}, {2147299667, 28109692},
#else
{32767, 0}, {32765, -429},
{32757, -858}, {32743, -1286},
{32723, -1715}, {32698, -2143},
{32667, -2571}, {32631, -2998},
{32588, -3425}, {32541, -3851},
{32488, -4277}, {32429, -4702},
{32365, -5126}, {32295, -5549},
{32219, -5971}, {32138, -6393},
{32052, -6813}, {31960, -7232},
{31863, -7650}, {31760, -8066},
{31651, -8481}, {31538, -8895},
{31419, -9307}, {31294, -9717},
{31164, -10126}, {31029, -10533},
{30888, -10938}, {30743, -11342},
{30592, -11743}, {30435, -12142},
{30274, -12540}, {30107, -12935},
{29935, -13328}, {29758, -13719},
{29576, -14107}, {29389, -14493},
{29197, -14876}, {28999, -15257},
{28797, -15636}, {28590, -16011},
{28378, -16384}, {28161, -16754},
{27939, -17121}, {27713, -17485},
{27482, -17847}, {27246, -18205},
{27005, -18560}, {26760, -18912},
{26510, -19261}, {26255, -19606},
{25997, -19948}, {25733, -20286},
{25466, -20622}, {25193, -20953},
{24917, -21281}, {24636, -21605},
{24351, -21926}, {24062, -22243},
{23769, -22556}, {23472, -22865},
{23170, -23170}, {22865, -23472},
{22556, -23769}, {22243, -24062},
{21926, -24351}, {21605, -24636},
{21281, -24917}, {20953, -25193},
{20622, -25466}, {20286, -25733},
{19948, -25997}, {19606, -26255},
{19261, -26510}, {18912, -26760},
{18560, -27005}, {18205, -27246},
{17847, -27482}, {17485, -27713},
{17121, -27939}, {16754, -28161},
{16384, -28378}, {16011, -28590},
{15636, -28797}, {15257, -28999},
{14876, -29197}, {14493, -29389},
{14107, -29576}, {13719, -29758},
{13328, -29935}, {12935, -30107},
{12540, -30274}, {12142, -30435},
{11743, -30592}, {11342, -30743},
{10938, -30888}, {10533, -31029},
{10126, -31164}, {9717, -31294},
{9307, -31419}, {8895, -31538},
{8481, -31651}, {8066, -31760},
{7650, -31863}, {7232, -31960},
{6813, -32052}, {6393, -32138},
{5971, -32219}, {5549, -32295},
{5126, -32365}, {4702, -32429},
{4277, -32488}, {3851, -32541},
{3425, -32588}, {2998, -32631},
{2571, -32667}, {2143, -32698},
{1715, -32723}, {1286, -32743},
{858, -32757}, {429, -32765},
{0, -32767}, {-429, -32765},
{-858, -32757}, {-1286, -32743},
{-1715, -32723}, {-2143, -32698},
{-2571, -32667}, {-2998, -32631},
{-3425, -32588}, {-3851, -32541},
{-4277, -32488}, {-4702, -32429},
{-5126, -32365}, {-5549, -32295},
{-5971, -32219}, {-6393, -32138},
{-6813, -32052}, {-7232, -31960},
{-7650, -31863}, {-8066, -31760},
{-8481, -31651}, {-8895, -31538},
{-9307, -31419}, {-9717, -31294},
{-10126, -31164}, {-10533, -31029},
{-10938, -30888}, {-11342, -30743},
{-11743, -30592}, {-12142, -30435},
{-12540, -30274}, {-12935, -30107},
{-13328, -29935}, {-13719, -29758},
{-14107, -29576}, {-14493, -29389},
{-14876, -29197}, {-15257, -28999},
{-15636, -28797}, {-16011, -28590},
{-16384, -28378}, {-16754, -28161},
{-17121, -27939}, {-17485, -27713},
{-17847, -27482}, {-18205, -27246},
{-18560, -27005}, {-18912, -26760},
{-19261, -26510}, {-19606, -26255},
{-19948, -25997}, {-20286, -25733},
{-20622, -25466}, {-20953, -25193},
{-21281, -24917}, {-21605, -24636},
{-21926, -24351}, {-22243, -24062},
{-22556, -23769}, {-22865, -23472},
{-23170, -23170}, {-23472, -22865},
{-23769, -22556}, {-24062, -22243},
{-24351, -21926}, {-24636, -21605},
{-24917, -21281}, {-25193, -20953},
{-25466, -20622}, {-25733, -20286},
{-25997, -19948}, {-26255, -19606},
{-26510, -19261}, {-26760, -18912},
{-27005, -18560}, {-27246, -18205},
{-27482, -17847}, {-27713, -17485},
{-27939, -17121}, {-28161, -16754},
{-28378, -16384}, {-28590, -16011},
{-28797, -15636}, {-28999, -15257},
{-29197, -14876}, {-29389, -14493},
{-29576, -14107}, {-29758, -13719},
{-29935, -13328}, {-30107, -12935},
{-30274, -12540}, {-30435, -12142},
{-30592, -11743}, {-30743, -11342},
{-30888, -10938}, {-31029, -10533},
{-31164, -10126}, {-31294, -9717},
{-31419, -9307}, {-31538, -8895},
{-31651, -8481}, {-31760, -8066},
{-31863, -7650}, {-31960, -7232},
{-32052, -6813}, {-32138, -6393},
{-32219, -5971}, {-32295, -5549},
{-32365, -5126}, {-32429, -4702},
{-32488, -4277}, {-32541, -3851},
{-32588, -3425}, {-32631, -2998},
{-32667, -2571}, {-32698, -2143},
{-32723, -1715}, {-32743, -1286},
{-32757, -858}, {-32765, -429},
{-32767, 0}, {-32765, 429},
{-32757, 858}, {-32743, 1286},
{-32723, 1715}, {-32698, 2143},
{-32667, 2571}, {-32631, 2998},
{-32588, 3425}, {-32541, 3851},
{-32488, 4277}, {-32429, 4702},
{-32365, 5126}, {-32295, 5549},
{-32219, 5971}, {-32138, 6393},
{-32052, 6813}, {-31960, 7232},
{-31863, 7650}, {-31760, 8066},
{-31651, 8481}, {-31538, 8895},
{-31419, 9307}, {-31294, 9717},
{-31164, 10126}, {-31029, 10533},
{-30888, 10938}, {-30743, 11342},
{-30592, 11743}, {-30435, 12142},
{-30274, 12540}, {-30107, 12935},
{-29935, 13328}, {-29758, 13719},
{-29576, 14107}, {-29389, 14493},
{-29197, 14876}, {-28999, 15257},
{-28797, 15636}, {-28590, 16011},
{-28378, 16384}, {-28161, 16754},
{-27939, 17121}, {-27713, 17485},
{-27482, 17847}, {-27246, 18205},
{-27005, 18560}, {-26760, 18912},
{-26510, 19261}, {-26255, 19606},
{-25997, 19948}, {-25733, 20286},
{-25466, 20622}, {-25193, 20953},
{-24917, 21281}, {-24636, 21605},
{-24351, 21926}, {-24062, 22243},
{-23769, 22556}, {-23472, 22865},
{-23170, 23170}, {-22865, 23472},
{-22556, 23769}, {-22243, 24062},
{-21926, 24351}, {-21605, 24636},
{-21281, 24917}, {-20953, 25193},
{-20622, 25466}, {-20286, 25733},
{-19948, 25997}, {-19606, 26255},
{-19261, 26510}, {-18912, 26760},
{-18560, 27005}, {-18205, 27246},
{-17847, 27482}, {-17485, 27713},
{-17121, 27939}, {-16754, 28161},
{-16384, 28378}, {-16011, 28590},
{-15636, 28797}, {-15257, 28999},
{-14876, 29197}, {-14493, 29389},
{-14107, 29576}, {-13719, 29758},
{-13328, 29935}, {-12935, 30107},
{-12540, 30274}, {-12142, 30435},
{-11743, 30592}, {-11342, 30743},
{-10938, 30888}, {-10533, 31029},
{-10126, 31164}, {-9717, 31294},
{-9307, 31419}, {-8895, 31538},
{-8481, 31651}, {-8066, 31760},
{-7650, 31863}, {-7232, 31960},
{-6813, 32052}, {-6393, 32138},
{-5971, 32219}, {-5549, 32295},
{-5126, 32365}, {-4702, 32429},
{-4277, 32488}, {-3851, 32541},
{-3425, 32588}, {-2998, 32631},
{-2571, 32667}, {-2143, 32698},
{-1715, 32723}, {-1286, 32743},
{-858, 32757}, {-429, 32765},
{0, 32767}, {429, 32765},
{858, 32757}, {1286, 32743},
{1715, 32723}, {2143, 32698},
{2571, 32667}, {2998, 32631},
{3425, 32588}, {3851, 32541},
{4277, 32488}, {4702, 32429},
{5126, 32365}, {5549, 32295},
{5971, 32219}, {6393, 32138},
{6813, 32052}, {7232, 31960},
{7650, 31863}, {8066, 31760},
{8481, 31651}, {8895, 31538},
{9307, 31419}, {9717, 31294},
{10126, 31164}, {10533, 31029},
{10938, 30888}, {11342, 30743},
{11743, 30592}, {12142, 30435},
{12540, 30274}, {12935, 30107},
{13328, 29935}, {13719, 29758},
{14107, 29576}, {14493, 29389},
{14876, 29197}, {15257, 28999},
{15636, 28797}, {16011, 28590},
{16384, 28378}, {16754, 28161},
{17121, 27939}, {17485, 27713},
{17847, 27482}, {18205, 27246},
{18560, 27005}, {18912, 26760},
{19261, 26510}, {19606, 26255},
{19948, 25997}, {20286, 25733},
{20622, 25466}, {20953, 25193},
{21281, 24917}, {21605, 24636},
{21926, 24351}, {22243, 24062},
{22556, 23769}, {22865, 23472},
{23170, 23170}, {23472, 22865},
{23769, 22556}, {24062, 22243},
{24351, 21926}, {24636, 21605},
{24917, 21281}, {25193, 20953},
{25466, 20622}, {25733, 20286},
{25997, 19948}, {26255, 19606},
{26510, 19261}, {26760, 18912},
{27005, 18560}, {27246, 18205},
{27482, 17847}, {27713, 17485},
{27939, 17121}, {28161, 16754},
{28378, 16384}, {28590, 16011},
{28797, 15636}, {28999, 15257},
{29197, 14876}, {29389, 14493},
{29576, 14107}, {29758, 13719},
{29935, 13328}, {30107, 12935},
{30274, 12540}, {30435, 12142},
{30592, 11743}, {30743, 11342},
{30888, 10938}, {31029, 10533},
{31164, 10126}, {31294, 9717},
{31419, 9307}, {31538, 8895},
{31651, 8481}, {31760, 8066},
{31863, 7650}, {31960, 7232},
{32052, 6813}, {32138, 6393},
{32219, 5971}, {32295, 5549},
{32365, 5126}, {32429, 4702},
{32488, 4277}, {32541, 3851},
{32588, 3425}, {32631, 2998},
{32667, 2571}, {32698, 2143},
{32723, 1715}, {32743, 1286},
{32757, 858}, {32765, 429},
#endif
};
#ifndef FFT_BITREV480
#define FFT_BITREV480
static const opus_int16 fft_bitrev480[480] = {
0, 96, 192, 288, 384, 32, 128, 224, 320, 416, 64, 160, 256, 352, 448,
8, 104, 200, 296, 392, 40, 136, 232, 328, 424, 72, 168, 264, 360, 456,
16, 112, 208, 304, 400, 48, 144, 240, 336, 432, 80, 176, 272, 368, 464,
24, 120, 216, 312, 408, 56, 152, 248, 344, 440, 88, 184, 280, 376, 472,
4, 100, 196, 292, 388, 36, 132, 228, 324, 420, 68, 164, 260, 356, 452,
12, 108, 204, 300, 396, 44, 140, 236, 332, 428, 76, 172, 268, 364, 460,
20, 116, 212, 308, 404, 52, 148, 244, 340, 436, 84, 180, 276, 372, 468,
28, 124, 220, 316, 412, 60, 156, 252, 348, 444, 92, 188, 284, 380, 476,
1, 97, 193, 289, 385, 33, 129, 225, 321, 417, 65, 161, 257, 353, 449,
9, 105, 201, 297, 393, 41, 137, 233, 329, 425, 73, 169, 265, 361, 457,
17, 113, 209, 305, 401, 49, 145, 241, 337, 433, 81, 177, 273, 369, 465,
25, 121, 217, 313, 409, 57, 153, 249, 345, 441, 89, 185, 281, 377, 473,
5, 101, 197, 293, 389, 37, 133, 229, 325, 421, 69, 165, 261, 357, 453,
13, 109, 205, 301, 397, 45, 141, 237, 333, 429, 77, 173, 269, 365, 461,
21, 117, 213, 309, 405, 53, 149, 245, 341, 437, 85, 181, 277, 373, 469,
29, 125, 221, 317, 413, 61, 157, 253, 349, 445, 93, 189, 285, 381, 477,
2, 98, 194, 290, 386, 34, 130, 226, 322, 418, 66, 162, 258, 354, 450,
10, 106, 202, 298, 394, 42, 138, 234, 330, 426, 74, 170, 266, 362, 458,
18, 114, 210, 306, 402, 50, 146, 242, 338, 434, 82, 178, 274, 370, 466,
26, 122, 218, 314, 410, 58, 154, 250, 346, 442, 90, 186, 282, 378, 474,
6, 102, 198, 294, 390, 38, 134, 230, 326, 422, 70, 166, 262, 358, 454,
14, 110, 206, 302, 398, 46, 142, 238, 334, 430, 78, 174, 270, 366, 462,
22, 118, 214, 310, 406, 54, 150, 246, 342, 438, 86, 182, 278, 374, 470,
30, 126, 222, 318, 414, 62, 158, 254, 350, 446, 94, 190, 286, 382, 478,
3, 99, 195, 291, 387, 35, 131, 227, 323, 419, 67, 163, 259, 355, 451,
11, 107, 203, 299, 395, 43, 139, 235, 331, 427, 75, 171, 267, 363, 459,
19, 115, 211, 307, 403, 51, 147, 243, 339, 435, 83, 179, 275, 371, 467,
27, 123, 219, 315, 411, 59, 155, 251, 347, 443, 91, 187, 283, 379, 475,
7, 103, 199, 295, 391, 39, 135, 231, 327, 423, 71, 167, 263, 359, 455,
15, 111, 207, 303, 399, 47, 143, 239, 335, 431, 79, 175, 271, 367, 463,
23, 119, 215, 311, 407, 55, 151, 247, 343, 439, 87, 183, 279, 375, 471,
31, 127, 223, 319, 415, 63, 159, 255, 351, 447, 95, 191, 287, 383, 479,
};
#endif

#ifndef FFT_BITREV240
#define FFT_BITREV240
static const opus_int16 fft_bitrev240[240] = {
0, 48, 96, 144, 192, 16, 64, 112, 160, 208, 32, 80, 128, 176, 224,
4, 52, 100, 148, 196, 20, 68, 116, 164, 212, 36, 84, 132, 180, 228,
8, 56, 104, 152, 200, 24, 72, 120, 168, 216, 40, 88, 136, 184, 232,
12, 60, 108, 156, 204, 28, 76, 124, 172, 220, 44, 92, 140, 188, 236,
1, 49, 97, 145, 193, 17, 65, 113, 161, 209, 33, 81, 129, 177, 225,
5, 53, 101, 149, 197, 21, 69, 117, 165, 213, 37, 85, 133, 181, 229,
9, 57, 105, 153, 201, 25, 73, 121, 169, 217, 41, 89, 137, 185, 233,
13, 61, 109, 157, 205, 29, 77, 125, 173, 221, 45, 93, 141, 189, 237,
2, 50, 98, 146, 194, 18, 66, 114, 162, 210, 34, 82, 130, 178, 226,
6, 54, 102, 150, 198, 22, 70, 118, 166, 214, 38, 86, 134, 182, 230,
10, 58, 106, 154, 202, 26, 74, 122, 170, 218, 42, 90, 138, 186, 234,
14, 62, 110, 158, 206, 30, 78, 126, 174, 222, 46, 94, 142, 190, 238,
3, 51, 99, 147, 195, 19, 67, 115, 163, 211, 35, 83, 131, 179, 227,
7, 55, 103, 151, 199, 23, 71, 119, 167, 215, 39, 87, 135, 183, 231,
11, 59, 107, 155, 203, 27, 75, 123, 171, 219, 43, 91, 139, 187, 235,
15, 63, 111, 159, 207, 31, 79, 127, 175, 223, 47, 95, 143, 191, 239,
};
#endif

#ifndef FFT_BITREV120
#define FFT_BITREV120
static const opus_int16 fft_bitrev120[120] = {
0, 24, 48, 72, 96, 8, 32, 56, 80, 104, 16, 40, 64, 88, 112,
4, 28, 52, 76, 100, 12, 36, 60, 84, 108, 20, 44, 68, 92, 116,
1, 25, 49, 73, 97, 9, 33, 57, 81, 105, 17, 41, 65, 89, 113,
5, 29, 53, 77, 101, 13, 37, 61, 85, 109, 21, 45, 69, 93, 117,
2, 26, 50, 74, 98, 10, 34, 58, 82, 106, 18, 42, 66, 90, 114,
6, 30, 54, 78, 102, 14, 38, 62, 86, 110, 22, 46, 70, 94, 118,
3, 27, 51, 75, 99, 11, 35, 59, 83, 107, 19, 43, 67, 91, 115,
7, 31, 55, 79, 103, 15, 39, 63, 87, 111, 23, 47, 71, 95, 119,
};
#endif

#ifndef FFT_BITREV60
#define FFT_BITREV60
static const opus_int16 fft_bitrev60[60] = {
0, 12, 24, 36, 48, 4, 16, 28, 40, 52, 8, 20, 32, 44, 56,
1, 13, 25, 37, 49, 5, 17, 29, 41, 53, 9, 21, 33, 45, 57,
2, 14, 26, 38, 50, 6, 18, 30, 42, 54, 10, 22, 34, 46, 58,
3, 15, 27, 39, 51, 7, 19, 31, 43, 55, 11, 23, 35, 47, 59,
};
#endif

#ifndef FFT_STATE48000_960_0
#define FFT_STATE48000_960_0
static const kiss_fft_state fft_state48000_960_0 = {
480,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
8,    /* scale_shift */
-1,    /* shift */
{5, 96, 3, 32, 4, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev480,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_480,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_1
#define FFT_STATE48000_960_1
static const kiss_fft_state fft_state48000_960_1 = {
240,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
7,    /* scale_shift */
1,    /* shift */
{5, 48, 3, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev240,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_240,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_2
#define FFT_STATE48000_960_2
static const kiss_fft_state fft_state48000_960_2 = {
120,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
6,    /* scale_shift */
2,    /* shift */
{5, 24, 3, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev120,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_120,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_3
#define FFT_STATE48000_960_3
static const kiss_fft_state fft_state48000_960_3 = {
60,    /* nfft */
#ifdef ENABLE_QEXT
572662306,    /* scale */
#else
17476,    /* scale */
#endif
5,    /* scale_shift */
3,    /* shift */
{5, 12, 3, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev60,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_60,
#else
NULL,
#endif
};
#endif

#endif

#ifndef MDCT_TWIDDLES960
#define MDCT_TWIDDLES960
static const celt_coef mdct_twiddles960[1800] = {
#ifdef ENABLE_QEXT
2147483468, 2147469095, 2147431723, 2147371355, 2147287990,
2147181629, 2147052273, 2146899924, 2146724584, 2146526254,
2146304937, 2146060634, 2145793349, 2145503083, 2145189842,
2144853627, 2144494442, 2144112292, 2143707180, 2143279110,
2142828088, 2142354118, 2141857204, 2141337354, 2140794571,
2140228862, 2139640233, 2139028690, 2138394240, 2137736889,
2137056645, 2136353515, 2135627506, 2134878626, 2134106884,
2133312286, 2132494843, 2131654563, 2130791454, 2129905526,
2128996788, 2128065251, 2127110924, 2126133817, 2125133941,
2124111307, 2123065925, 2121997806, 2120906963, 2119793407,
2118657149, 2117498202, 2116316578, 2115112291, 2113885352,
2112635775, 2111363574, 2110068761, 2108751352, 2107411359,
2106048798, 2104663683, 2103256028, 2101825849, 2100373162,
2098897981, 2097400322, 2095880202, 2094337637, 2092772643,
2091185237, 2089575437, 2087943258, 2086288720, 2084611839,
2082912633, 2081191122, 2079447322, 2077681253, 2075892934,
2074082383, 2072249621, 2070394667, 2068517540, 2066618262,
2064696851, 2062753329, 2060787717, 2058800036, 2056790306,
2054758550, 2052704789, 2050629045, 2048531340, 2046411698,
2044270140, 2042106689, 2039921369, 2037714204, 2035485216,
2033234429, 2030961869, 2028667558, 2026351522, 2024013785,
2021654373, 2019273310, 2016870623, 2014446336, 2012000477,
2009533071, 2007044144, 2004533723, 2002001835, 1999448508,
1996873768, 1994277643, 1991660161, 1989021350, 1986361238,
1983679853, 1980977226, 1978253383, 1975508355, 1972742171,
1969954860, 1967146453, 1964316979, 1961466469, 1958594953,
1955702462, 1952789027, 1949854680, 1946899451, 1943923372,
1940926475, 1937908793, 1934870357, 1931811201, 1928731356,
1925630856, 1922509734, 1919368023, 1916205758, 1913022972,
1909819698, 1906595972, 1903351828, 1900087301, 1896802425,
1893497236, 1890171769, 1886826060, 1883460144, 1880074058,
1876667838, 1873241521, 1869795142, 1866328740, 1862842350,
1859336011, 1855809760, 1852263635, 1848697674, 1845111914,
1841506395, 1837881155, 1834236233, 1830571667, 1826887497,
1823183763, 1819460504, 1815717761, 1811955572, 1808173978,
1804373021, 1800552740, 1796713177, 1792854372, 1788976368,
1785079205, 1781162925, 1777227570, 1773273182, 1769299805,
1765307479, 1761296249, 1757266156, 1753217244, 1749149557,
1745063138, 1740958031, 1736834279, 1732691928, 1728531020,
1724351602, 1720153717, 1715937410, 1711702727, 1707449714,
1703178415, 1698888876, 1694581143, 1690255263, 1685911282,
1681549245, 1677169201, 1672771196, 1668355276, 1663921490,
1659469885, 1655000508, 1650513407, 1646008631, 1641486227,
1636946244, 1632388731, 1627813736, 1623221309, 1618611498,
1613984353, 1609339924, 1604678260, 1599999411, 1595303428,
1590590360, 1585860258, 1581113173, 1576349155, 1571568256,
1566770527, 1561956018, 1557124783, 1552276872, 1547412337,
1542531231, 1537633606, 1532719513, 1527789007, 1522842139,
1517878963, 1512899531, 1507903898, 1502892116, 1497864239,
1492820322, 1487760417, 1482684580, 1477592864, 1472485325,
1467362016, 1462222994, 1457068312, 1451898025, 1446712191,
1441510863, 1436294098, 1431061951, 1425814478, 1420551737,
1415273782, 1409980671, 1404672460, 1399349206, 1394010966,
1388657798, 1383289758, 1377906904, 1372509294, 1367096986,
1361670037, 1356228505, 1350772450, 1345301929, 1339817000,
1334317724, 1328804158, 1323276361, 1317734393, 1312178313,
1306608181, 1301024057, 1295425999, 1289814068, 1284188325,
1278548828, 1272895640, 1267228820, 1261548429, 1255854528,
1250147177, 1244426439, 1238692373, 1232945043, 1227184508,
1221410831, 1215624074, 1209824299, 1204011567, 1198185941,
1192347484, 1186496258, 1180632325, 1174755748, 1168866591,
1162964917, 1157050787, 1151124267, 1145185419, 1139234307,
1133270995, 1127295547, 1121308026, 1115308496, 1109297023,
1103273670, 1097238502, 1091191583, 1085132978, 1079062753,
1072980972, 1066887699, 1060783002, 1054666944, 1048539592,
1042401010, 1036251266, 1030090423, 1023918550, 1017735711,
1011541973, 1005337402, 999122065, 992896028, 986659358,
980412122, 974154386, 967886217, 961607684, 955318852,
949019790, 942710564, 936391243, 930061894, 923722585,
917373383, 911014357, 904645574, 898267104, 891879014,
885481373, 879074249, 872657710, 866231826, 859796666,
853352298, 846898791, 840436214, 833964638, 827484130,
820994760, 814496598, 807989714, 801474176, 794950056,
788417422, 781876345, 775326894, 768769141, 762203154,
755629005, 749046764, 742456501, 735858287, 729252193,
722638289, 716016646, 709387335, 702750427, 696105993,
689454104, 682794832, 676128248, 669454423, 662773428,
656085336, 649390218, 642688145, 635979190, 629263424,
622540918, 615811746, 609075979, 602333690, 595584950,
588829831, 582068407, 575300749, 568526931, 561747023,
554961100, 548169234, 541371497, 534567963, 527758704,
520943793, 514123303, 507297307, 500465878, 493629090,
486787016, 479939728, 473087301, 466229807, 459367320,
452499914, 445627662, 438750638, 431868915, 424982567,
418091668, 411196291, 404296511, 397392401, 390484035,
383571488, 376654833, 369734144, 362809495, 355880961,
348948616, 342012534, 335072790, 328129457, 321182610,
314232323, 307278671, 300321729, 293361570, 286398270,
279431902, 272462542, 265490265, 258515144, 251537254,
244556671, 237573469, 230587722, 223599506, 216608896,
209615966, 202620791, 195623446, 188624006, 181622546,
174619141, 167613866, 160606796, 153598006, 146587571,
139575567, 132562067, 125547148, 118530885, 111513352,
104494625, 97474778, 90453888, 83432030, 76409277,
69385707, 62361393, 55336412, 48310838, 41284746,
34258213, 27231312, 20204120, 13176712, 6149162,
-878453, -7906059, -14933580, -21960942, -28988068,
-36014884, -43041314, -50067283, -57092716, -64117537,
-71141672, -78165045, -85187581, -92209205, -99229841,
-106249414, -113267850, -120285073, -127301007, -134315578,
-141328711, -148340330, -155350361, -162358728, -169365356,
-176370170, -183373096, -190374058, -197372981, -204369791,
-211364411, -218356769, -225346788, -232334393, -239319511,
-246302065, -253281982, -260259186, -267233603, -274205159,
-281173778, -288139385, -295101907, -302061269, -309017396,
-315970213, -322919647, -329865622, -336808065, -343746901,
-350682056, -357613455, -364541025, -371464690, -378384377,
-385300013, -392211522, -399118830, -406021865, -412920551,
-419814815, -426704583, -433589782, -440470337, -447346176,
-454217223, -461083406, -467944652, -474800886, -481652035,
-488498026, -495338786, -502174241, -509004318, -515828944,
-522648046, -529461551, -536269386, -543071478, -549867754,
-556658141, -563442567, -570220959, -576993244, -583759350,
-590519205, -597272736, -604019870, -610760536, -617494660,
-624222173, -630943000, -637657070, -644364312, -651064652,
-657758021, -664444345, -671123554, -677795576, -684460338,
-691117771, -697767803, -704410362, -711045377, -717672778,
-724292493, -730904451, -737508582, -744104815, -750693079,
-757273304, -763845419, -770409354, -776965038, -783512402,
-790051375, -796581887, -803103868, -809617249, -816121959,
-822617929, -829105090, -835583372, -842052705, -848513021,
-854964249, -861406322, -867839170, -874262724, -880676915,
-887081675, -893476935, -899862626, -906238681, -912605031,
-918961607, -925308342, -931645168, -937972016, -944288820,
-950595511, -956892022, -963178285, -969454234, -975719800,
-981974918, -988219519, -994453537, -1000676905, -1006889557,
-1013091426, -1019282445, -1025462549, -1031631671, -1037789745,
-1043936705, -1050072485, -1056197020, -1062310244, -1068412091,
-1074502497, -1080581395, -1086648722, -1092704411, -1098748398,
-1104780618, -1110801008, -1116809501, -1122806034, -1128790543,
-1134762964, -1140723232, -1146671283, -1152607055, -1158530484,
-1164441505, -1170340057, -1176226074, -1182099496, -1187960258,
-1193808298, -1199643553, -1205465961, -1211275460, -1217071986,
-1222855479, -1228625876, -1234383115, -1240127136, -1245857875,
-1251575272, -1257279266, -1262969796, -1268646800, -1274310217,
-1279959989, -1285596052, -1291218348, -1296826816, -1302421396,
-1308002029, -1313568653, -1319121210, -1324659641, -1330183885,
-1335693885, -1341189580, -1346670912, -1352137822, -1357590252,
-1363028143, -1368451438, -1373860077, -1379254004, -1384633159,
-1389997487, -1395346928, -1400681427, -1406000925, -1411305366,
-1416594694, -1421868850, -1427127780, -1432371426, -1437599733,
-1442812644, -1448010104, -1453192057, -1458358447, -1463509220,
-1468644319, -1473763690, -1478867279, -1483955030, -1489026889,
-1494082802, -1499122714, -1504146572, -1509154322, -1514145910,
-1519121283, -1524080387, -1529023170, -1533949577, -1538859558,
-1543753058, -1548630027, -1553490410, -1558334157, -1563161216,
-1567971534, -1572765060, -1577541744, -1582301533, -1587044377,
-1591770225, -1596479027, -1601170732, -1605845289, -1610502649,
-1615142762, -1619765578, -1624371047, -1628959121, -1633529750,
-1638082885, -1642618478, -1647136479, -1651636841, -1656119516,
-1660584454, -1665031609, -1669460933, -1673872378, -1678265898,
-1682641444, -1686998971, -1691338432, -1695659779, -1699962968,
-1704247951, -1708514683, -1712763118, -1716993211, -1721204917,
-1725398189, -1729572984, -1733729257, -1737866963, -1741986057,
-1746086497, -1750168237, -1754231234, -1758275445, -1762300826,
-1766307335, -1770294927, -1774263561, -1778213194, -1782143784,
-1786055289, -1789947667, -1793820875, -1797674873, -1801509620,
-1805325074, -1809121194, -1812897940, -1816655271, -1820393147,
-1824111529, -1827810376, -1831489648, -1835149306, -1838789312,
-1842409625, -1846010208, -1849591022, -1853152028, -1856693188,
-1860214464, -1863715819, -1867197215, -1870658615, -1874099982,
-1877521279, -1880922469, -1884303515, -1887664383, -1891005035,
-1894325435, -1897625550, -1900905342, -1904164776, -1907403819,
-1910622435, -1913820590, -1916998250, -1920155379, -1923291946,
-1926407915, -1929503255, -1932577931, -1935631910, -1938665161,
-1941677650, -1944669345, -1947640214, -1950590226, -1953519348,
-1956427550, -1959314800, -1962181067, -1965026321, -1967850531,
-1970653667, -1973435699, -1976196596, -1978936331, -1981654873,
-1984352192, -1987028261, -1989683050, -1992316532, -1994928677,
-1997519459, -2000088848, -2002636818, -2005163342, -2007668391,
-2010151941, -2012613963, -2015054432, -2017473321, -2019870604,
-2022246257, -2024600252, -2026932566, -2029243173, -2031532049,
-2033799168, -2036044507, -2038268042, -2040469748, -2042649603,
-2044807583, -2046943664, -2049057824, -2051150040, -2053220291,
-2055268553, -2057294804, -2059299024, -2061281190, -2063241282,
-2065179277, -2067095157, -2068988899, -2070860485, -2072709893,
-2074537104, -2076342098, -2078124857, -2079885360, -2081623590,
-2083339527, -2085033153, -2086704450, -2088353400, -2089979985,
-2091584189, -2093165993, -2094725382, -2096262337, -2097776843,
-2099268884, -2100738443, -2102185505, -2103610054, -2105012075,
-2106391553, -2107748474, -2109082822, -2110394584, -2111683744,
-2112950291, -2114194210, -2115415487, -2116614110, -2117790065,
-2118943341, -2120073924, -2121181804, -2122266967, -2123329402,
-2124369098, -2125386044, -2126380229, -2127351642, -2128300272,
-2129226111, -2130129147, -2131009371, -2131866773, -2132701345,
-2133513078, -2134301962, -2135067990, -2135811153, -2136531442,
-2137228852, -2137903373, -2138555000, -2139183723, -2139789539,
-2140372438, -2140932416, -2141469466, -2141983583, -2142474761,
-2142942995, -2143388280, -2143810610, -2144209982, -2144586392,
-2144939834, -2145270306, -2145577804, -2145862324, -2146123864,
-2146362421, -2146577992, -2146770575, -2146940167, -2147086768,
-2147210375, -2147310987, -2147388603, -2147443222, -2147474844,
2147482929, 2147425435, 2147275952, 2147034487, 2146701050,
2146275656, 2145758322, 2145149071, 2144447929, 2143654926,
2142770096, 2141793477, 2140725111, 2139565043, 2138313323,
2136970005, 2135535146, 2134008809, 2132391057, 2130681961,
2128881593, 2126990031, 2125007356, 2122933653, 2120769010,
2118513521, 2116167282, 2113730393, 2111202959, 2108585087,
2105876892, 2103078487, 2100189994, 2097211535, 2094143239,
2090985237, 2087737664, 2084400659, 2080974365, 2077458929,
2073854502, 2070161238, 2066379295, 2062508835, 2058550025,
2054503033, 2050368032, 2046145201, 2041834720, 2037436773,
2032951550, 2028379241, 2023720043, 2018974156, 2014141783,
2009223131, 2004218410, 1999127836, 1993951625, 1988690000,
1983343186, 1977911412, 1972394912, 1966793920, 1961108677,
1955339428, 1949486417, 1943549898, 1937530123, 1931427351,
1925241843, 1918973864, 1912623682, 1906191570, 1899677803,
1893082661, 1886406424, 1879649381, 1872811820, 1865894033,
1858896318, 1851818974, 1844662304, 1837426615, 1830112217,
1822719423, 1815248550, 1807699917, 1800073849, 1792370671,
1784590714, 1776734311, 1768801799, 1760793518, 1752709809,
1744551021, 1736317502, 1728009604, 1719627685, 1711172102,
1702643219, 1694041400, 1685367013, 1676620432, 1667802029,
1658912184, 1649951276, 1640919689, 1631817811, 1622646032,
1613404744, 1604094343, 1594715227, 1585267800, 1575752465,
1566169630, 1556519705, 1546803104, 1537020244, 1527171542,
1517257422, 1507278307, 1497234626, 1487126808, 1476955286,
1466720497, 1456422878, 1446062871, 1435640919, 1425157469,
1414612971, 1404007875, 1393342636, 1382617710, 1371833558,
1360990642, 1350089425, 1339130374, 1328113960, 1317040654,
1305910930, 1294725265, 1283484138, 1272188032, 1260837429,
1249432816, 1237974681, 1226463516, 1214899813, 1203284068,
1191616778, 1179898443, 1168129565, 1156310649, 1144442200,
1132524727, 1120558740, 1108544752, 1096483278, 1084374834,
1072219940, 1060019115, 1047772882, 1035481766, 1023146293,
1010766993, 998344394, 985879030, 973371434, 960822142,
948231691, 935600622, 922929474, 910218791, 897469118,
884680999, 871854984, 858991622, 846091463, 833155061,
820182969, 807175743, 794133941, 781058120, 767948841,
754806666, 741632158, 728425880, 715188400, 701920283,
688622098, 675294414, 661937804, 648552838, 635140090,
621700135, 608233549, 594740907, 581222789, 567679774,
554112440, 540521371, 526907147, 513270353, 499611571,
485931388, 472230390, 458509162, 444768294, 431008373,
417229989, 403433732, 389620194, 375789965, 361943639,
348081809, 334205068, 320314011, 306409232, 292491328,
278560894, 264618528, 250664827, 236700388, 222725809,
208741690, 194748629, 180747225, 166738079, 152721790,
138698959, 124670187, 110636075, 96597223, 82554233,
68507707, 54458246, 40406452, 26352928, 12298274,
-1756906, -15812011, -29866438, -43919586, -57970853,
-72019637, -86065335, -100107347, -114145071, -128177904,
-142205248, -156226499, -170241059, -184248325, -198247699,
-212238581, -226220372, -240192472, -254154282, -268105206,
-282044645, -295972002, -309886680, -323788084, -337675619,
-351548688, -365406698, -379249055, -393075166, -406884440,
-420676284, -434450107, -448205320, -461941333, -475657559,
-489353409, -503028296, -516681636, -530312842, -543921332,
-557506522, -571067830, -584604676, -598116479, -611602660,
-625062643, -638495850, -651901706, -665279637, -678629069,
-691949432, -705240153, -718500664, -731730397, -744928785,
-758095263, -771229267, -784330234, -797397602, -810430813,
-823429308, -836392529, -849319923, -862210934, -875065011,
-887881603, -900660162, -913400139, -926100989, -938762167,
-951383133, -963963344, -976502263, -988999351, -1001454074,
-1013865898, -1026234291, -1038558724, -1050838668, -1063073598,
-1075262990, -1087406320, -1099503070, -1111552721, -1123554757,
-1135508663, -1147413928, -1159270041, -1171076495, -1182832785,
-1194538405, -1206192856, -1217795637, -1229346252, -1240844206,
-1252289006, -1263680162, -1275017186, -1286299593, -1297526899,
-1308698624, -1319814288, -1330873416, -1341875533, -1352820169,
-1363706855, -1374535124, -1385304512, -1396014559, -1406664805,
-1417254794, -1427784073, -1438252190, -1448658697, -1459003149,
-1469285102, -1479504115, -1489659751, -1499751576, -1509779156,
-1519742062, -1529639867, -1539472148, -1549238483, -1558938453,
-1568571644, -1578137643, -1587636039, -1597066426, -1606428400,
-1615721561, -1624945509, -1634099849, -1643184191, -1652198144,
-1661141322, -1670013342, -1678813825, -1687542393, -1696198672,
-1704782292, -1713292884, -1721730085, -1730093532, -1738382868,
-1746597738, -1754737789, -1762802673, -1770792044, -1778705561,
-1786542883, -1794303676, -1801987607, -1809594347, -1817123570,
-1824574954, -1831948179, -1839242929, -1846458892, -1853595759,
-1860653224, -1867630985, -1874528743, -1881346202, -1888083070,
-1894739060, -1901313885, -1907807264, -1914218919, -1920548575,
-1926795962, -1932960811, -1939042858, -1945041843, -1950957509,
-1956789602, -1962537873, -1968202076, -1973781967, -1979277308,
-1984687864, -1990013401, -1995253694, -2000408516, -2005477648,
-2010460871, -2015357973, -2020168744, -2024892978, -2029530472,
-2034081027, -2038544449, -2042920547, -2047209133, -2051410023,
-2055523038, -2059548001, -2063484740, -2067333086, -2071092874,
-2074763944, -2078346137, -2081839301, -2085243286, -2088557947,
-2091783140, -2094918728, -2097964577, -2100920556, -2103786539,
-2106562402, -2109248028, -2111843300, -2114348108, -2116762344,
-2119085905, -2121318692, -2123460608, -2125511562, -2127471467,
-2129340237, -2131117794, -2132804061, -2134398966, -2135902440,
-2137314419, -2138634843, -2139863654, -2141000801, -2142046235,
-2142999911, -2143861787, -2144631828, -2145310000, -2145896274,
-2146390624, -2146793031, -2147103476, -2147321946, -2147448433,
2147480773, 2147250799, 2146652904, 2145687192, 2144353827,
2142653038, 2140585116, 2138150417, 2135349356, 2132182414,
2128650133, 2124753120, 2120492040, 2115867626, 2110880668,
2105532022, 2099822604, 2093753392, 2087325426, 2080539807,
2073397699, 2065900325, 2058048970, 2049844978, 2041289756,
2032384769, 2023131544, 2013531666, 2003586779, 1993298588,
1982668856, 1971699403, 1960392110, 1948748914, 1936771810,
1924462850, 1911824143, 1898857855, 1885566207, 1871951478,
1858015999, 1843762158, 1829192399, 1814309216, 1799115162,
1783612838, 1767804901, 1751694060, 1735283075, 1718574758,
1701571972, 1684277631, 1666694698, 1648826185, 1630675154,
1612244715, 1593538026, 1574558293, 1555308768, 1535792748,
1516013578, 1495974647, 1475679389, 1455131280, 1434333842,
1413290638, 1392005275, 1370481398, 1348722696, 1326732898,
1304515771, 1282075122, 1259414796, 1236538675, 1213450681,
1190154767, 1166654927, 1142955186, 1119059606, 1094972281,
1070697338, 1046238936, 1021601267, 996788551, 971805042,
946655018, 921342790, 895872694, 870249095, 844476384,
818558976, 792501312, 766307857, 739983099, 713531549,
686957739, 660266222, 633461572, 606548381, 579531262,
552414843, 525203770, 497902707, 470516330, 443049333,
415506422, 387892316, 360211746, 332469456, 304670200,
276818739, 248919847, 220978304, 192998897, 164986421,
136945676, 108881465, 80798598, 52701887, 24596146,
-3513810, -31623164, -59727099, -87820801, -115899455,
-143958250, -171992378, -199997036, -227967426, -255898755,
-283786237, -311625094, -339410555, -367137861, -394802258,
-422399009, -449923384, -477370666, -504736154, -532015158,
-559203003, -586295032, -613286603, -640173090, -666949886,
-693612404, -720156076, -746576352, -772868706, -799028633,
-825051651, -850933300, -876669146, -902254780, -927685817,
-952957899, -978066697, -1003007909, -1027777260, -1052370507,
-1076783436, -1101011863, -1125051638, -1148898640, -1172548785,
-1195998020, -1219242327, -1242277723, -1265100260, -1287706030,
-1310091157, -1332251808, -1354184184, -1375884527, -1397349119,
-1418574283, -1439556382, -1460291820, -1480777044, -1501008545,
-1520982856, -1540696555, -1560146263, -1579328647, -1598240423,
-1616878347, -1635239228, -1653319919, -1671117323, -1688628389,
-1705850117, -1722779556, -1739413807, -1755750017, -1771785389,
-1787517174, -1802942678, -1818059257, -1832864320, -1847355332,
-1861529809, -1875385322, -1888919498, -1902130017, -1915014616,
-1927571087, -1939797279, -1951691096, -1963250501, -1974473513,
-1985358210, -1995902725, -2006105253, -2015964045, -2025477412,
-2034643724, -2043461410, -2051928960, -2060044922, -2067807906,
-2075216581, -2082269679, -2088965991, -2095304370, -2101283728,
-2106903043, -2112161350, -2117057750, -2121591402, -2125761531,
-2129567422, -2133008422, -2136083942, -2138793455, -2141136497,
-2143112666, -2144721624, -2145963095, -2146836866, -2147342788,
2147472149, 2146552303, 2144161316, 2140300829, 2134973487,
2128182940, 2119933843, 2110231849, 2099083608, 2086496759,
2072479930, 2057042727, 2040195730, 2021950484, 2002319494,
1981316215, 1958955040, 1935251296, 1910221227, 1883881987,
1856251629, 1827349089, 1797194176, 1765807555, 1733210737,
1699426064, 1664476689, 1628386565, 1591180426, 1552883771,
1513522847, 1473124631, 1431716808, 1389327759, 1345986533,
1301722835, 1256567002, 1210549980, 1163703308, 1116059092,
1067649985, 1018509163, 968670307, 918167572, 867035571,
815309347, 763024350, 710216415, 656921734, 603176830,
549018540, 494483979, 439610524, 384435782, 328997567,
273333873, 217482850, 161482775, 105372028, 49189064,
-7027611, -63239471, -119407989, -175494670, -231461077,
-287268852, -342879747, -398255649, -453358607, -508150855,
-562594842, -616653255, -670289044, -723465451, -776146031,
-828294679, -879875655, -930853609, -981193602, -1030861133,
-1079822164, -1128043139, -1175491010, -1222133257, -1267937916,
-1312873593, -1356909492, -1400015434, -1442161874, -1483319929,
-1523461391, -1562558748, -1600585205, -1637514702, -1673321927,
-1707982341, -1741472190, -1773768520, -1804849198, -1834692923,
-1863279241, -1890588560, -1916602164, -1941302225, -1964671814,
-1986694916, -2007356435, -2026642214, -2044539032, -2061034626,
-2076117690, -2089777886, -2102005853, -2112793210, -2122132564,
-2130017514, -2136442657, -2141403589, -2144896910, -2146920225,
#else
32767, 32767, 32767, 32766, 32765,
32763, 32761, 32759, 32756, 32753,
32750, 32746, 32742, 32738, 32733,
32728, 32722, 32717, 32710, 32704,
32697, 32690, 32682, 32674, 32666,
32657, 32648, 32639, 32629, 32619,
32609, 32598, 32587, 32576, 32564,
32552, 32539, 32526, 32513, 32500,
32486, 32472, 32457, 32442, 32427,
32411, 32395, 32379, 32362, 32345,
32328, 32310, 32292, 32274, 32255,
32236, 32217, 32197, 32177, 32157,
32136, 32115, 32093, 32071, 32049,
32027, 32004, 31981, 31957, 31933,
31909, 31884, 31859, 31834, 31809,
31783, 31756, 31730, 31703, 31676,
31648, 31620, 31592, 31563, 31534,
31505, 31475, 31445, 31415, 31384,
31353, 31322, 31290, 31258, 31226,
31193, 31160, 31127, 31093, 31059,
31025, 30990, 30955, 30920, 30884,
30848, 30812, 30775, 30738, 30701,
30663, 30625, 30587, 30548, 30509,
30470, 30430, 30390, 30350, 30309,
30269, 30227, 30186, 30144, 30102,
30059, 30016, 29973, 29930, 29886,
29842, 29797, 29752, 29707, 29662,
29616, 29570, 29524, 29477, 29430,
29383, 29335, 29287, 29239, 29190,
29142, 29092, 29043, 28993, 28943,
28892, 28842, 28791, 28739, 28688,
28636, 28583, 28531, 28478, 28425,
28371, 28317, 28263, 28209, 28154,
28099, 28044, 27988, 27932, 27876,
27820, 27763, 27706, 27648, 27591,
27533, 27474, 27416, 27357, 27298,
27238, 27178, 27118, 27058, 26997,
26936, 26875, 26814, 26752, 26690,
26628, 26565, 26502, 26439, 26375,
26312, 26247, 26183, 26119, 26054,
25988, 25923, 25857, 25791, 25725,
25658, 25592, 25524, 25457, 25389,
25322, 25253, 25185, 25116, 25047,
24978, 24908, 24838, 24768, 24698,
24627, 24557, 24485, 24414, 24342,
24270, 24198, 24126, 24053, 23980,
23907, 23834, 23760, 23686, 23612,
23537, 23462, 23387, 23312, 23237,
23161, 23085, 23009, 22932, 22856,
22779, 22701, 22624, 22546, 22468,
22390, 22312, 22233, 22154, 22075,
21996, 21916, 21836, 21756, 21676,
21595, 21515, 21434, 21352, 21271,
21189, 21107, 21025, 20943, 20860,
20777, 20694, 20611, 20528, 20444,
20360, 20276, 20192, 20107, 20022,
19937, 19852, 19767, 19681, 19595,
19509, 19423, 19336, 19250, 19163,
19076, 18988, 18901, 18813, 18725,
18637, 18549, 18460, 18372, 18283,
18194, 18104, 18015, 17925, 17835,
17745, 17655, 17565, 17474, 17383,
17292, 17201, 17110, 17018, 16927,
16835, 16743, 16650, 16558, 16465,
16372, 16279, 16186, 16093, 15999,
15906, 15812, 15718, 15624, 15529,
15435, 15340, 15245, 15150, 15055,
14960, 14864, 14769, 14673, 14577,
14481, 14385, 14288, 14192, 14095,
13998, 13901, 13804, 13706, 13609,
13511, 13414, 13316, 13218, 13119,
13021, 12923, 12824, 12725, 12626,
12527, 12428, 12329, 12230, 12130,
12030, 11930, 11831, 11730, 11630,
11530, 11430, 11329, 11228, 11128,
11027, 10926, 10824, 10723, 10622,
10520, 10419, 10317, 10215, 10113,
10011, 9909, 9807, 9704, 9602,
9499, 9397, 9294, 9191, 9088,
8985, 8882, 8778, 8675, 8572,
8468, 8364, 8261, 8157, 8053,
7949, 7845, 7741, 7637, 7532,
7428, 7323, 7219, 7114, 7009,
6905, 6800, 6695, 6590, 6485,
6380, 6274, 6169, 6064, 5958,
5853, 5747, 5642, 5536, 5430,
5325, 5219, 5113, 5007, 4901,
4795, 4689, 4583, 4476, 4370,
4264, 4157, 4051, 3945, 3838,
3732, 3625, 3518, 3412, 3305,
3198, 3092, 2985, 2878, 2771,
2664, 2558, 2451, 2344, 2237,
2130, 2023, 1916, 1809, 1702,
1594, 1487, 1380, 1273, 1166,
1059, 952, 844, 737, 630,
523, 416, 308, 201, 94,
-13, -121, -228, -335, -442,
-550, -657, -764, -871, -978,
-1086, -1193, -1300, -1407, -1514,
-1621, -1728, -1835, -1942, -2049,
-2157, -2263, -2370, -2477, -2584,
-2691, -2798, -2905, -3012, -3118,
-3225, -3332, -3439, -3545, -3652,
-3758, -3865, -3971, -4078, -4184,
-4290, -4397, -4503, -4609, -4715,
-4821, -4927, -5033, -5139, -5245,
-5351, -5457, -5562, -5668, -5774,
-5879, -5985, -6090, -6195, -6301,
-6406, -6511, -6616, -6721, -6826,
-6931, -7036, -7140, -7245, -7349,
-7454, -7558, -7663, -7767, -7871,
-7975, -8079, -8183, -8287, -8390,
-8494, -8597, -8701, -8804, -8907,
-9011, -9114, -9217, -9319, -9422,
-9525, -9627, -9730, -9832, -9934,
-10037, -10139, -10241, -10342, -10444,
-10546, -10647, -10748, -10850, -10951,
-11052, -11153, -11253, -11354, -11455,
-11555, -11655, -11756, -11856, -11955,
-12055, -12155, -12254, -12354, -12453,
-12552, -12651, -12750, -12849, -12947,
-13046, -13144, -13242, -13340, -13438,
-13536, -13633, -13731, -13828, -13925,
-14022, -14119, -14216, -14312, -14409,
-14505, -14601, -14697, -14793, -14888,
-14984, -15079, -15174, -15269, -15364,
-15459, -15553, -15647, -15741, -15835,
-15929, -16023, -16116, -16210, -16303,
-16396, -16488, -16581, -16673, -16766,
-16858, -16949, -17041, -17133, -17224,
-17315, -17406, -17497, -17587, -17678,
-17768, -17858, -17948, -18037, -18127,
-18216, -18305, -18394, -18483, -18571,
-18659, -18747, -18835, -18923, -19010,
-19098, -19185, -19271, -19358, -19444,
-19531, -19617, -19702, -19788, -19873,
-19959, -20043, -20128, -20213, -20297,
-20381, -20465, -20549, -20632, -20715,
-20798, -20881, -20963, -21046, -21128,
-21210, -21291, -21373, -21454, -21535,
-21616, -21696, -21776, -21856, -21936,
-22016, -22095, -22174, -22253, -22331,
-22410, -22488, -22566, -22643, -22721,
-22798, -22875, -22951, -23028, -23104,
-23180, -23256, -23331, -23406, -23481,
-23556, -23630, -23704, -23778, -23852,
-23925, -23998, -24071, -24144, -24216,
-24288, -24360, -24432, -24503, -24574,
-24645, -24716, -24786, -24856, -24926,
-24995, -25064, -25133, -25202, -25270,
-25339, -25406, -25474, -25541, -25608,
-25675, -25742, -25808, -25874, -25939,
-26005, -26070, -26135, -26199, -26264,
-26327, -26391, -26455, -26518, -26581,
-26643, -26705, -26767, -26829, -26891,
-26952, -27013, -27073, -27133, -27193,
-27253, -27312, -27372, -27430, -27489,
-27547, -27605, -27663, -27720, -27777,
-27834, -27890, -27946, -28002, -28058,
-28113, -28168, -28223, -28277, -28331,
-28385, -28438, -28491, -28544, -28596,
-28649, -28701, -28752, -28803, -28854,
-28905, -28955, -29006, -29055, -29105,
-29154, -29203, -29251, -29299, -29347,
-29395, -29442, -29489, -29535, -29582,
-29628, -29673, -29719, -29764, -29808,
-29853, -29897, -29941, -29984, -30027,
-30070, -30112, -30154, -30196, -30238,
-30279, -30320, -30360, -30400, -30440,
-30480, -30519, -30558, -30596, -30635,
-30672, -30710, -30747, -30784, -30821,
-30857, -30893, -30929, -30964, -30999,
-31033, -31068, -31102, -31135, -31168,
-31201, -31234, -31266, -31298, -31330,
-31361, -31392, -31422, -31453, -31483,
-31512, -31541, -31570, -31599, -31627,
-31655, -31682, -31710, -31737, -31763,
-31789, -31815, -31841, -31866, -31891,
-31915, -31939, -31963, -31986, -32010,
-32032, -32055, -32077, -32099, -32120,
-32141, -32162, -32182, -32202, -32222,
-32241, -32260, -32279, -32297, -32315,
-32333, -32350, -32367, -32383, -32399,
-32415, -32431, -32446, -32461, -32475,
-32489, -32503, -32517, -32530, -32542,
-32555, -32567, -32579, -32590, -32601,
-32612, -32622, -32632, -32641, -32651,
-32659, -32668, -32676, -32684, -32692,
-32699, -32706, -32712, -32718, -32724,
-32729, -32734, -32739, -32743, -32747,
-32751, -32754, -32757, -32760, -32762,
-32764, -32765, -32767, -32767, -32767,
32767, 32767, 32765, 32761, 32756,
32750, 32742, 32732, 32722, 32710,
32696, 32681, 32665, 32647, 32628,
32608, 32586, 32562, 32538, 32512,
32484, 32455, 32425, 32393, 32360,
32326, 32290, 32253, 32214, 32174,
32133, 32090, 32046, 32001, 31954,
31906, 31856, 31805, 31753, 31700,
31645, 31588, 31530, 31471, 31411,
31349, 31286, 31222, 31156, 31089,
31020, 30951, 30880, 30807, 30733,
30658, 30582, 30504, 30425, 30345,
30263, 30181, 30096, 30011, 29924,
29836, 29747, 29656, 29564, 29471,
29377, 29281, 29184, 29086, 28987,
28886, 28784, 28681, 28577, 28471,
28365, 28257, 28147, 28037, 27925,
27812, 27698, 27583, 27467, 27349,
27231, 27111, 26990, 26868, 26744,
26620, 26494, 26367, 26239, 26110,
25980, 25849, 25717, 25583, 25449,
25313, 25176, 25038, 24900, 24760,
24619, 24477, 24333, 24189, 24044,
23898, 23751, 23602, 23453, 23303,
23152, 22999, 22846, 22692, 22537,
22380, 22223, 22065, 21906, 21746,
21585, 21423, 21261, 21097, 20933,
20767, 20601, 20434, 20265, 20096,
19927, 19756, 19584, 19412, 19239,
19065, 18890, 18714, 18538, 18361,
18183, 18004, 17824, 17644, 17463,
17281, 17098, 16915, 16731, 16546,
16361, 16175, 15988, 15800, 15612,
15423, 15234, 15043, 14852, 14661,
14469, 14276, 14083, 13889, 13694,
13499, 13303, 13107, 12910, 12713,
12515, 12317, 12118, 11918, 11718,
11517, 11316, 11115, 10913, 10710,
10508, 10304, 10100, 9896, 9691,
9486, 9281, 9075, 8869, 8662,
8455, 8248, 8040, 7832, 7623,
7415, 7206, 6996, 6787, 6577,
6366, 6156, 5945, 5734, 5523,
5311, 5100, 4888, 4675, 4463,
4251, 4038, 3825, 3612, 3399,
3185, 2972, 2758, 2544, 2330,
2116, 1902, 1688, 1474, 1260,
1045, 831, 617, 402, 188,
-27, -241, -456, -670, -885,
-1099, -1313, -1528, -1742, -1956,
-2170, -2384, -2598, -2811, -3025,
-3239, -3452, -3665, -3878, -4091,
-4304, -4516, -4728, -4941, -5153,
-5364, -5576, -5787, -5998, -6209,
-6419, -6629, -6839, -7049, -7258,
-7467, -7676, -7884, -8092, -8300,
-8507, -8714, -8920, -9127, -9332,
-9538, -9743, -9947, -10151, -10355,
-10558, -10761, -10963, -11165, -11367,
-11568, -11768, -11968, -12167, -12366,
-12565, -12762, -12960, -13156, -13352,
-13548, -13743, -13937, -14131, -14324,
-14517, -14709, -14900, -15091, -15281,
-15470, -15659, -15847, -16035, -16221,
-16407, -16593, -16777, -16961, -17144,
-17326, -17508, -17689, -17869, -18049,
-18227, -18405, -18582, -18758, -18934,
-19108, -19282, -19455, -19627, -19799,
-19969, -20139, -20308, -20475, -20642,
-20809, -20974, -21138, -21301, -21464,
-21626, -21786, -21946, -22105, -22263,
-22420, -22575, -22730, -22884, -23037,
-23189, -23340, -23490, -23640, -23788,
-23935, -24080, -24225, -24369, -24512,
-24654, -24795, -24934, -25073, -25211,
-25347, -25482, -25617, -25750, -25882,
-26013, -26143, -26272, -26399, -26526,
-26651, -26775, -26898, -27020, -27141,
-27260, -27379, -27496, -27612, -27727,
-27841, -27953, -28065, -28175, -28284,
-28391, -28498, -28603, -28707, -28810,
-28911, -29012, -29111, -29209, -29305,
-29401, -29495, -29587, -29679, -29769,
-29858, -29946, -30032, -30118, -30201,
-30284, -30365, -30445, -30524, -30601,
-30677, -30752, -30825, -30897, -30968,
-31038, -31106, -31172, -31238, -31302,
-31365, -31426, -31486, -31545, -31602,
-31658, -31713, -31766, -31818, -31869,
-31918, -31966, -32012, -32058, -32101,
-32144, -32185, -32224, -32262, -32299,
-32335, -32369, -32401, -32433, -32463,
-32491, -32518, -32544, -32568, -32591,
-32613, -32633, -32652, -32669, -32685,
-32700, -32713, -32724, -32735, -32744,
-32751, -32757, -32762, -32766, -32767,
32767, 32764, 32755, 32741, 32720,
32694, 32663, 32626, 32583, 32535,
32481, 32421, 32356, 32286, 32209,
32128, 32041, 31948, 31850, 31747,
31638, 31523, 31403, 31278, 31148,
31012, 30871, 30724, 30572, 30415,
30253, 30086, 29913, 29736, 29553,
29365, 29172, 28974, 28771, 28564,
28351, 28134, 27911, 27684, 27452,
27216, 26975, 26729, 26478, 26223,
25964, 25700, 25432, 25159, 24882,
24601, 24315, 24026, 23732, 23434,
23133, 22827, 22517, 22204, 21886,
21565, 21240, 20912, 20580, 20244,
19905, 19563, 19217, 18868, 18516,
18160, 17802, 17440, 17075, 16708,
16338, 15964, 15588, 15210, 14829,
14445, 14059, 13670, 13279, 12886,
12490, 12093, 11693, 11291, 10888,
10482, 10075, 9666, 9255, 8843,
8429, 8014, 7597, 7180, 6760,
6340, 5919, 5496, 5073, 4649,
4224, 3798, 3372, 2945, 2517,
2090, 1661, 1233, 804, 375,
-54, -483, -911, -1340, -1768,
-2197, -2624, -3052, -3479, -3905,
-4330, -4755, -5179, -5602, -6024,
-6445, -6865, -7284, -7702, -8118,
-8533, -8946, -9358, -9768, -10177,
-10584, -10989, -11392, -11793, -12192,
-12589, -12984, -13377, -13767, -14155,
-14541, -14924, -15305, -15683, -16058,
-16430, -16800, -17167, -17531, -17892,
-18249, -18604, -18956, -19304, -19649,
-19990, -20329, -20663, -20994, -21322,
-21646, -21966, -22282, -22595, -22904,
-23208, -23509, -23806, -24099, -24387,
-24672, -24952, -25228, -25499, -25766,
-26029, -26288, -26541, -26791, -27035,
-27275, -27511, -27741, -27967, -28188,
-28405, -28616, -28823, -29024, -29221,
-29412, -29599, -29780, -29957, -30128,
-30294, -30455, -30611, -30761, -30906,
-31046, -31181, -31310, -31434, -31552,
-31665, -31773, -31875, -31972, -32063,
-32149, -32229, -32304, -32373, -32437,
-32495, -32547, -32594, -32635, -32671,
-32701, -32726, -32745, -32758, -32766,
32767, 32754, 32717, 32658, 32577,
32473, 32348, 32200, 32029, 31837,
31624, 31388, 31131, 30853, 30553,
30232, 29891, 29530, 29148, 28746,
28324, 27883, 27423, 26944, 26447,
25931, 25398, 24847, 24279, 23695,
23095, 22478, 21846, 21199, 20538,
19863, 19174, 18472, 17757, 17030,
16291, 15541, 14781, 14010, 13230,
12441, 11643, 10837, 10024, 9204,
8377, 7545, 6708, 5866, 5020,
4171, 3319, 2464, 1608, 751,
-107, -965, -1822, -2678, -3532,
-4383, -5232, -6077, -6918, -7754,
-8585, -9409, -10228, -11039, -11843,
-12639, -13426, -14204, -14972, -15730,
-16477, -17213, -17937, -18648, -19347,
-20033, -20705, -21363, -22006, -22634,
-23246, -23843, -24423, -24986, -25533,
-26062, -26573, -27066, -27540, -27995,
-28431, -28848, -29245, -29622, -29979,
-30315, -30630, -30924, -31197, -31449,
-31679, -31887, -32074, -32239, -32381,
-32501, -32600, -32675, -32729, -32759,
#endif
};
#endif

static const CELTMode mode48000_960_120 = {
48000,    /* Fs */
120,    /* overlap */
21,    /* nbEBands */
21,    /* effEBands */
{27853, 0, 4096, 8192, },    /* preemph */
eband5ms,    /* eBands */
3,    /* maxLM */
8,    /* nbShortMdcts */
120,    /* shortMdctSize */
11,    /* nbAllocVectors */
band_allocation,    /* allocVectors */
logN400,    /* logN */
window120,    /* window */
{1920, 3, {&fft_state48000_960_0, &fft_state48000_960_1, &fft_state48000_960_2, &fft_state48000_960_3, }, mdct_twiddles960},    /* mdct */
{392, cache_index50, cache_bits50, cache_caps50},    /* cache */
};

/* List of all the available modes */
#define TOTAL_MODES 1
static const CELTMode * const static_mode_list[TOTAL_MODES] = {
&mode48000_960_120,
};
