/* Generated from config-freebsd.json. Do not edit!  */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <string.h>
#include <ocispec/read-file.h>
#include "ocispec/runtime_spec_schema_config_freebsd.h"

#define YAJL_GET_ARRAY_NO_CHECK(v) (&(v)->u.array)
#define YAJL_GET_OBJECT_NO_CHECK(v) (&(v)->u.object)
define_cleaner_function (runtime_spec_schema_config_freebsd_jail_allow *, free_runtime_spec_schema_config_freebsd_jail_allow)
runtime_spec_schema_config_freebsd_jail_allow *
make_runtime_spec_schema_config_freebsd_jail_allow (yajl_val tree, const struct parser_context *ctx, parser_error *err)
{
    __auto_cleanup(free_runtime_spec_schema_config_freebsd_jail_allow) runtime_spec_schema_config_freebsd_jail_allow *ret = NULL;
    *err = NULL;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
      return NULL;
    ret = calloc (1, sizeof (*ret));
    if (ret == NULL)
      return NULL;
    do
      {
        yajl_val val = get_val (tree, "setHostname", yajl_t_true);
        if (val != NULL)
          {
            ret->set_hostname = YAJL_IS_TRUE(val);
            ret->set_hostname_present = 1;
              }
            else
              {
                val = get_val (tree, "setHostname", yajl_t_false);
                if (val != NULL)
                  {
                    ret->set_hostname = 0;
                    ret->set_hostname_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "rawSockets", yajl_t_true);
        if (val != NULL)
          {
            ret->raw_sockets = YAJL_IS_TRUE(val);
            ret->raw_sockets_present = 1;
              }
            else
              {
                val = get_val (tree, "rawSockets", yajl_t_false);
                if (val != NULL)
                  {
                    ret->raw_sockets = 0;
                    ret->raw_sockets_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "chflags", yajl_t_true);
        if (val != NULL)
          {
            ret->chflags = YAJL_IS_TRUE(val);
            ret->chflags_present = 1;
              }
            else
              {
                val = get_val (tree, "chflags", yajl_t_false);
                if (val != NULL)
                  {
                    ret->chflags = 0;
                    ret->chflags_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val tmp = get_val (tree, "mount", yajl_t_array);
        if (tmp != NULL && YAJL_GET_ARRAY (tmp) != NULL)
          {
            size_t i;
            size_t len = YAJL_GET_ARRAY_NO_CHECK (tmp)->len;
            yajl_val *values = YAJL_GET_ARRAY_NO_CHECK (tmp)->values;
            ret->mount_len = len;
            ret->mount = calloc (len + 1, sizeof (*ret->mount));
            if (ret->mount == NULL)
              return NULL;
            for (i = 0; i < len; i++)
              {
                yajl_val val = values[i];
                if (val != NULL)
                  {
                    char *str = YAJL_GET_STRING (val);
                    ret->mount[i] = strdup (str ? str : "");
                    if (ret->mount[i] == NULL)
                      return NULL;
                  }
    }
        }
      }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "quotas", yajl_t_true);
        if (val != NULL)
          {
            ret->quotas = YAJL_IS_TRUE(val);
            ret->quotas_present = 1;
              }
            else
              {
                val = get_val (tree, "quotas", yajl_t_false);
                if (val != NULL)
                  {
                    ret->quotas = 0;
                    ret->quotas_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "socketAf", yajl_t_true);
        if (val != NULL)
          {
            ret->socket_af = YAJL_IS_TRUE(val);
            ret->socket_af_present = 1;
              }
            else
              {
                val = get_val (tree, "socketAf", yajl_t_false);
                if (val != NULL)
                  {
                    ret->socket_af = 0;
                    ret->socket_af_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "mlock", yajl_t_true);
        if (val != NULL)
          {
            ret->mlock = YAJL_IS_TRUE(val);
            ret->mlock_present = 1;
              }
            else
              {
                val = get_val (tree, "mlock", yajl_t_false);
                if (val != NULL)
                  {
                    ret->mlock = 0;
                    ret->mlock_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "reservedPorts", yajl_t_true);
        if (val != NULL)
          {
            ret->reserved_ports = YAJL_IS_TRUE(val);
            ret->reserved_ports_present = 1;
              }
            else
              {
                val = get_val (tree, "reservedPorts", yajl_t_false);
                if (val != NULL)
                  {
                    ret->reserved_ports = 0;
                    ret->reserved_ports_present = 1;
                  }
              }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "suser", yajl_t_true);
        if (val != NULL)
          {
            ret->suser = YAJL_IS_TRUE(val);
            ret->suser_present = 1;
              }
            else
              {
                val = get_val (tree, "suser", yajl_t_false);
                if (val != NULL)
                  {
                    ret->suser = 0;
                    ret->suser_present = 1;
                  }
              }
    }
    while (0);
    if (tree->type == yajl_t_object)
      {
        size_t i;
        size_t j = 0;
        size_t cnt = tree->u.object.len;
        yajl_val resi = NULL;

        if (ctx->options & OPT_PARSE_FULLKEY)
          {
            resi = calloc (1, sizeof(*tree));
            if (resi == NULL)
              return NULL;

            resi->type = yajl_t_object;
            resi->u.object.keys = calloc (cnt, sizeof (const char *));
            if (resi->u.object.keys == NULL)
              {
                yajl_tree_free (resi);
                return NULL;
              }
            resi->u.object.values = calloc (cnt, sizeof (yajl_val));
            if (resi->u.object.values == NULL)
              {
                yajl_tree_free (resi);
                return NULL;
              }
          }

        for (i = 0; i < tree->u.object.len; i++)
          {
            if (strcmp (tree->u.object.keys[i], "setHostname")
    && strcmp (tree->u.object.keys[i], "rawSockets")
    && strcmp (tree->u.object.keys[i], "chflags")
    && strcmp (tree->u.object.keys[i], "mount")
    && strcmp (tree->u.object.keys[i], "quotas")
    && strcmp (tree->u.object.keys[i], "socketAf")
    && strcmp (tree->u.object.keys[i], "mlock")
    && strcmp (tree->u.object.keys[i], "reservedPorts")
    && strcmp (tree->u.object.keys[i], "suser")){
                if (ctx->options & OPT_PARSE_FULLKEY)
                  {
                    resi->u.object.keys[j] = tree->u.object.keys[i];
                    tree->u.object.keys[i] = NULL;
                    resi->u.object.values[j] = tree->u.object.values[i];
                    tree->u.object.values[i] = NULL;
                    resi->u.object.len++;
                  }
                j++;
              }
          }

        if ((ctx->options & OPT_PARSE_STRICT) && j > 0 && ctx->errfile != NULL)
          (void) fprintf (ctx->errfile, "WARNING: unknown key found\n");

        if (ctx->options & OPT_PARSE_FULLKEY)
          ret->_residual = resi;
      }
    return move_ptr (ret);
}

void
free_runtime_spec_schema_config_freebsd_jail_allow (runtime_spec_schema_config_freebsd_jail_allow *ptr)
{
    if (ptr == NULL)
        return;
    if (ptr->mount != NULL)
      {
        size_t i;
        for (i = 0; i < ptr->mount_len; i++)
          {
            if (ptr->mount[i] != NULL)
              {
                free (ptr->mount[i]);
                ptr->mount[i] = NULL;
            }
            }
        free (ptr->mount);
        ptr->mount = NULL;
    }
    yajl_tree_free (ptr->_residual);
    ptr->_residual = NULL;
    free (ptr);
    }
yajl_gen_status
gen_runtime_spec_schema_config_freebsd_jail_allow (yajl_gen g, const runtime_spec_schema_config_freebsd_jail_allow *ptr, const struct parser_context *ctx, parser_error *err)
{
    yajl_gen_status stat = yajl_gen_status_ok;
    *err = NULL;
    (void) ptr;  /* Silence compiler warning.  */
    stat = yajl_gen_map_open ((yajl_gen) g);
    if (stat != yajl_gen_status_ok)
        GEN_SET_ERROR_AND_RETURN (stat, err);
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->set_hostname_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("setHostname"), 11 /* strlen ("setHostname") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->set_hostname)
            b = ptr->set_hostname;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->raw_sockets_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("rawSockets"), 10 /* strlen ("rawSockets") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->raw_sockets)
            b = ptr->raw_sockets;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->chflags_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("chflags"), 7 /* strlen ("chflags") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->chflags)
            b = ptr->chflags;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->mount != NULL))
      {
        size_t len = 0, i;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("mount"), 5 /* strlen ("mount") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->mount != NULL)
          len = ptr->mount_len;
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 0);
        stat = yajl_gen_array_open ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        for (i = 0; i < len; i++)
          {
            stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(ptr->mount[i]), strlen (ptr->mount[i]));
            if (stat != yajl_gen_status_ok)
                GEN_SET_ERROR_AND_RETURN (stat, err);
        }
        stat = yajl_gen_array_close ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 1);
        }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->quotas_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("quotas"), 6 /* strlen ("quotas") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->quotas)
            b = ptr->quotas;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->socket_af_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("socketAf"), 8 /* strlen ("socketAf") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->socket_af)
            b = ptr->socket_af;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->mlock_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("mlock"), 5 /* strlen ("mlock") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->mlock)
            b = ptr->mlock;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->reserved_ports_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("reservedPorts"), 13 /* strlen ("reservedPorts") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->reserved_ports)
            b = ptr->reserved_ports;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->suser_present))
      {
        bool b = false;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("suser"), 5 /* strlen ("suser") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->suser)
            b = ptr->suser;
        stat = yajl_gen_bool ((yajl_gen)g, (int)(b));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if (ptr != NULL && ptr->_residual != NULL)
      {
        stat = gen_yajl_object_residual (ptr->_residual, g, err);
        if (yajl_gen_status_ok != stat)
            GEN_SET_ERROR_AND_RETURN (stat, err);
      }
    stat = yajl_gen_map_close ((yajl_gen) g);
    if (stat != yajl_gen_status_ok)
        GEN_SET_ERROR_AND_RETURN (stat, err);
    return yajl_gen_status_ok;
}

runtime_spec_schema_config_freebsd_jail_allow *
clone_runtime_spec_schema_config_freebsd_jail_allow (runtime_spec_schema_config_freebsd_jail_allow *src)
{
    (void) src;  /* Silence compiler warning.  */
    __auto_cleanup(free_runtime_spec_schema_config_freebsd_jail_allow) runtime_spec_schema_config_freebsd_jail_allow *ret = NULL;

    ret = calloc (1, sizeof (*ret));
    if (ret == NULL)
      return NULL;
    ret->set_hostname = src->set_hostname;
    ret->set_hostname_present = src->set_hostname_present;
    ret->raw_sockets = src->raw_sockets;
    ret->raw_sockets_present = src->raw_sockets_present;
    ret->chflags = src->chflags;
    ret->chflags_present = src->chflags_present;
    if (src->mount)
      {
        ret->mount_len = src->mount_len;
        ret->mount = calloc (src->mount_len + 1, sizeof (*ret->mount));
        if (ret->mount == NULL)
          return NULL;
        for (size_t i = 0; i < src->mount_len; i++)
          {
            if (src->mount[i])
              {
                ret->mount[i] = strdup (src->mount[i]);
                if (ret->mount[i] == NULL)
                    return NULL;
              }
        }
        }
    ret->quotas = src->quotas;
    ret->quotas_present = src->quotas_present;
    ret->socket_af = src->socket_af;
    ret->socket_af_present = src->socket_af_present;
    ret->mlock = src->mlock;
    ret->mlock_present = src->mlock_present;
    ret->reserved_ports = src->reserved_ports;
    ret->reserved_ports_present = src->reserved_ports_present;
    ret->suser = src->suser;
    ret->suser_present = src->suser_present;
    return move_ptr (ret);
}

define_cleaner_function (runtime_spec_schema_config_freebsd_jail *, free_runtime_spec_schema_config_freebsd_jail)
runtime_spec_schema_config_freebsd_jail *
make_runtime_spec_schema_config_freebsd_jail (yajl_val tree, const struct parser_context *ctx, parser_error *err)
{
    __auto_cleanup(free_runtime_spec_schema_config_freebsd_jail) runtime_spec_schema_config_freebsd_jail *ret = NULL;
    *err = NULL;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
      return NULL;
    ret = calloc (1, sizeof (*ret));
    if (ret == NULL)
      return NULL;
    do
      {
        yajl_val val = get_val (tree, "parent", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->parent = strdup (str ? str : "");
            if (ret->parent == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "host", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->host = strdup (str ? str : "");
            if (ret->host == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "ip4", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->ip4 = strdup (str ? str : "");
            if (ret->ip4 == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val tmp = get_val (tree, "ip4Addr", yajl_t_array);
        if (tmp != NULL && YAJL_GET_ARRAY (tmp) != NULL)
          {
            size_t i;
            size_t len = YAJL_GET_ARRAY_NO_CHECK (tmp)->len;
            yajl_val *values = YAJL_GET_ARRAY_NO_CHECK (tmp)->values;
            ret->ip4addr_len = len;
            ret->ip4addr = calloc (len + 1, sizeof (*ret->ip4addr));
            if (ret->ip4addr == NULL)
              return NULL;
            for (i = 0; i < len; i++)
              {
                yajl_val val = values[i];
                if (val != NULL)
                  {
                    char *str = YAJL_GET_STRING (val);
                    ret->ip4addr[i] = strdup (str ? str : "");
                    if (ret->ip4addr[i] == NULL)
                      return NULL;
                  }
    }
        }
      }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "ip6", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->ip6 = strdup (str ? str : "");
            if (ret->ip6 == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val tmp = get_val (tree, "ip6Addr", yajl_t_array);
        if (tmp != NULL && YAJL_GET_ARRAY (tmp) != NULL)
          {
            size_t i;
            size_t len = YAJL_GET_ARRAY_NO_CHECK (tmp)->len;
            yajl_val *values = YAJL_GET_ARRAY_NO_CHECK (tmp)->values;
            ret->ip6addr_len = len;
            ret->ip6addr = calloc (len + 1, sizeof (*ret->ip6addr));
            if (ret->ip6addr == NULL)
              return NULL;
            for (i = 0; i < len; i++)
              {
                yajl_val val = values[i];
                if (val != NULL)
                  {
                    char *str = YAJL_GET_STRING (val);
                    ret->ip6addr[i] = strdup (str ? str : "");
                    if (ret->ip6addr[i] == NULL)
                      return NULL;
                  }
    }
        }
      }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "vnet", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->vnet = strdup (str ? str : "");
            if (ret->vnet == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "interface", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->interface = strdup (str ? str : "");
            if (ret->interface == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val tmp = get_val (tree, "vnetInterfaces", yajl_t_array);
        if (tmp != NULL && YAJL_GET_ARRAY (tmp) != NULL)
          {
            size_t i;
            size_t len = YAJL_GET_ARRAY_NO_CHECK (tmp)->len;
            yajl_val *values = YAJL_GET_ARRAY_NO_CHECK (tmp)->values;
            ret->vnet_interfaces_len = len;
            ret->vnet_interfaces = calloc (len + 1, sizeof (*ret->vnet_interfaces));
            if (ret->vnet_interfaces == NULL)
              return NULL;
            for (i = 0; i < len; i++)
              {
                yajl_val val = values[i];
                if (val != NULL)
                  {
                    char *str = YAJL_GET_STRING (val);
                    ret->vnet_interfaces[i] = strdup (str ? str : "");
                    if (ret->vnet_interfaces[i] == NULL)
                      return NULL;
                  }
    }
        }
      }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "sysvmsg", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->sysvmsg = strdup (str ? str : "");
            if (ret->sysvmsg == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "sysvsem", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->sysvsem = strdup (str ? str : "");
            if (ret->sysvsem == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "sysvshm", yajl_t_string);
        if (val != NULL)
          {
            char *str = YAJL_GET_STRING (val);
            ret->sysvshm = strdup (str ? str : "");
            if (ret->sysvshm == NULL)
              return NULL;
          }
    }
    while (0);
    do
      {
        yajl_val val = get_val (tree, "enforceStatfs", yajl_t_number);
        if (val != NULL)
          {
            int invalid;
            if (! YAJL_IS_NUMBER (val))
              {
                *err = strdup ("invalid type");
                return NULL;
              }
            invalid = common_safe_uint8 (YAJL_GET_NUMBER (val), &ret->enforce_statfs);
            if (invalid)
              {
                if (asprintf (err, "Invalid value '%s' with type 'uint8' for key 'enforceStatfs': %s", YAJL_GET_NUMBER (val), strerror (-invalid)) < 0)
                    *err = strdup ("error allocating memory");
                return NULL;
              }
            ret->enforce_statfs_present = 1;
        }
    }
    while (0);
    ret->allow = make_runtime_spec_schema_config_freebsd_jail_allow (get_val (tree, "allow", yajl_t_object), ctx, err);
    if (ret->allow == NULL && *err != 0)
      return NULL;
    if (tree->type == yajl_t_object)
      {
        size_t i;
        size_t j = 0;
        size_t cnt = tree->u.object.len;
        yajl_val resi = NULL;

        if (ctx->options & OPT_PARSE_FULLKEY)
          {
            resi = calloc (1, sizeof(*tree));
            if (resi == NULL)
              return NULL;

            resi->type = yajl_t_object;
            resi->u.object.keys = calloc (cnt, sizeof (const char *));
            if (resi->u.object.keys == NULL)
              {
                yajl_tree_free (resi);
                return NULL;
              }
            resi->u.object.values = calloc (cnt, sizeof (yajl_val));
            if (resi->u.object.values == NULL)
              {
                yajl_tree_free (resi);
                return NULL;
              }
          }

        for (i = 0; i < tree->u.object.len; i++)
          {
            if (strcmp (tree->u.object.keys[i], "parent")
    && strcmp (tree->u.object.keys[i], "host")
    && strcmp (tree->u.object.keys[i], "ip4")
    && strcmp (tree->u.object.keys[i], "ip4Addr")
    && strcmp (tree->u.object.keys[i], "ip6")
    && strcmp (tree->u.object.keys[i], "ip6Addr")
    && strcmp (tree->u.object.keys[i], "vnet")
    && strcmp (tree->u.object.keys[i], "interface")
    && strcmp (tree->u.object.keys[i], "vnetInterfaces")
    && strcmp (tree->u.object.keys[i], "sysvmsg")
    && strcmp (tree->u.object.keys[i], "sysvsem")
    && strcmp (tree->u.object.keys[i], "sysvshm")
    && strcmp (tree->u.object.keys[i], "enforceStatfs")
    && strcmp (tree->u.object.keys[i], "allow")){
                if (ctx->options & OPT_PARSE_FULLKEY)
                  {
                    resi->u.object.keys[j] = tree->u.object.keys[i];
                    tree->u.object.keys[i] = NULL;
                    resi->u.object.values[j] = tree->u.object.values[i];
                    tree->u.object.values[i] = NULL;
                    resi->u.object.len++;
                  }
                j++;
              }
          }

        if ((ctx->options & OPT_PARSE_STRICT) && j > 0 && ctx->errfile != NULL)
          (void) fprintf (ctx->errfile, "WARNING: unknown key found\n");

        if (ctx->options & OPT_PARSE_FULLKEY)
          ret->_residual = resi;
      }
    return move_ptr (ret);
}

void
free_runtime_spec_schema_config_freebsd_jail (runtime_spec_schema_config_freebsd_jail *ptr)
{
    if (ptr == NULL)
        return;
    free (ptr->parent);
    ptr->parent = NULL;
    free (ptr->host);
    ptr->host = NULL;
    free (ptr->ip4);
    ptr->ip4 = NULL;
    if (ptr->ip4addr != NULL)
      {
        size_t i;
        for (i = 0; i < ptr->ip4addr_len; i++)
          {
            if (ptr->ip4addr[i] != NULL)
              {
                free (ptr->ip4addr[i]);
                ptr->ip4addr[i] = NULL;
            }
            }
        free (ptr->ip4addr);
        ptr->ip4addr = NULL;
    }
    free (ptr->ip6);
    ptr->ip6 = NULL;
    if (ptr->ip6addr != NULL)
      {
        size_t i;
        for (i = 0; i < ptr->ip6addr_len; i++)
          {
            if (ptr->ip6addr[i] != NULL)
              {
                free (ptr->ip6addr[i]);
                ptr->ip6addr[i] = NULL;
            }
            }
        free (ptr->ip6addr);
        ptr->ip6addr = NULL;
    }
    free (ptr->vnet);
    ptr->vnet = NULL;
    free (ptr->interface);
    ptr->interface = NULL;
    if (ptr->vnet_interfaces != NULL)
      {
        size_t i;
        for (i = 0; i < ptr->vnet_interfaces_len; i++)
          {
            if (ptr->vnet_interfaces[i] != NULL)
              {
                free (ptr->vnet_interfaces[i]);
                ptr->vnet_interfaces[i] = NULL;
            }
            }
        free (ptr->vnet_interfaces);
        ptr->vnet_interfaces = NULL;
    }
    free (ptr->sysvmsg);
    ptr->sysvmsg = NULL;
    free (ptr->sysvsem);
    ptr->sysvsem = NULL;
    free (ptr->sysvshm);
    ptr->sysvshm = NULL;
    if (ptr->allow != NULL)
      {
        free_runtime_spec_schema_config_freebsd_jail_allow (ptr->allow);
        ptr->allow = NULL;
      }
    yajl_tree_free (ptr->_residual);
    ptr->_residual = NULL;
    free (ptr);
    }
yajl_gen_status
gen_runtime_spec_schema_config_freebsd_jail (yajl_gen g, const runtime_spec_schema_config_freebsd_jail *ptr, const struct parser_context *ctx, parser_error *err)
{
    yajl_gen_status stat = yajl_gen_status_ok;
    *err = NULL;
    (void) ptr;  /* Silence compiler warning.  */
    stat = yajl_gen_map_open ((yajl_gen) g);
    if (stat != yajl_gen_status_ok)
        GEN_SET_ERROR_AND_RETURN (stat, err);
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->parent != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("parent"), 6 /* strlen ("parent") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->parent != NULL)
            str = ptr->parent;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->host != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("host"), 4 /* strlen ("host") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->host != NULL)
            str = ptr->host;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->ip4 != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("ip4"), 3 /* strlen ("ip4") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->ip4 != NULL)
            str = ptr->ip4;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->ip4addr != NULL))
      {
        size_t len = 0, i;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("ip4Addr"), 7 /* strlen ("ip4Addr") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->ip4addr != NULL)
          len = ptr->ip4addr_len;
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 0);
        stat = yajl_gen_array_open ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        for (i = 0; i < len; i++)
          {
            stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(ptr->ip4addr[i]), strlen (ptr->ip4addr[i]));
            if (stat != yajl_gen_status_ok)
                GEN_SET_ERROR_AND_RETURN (stat, err);
        }
        stat = yajl_gen_array_close ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 1);
        }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->ip6 != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("ip6"), 3 /* strlen ("ip6") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->ip6 != NULL)
            str = ptr->ip6;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->ip6addr != NULL))
      {
        size_t len = 0, i;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("ip6Addr"), 7 /* strlen ("ip6Addr") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->ip6addr != NULL)
          len = ptr->ip6addr_len;
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 0);
        stat = yajl_gen_array_open ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        for (i = 0; i < len; i++)
          {
            stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(ptr->ip6addr[i]), strlen (ptr->ip6addr[i]));
            if (stat != yajl_gen_status_ok)
                GEN_SET_ERROR_AND_RETURN (stat, err);
        }
        stat = yajl_gen_array_close ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 1);
        }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->vnet != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("vnet"), 4 /* strlen ("vnet") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->vnet != NULL)
            str = ptr->vnet;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->interface != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("interface"), 9 /* strlen ("interface") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->interface != NULL)
            str = ptr->interface;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->vnet_interfaces != NULL))
      {
        size_t len = 0, i;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("vnetInterfaces"), 14 /* strlen ("vnetInterfaces") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->vnet_interfaces != NULL)
          len = ptr->vnet_interfaces_len;
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 0);
        stat = yajl_gen_array_open ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        for (i = 0; i < len; i++)
          {
            stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(ptr->vnet_interfaces[i]), strlen (ptr->vnet_interfaces[i]));
            if (stat != yajl_gen_status_ok)
                GEN_SET_ERROR_AND_RETURN (stat, err);
        }
        stat = yajl_gen_array_close ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 1);
        }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->sysvmsg != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("sysvmsg"), 7 /* strlen ("sysvmsg") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->sysvmsg != NULL)
            str = ptr->sysvmsg;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->sysvsem != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("sysvsem"), 7 /* strlen ("sysvsem") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->sysvsem != NULL)
            str = ptr->sysvsem;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->sysvshm != NULL))
      {
        char *str = "";
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("sysvshm"), 7 /* strlen ("sysvshm") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->sysvshm != NULL)
            str = ptr->sysvshm;
        stat = yajl_gen_string ((yajl_gen)g, (const unsigned char *)(str), strlen (str));
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->enforce_statfs_present))
      {
        long long unsigned int num = 0;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("enforceStatfs"), 13 /* strlen ("enforceStatfs") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->enforce_statfs)
            num = (long long unsigned int)ptr->enforce_statfs;
        stat = map_uint (g, num);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->allow != NULL))
      {
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("allow"), 5 /* strlen ("allow") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        stat = gen_runtime_spec_schema_config_freebsd_jail_allow (g, ptr != NULL ? ptr->allow : NULL, ctx, err);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if (ptr != NULL && ptr->_residual != NULL)
      {
        stat = gen_yajl_object_residual (ptr->_residual, g, err);
        if (yajl_gen_status_ok != stat)
            GEN_SET_ERROR_AND_RETURN (stat, err);
      }
    stat = yajl_gen_map_close ((yajl_gen) g);
    if (stat != yajl_gen_status_ok)
        GEN_SET_ERROR_AND_RETURN (stat, err);
    return yajl_gen_status_ok;
}

runtime_spec_schema_config_freebsd_jail *
clone_runtime_spec_schema_config_freebsd_jail (runtime_spec_schema_config_freebsd_jail *src)
{
    (void) src;  /* Silence compiler warning.  */
    __auto_cleanup(free_runtime_spec_schema_config_freebsd_jail) runtime_spec_schema_config_freebsd_jail *ret = NULL;

    ret = calloc (1, sizeof (*ret));
    if (ret == NULL)
      return NULL;
    if (src->parent != NULL)
      {
        ret->parent = strdup (src->parent);
        if (ret->parent == NULL)
          return NULL;
      }
    if (src->host != NULL)
      {
        ret->host = strdup (src->host);
        if (ret->host == NULL)
          return NULL;
      }
    if (src->ip4 != NULL)
      {
        ret->ip4 = strdup (src->ip4);
        if (ret->ip4 == NULL)
          return NULL;
      }
    if (src->ip4addr)
      {
        ret->ip4addr_len = src->ip4addr_len;
        ret->ip4addr = calloc (src->ip4addr_len + 1, sizeof (*ret->ip4addr));
        if (ret->ip4addr == NULL)
          return NULL;
        for (size_t i = 0; i < src->ip4addr_len; i++)
          {
            if (src->ip4addr[i])
              {
                ret->ip4addr[i] = strdup (src->ip4addr[i]);
                if (ret->ip4addr[i] == NULL)
                    return NULL;
              }
        }
        }
    if (src->ip6 != NULL)
      {
        ret->ip6 = strdup (src->ip6);
        if (ret->ip6 == NULL)
          return NULL;
      }
    if (src->ip6addr)
      {
        ret->ip6addr_len = src->ip6addr_len;
        ret->ip6addr = calloc (src->ip6addr_len + 1, sizeof (*ret->ip6addr));
        if (ret->ip6addr == NULL)
          return NULL;
        for (size_t i = 0; i < src->ip6addr_len; i++)
          {
            if (src->ip6addr[i])
              {
                ret->ip6addr[i] = strdup (src->ip6addr[i]);
                if (ret->ip6addr[i] == NULL)
                    return NULL;
              }
        }
        }
    if (src->vnet != NULL)
      {
        ret->vnet = strdup (src->vnet);
        if (ret->vnet == NULL)
          return NULL;
      }
    if (src->interface != NULL)
      {
        ret->interface = strdup (src->interface);
        if (ret->interface == NULL)
          return NULL;
      }
    if (src->vnet_interfaces)
      {
        ret->vnet_interfaces_len = src->vnet_interfaces_len;
        ret->vnet_interfaces = calloc (src->vnet_interfaces_len + 1, sizeof (*ret->vnet_interfaces));
        if (ret->vnet_interfaces == NULL)
          return NULL;
        for (size_t i = 0; i < src->vnet_interfaces_len; i++)
          {
            if (src->vnet_interfaces[i])
              {
                ret->vnet_interfaces[i] = strdup (src->vnet_interfaces[i]);
                if (ret->vnet_interfaces[i] == NULL)
                    return NULL;
              }
        }
        }
    if (src->sysvmsg != NULL)
      {
        ret->sysvmsg = strdup (src->sysvmsg);
        if (ret->sysvmsg == NULL)
          return NULL;
      }
    if (src->sysvsem != NULL)
      {
        ret->sysvsem = strdup (src->sysvsem);
        if (ret->sysvsem == NULL)
          return NULL;
      }
    if (src->sysvshm != NULL)
      {
        ret->sysvshm = strdup (src->sysvshm);
        if (ret->sysvshm == NULL)
          return NULL;
      }
    ret->enforce_statfs = src->enforce_statfs;
    ret->enforce_statfs_present = src->enforce_statfs_present;
    if (src->allow)
      {
        ret->allow = clone_runtime_spec_schema_config_freebsd_jail_allow (src->allow);
        if (ret->allow == NULL)
          return NULL;
      }
    return move_ptr (ret);
}

define_cleaner_function (runtime_spec_schema_config_freebsd *, free_runtime_spec_schema_config_freebsd)
runtime_spec_schema_config_freebsd *
make_runtime_spec_schema_config_freebsd (yajl_val tree, const struct parser_context *ctx, parser_error *err)
{
    __auto_cleanup(free_runtime_spec_schema_config_freebsd) runtime_spec_schema_config_freebsd *ret = NULL;
    *err = NULL;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
      return NULL;
    ret = calloc (1, sizeof (*ret));
    if (ret == NULL)
      return NULL;
    do
      {
        yajl_val tmp = get_val (tree, "devices", yajl_t_array);
        if (tmp != NULL && YAJL_GET_ARRAY (tmp) != NULL)
          {
            size_t i;
            size_t len = YAJL_GET_ARRAY_NO_CHECK (tmp)->len;
            yajl_val *values = YAJL_GET_ARRAY_NO_CHECK (tmp)->values;
            ret->devices_len = len;
            ret->devices = calloc (len + 1, sizeof (*ret->devices));
            if (ret->devices == NULL)
              return NULL;
            for (i = 0; i < len; i++)
              {
                yajl_val val = values[i];
                ret->devices[i] = make_runtime_spec_schema_defs_freebsd_device (val, ctx, err);
                if (ret->devices[i] == NULL)
                  return NULL;
    }
        }
      }
    while (0);
    ret->jail = make_runtime_spec_schema_config_freebsd_jail (get_val (tree, "jail", yajl_t_object), ctx, err);
    if (ret->jail == NULL && *err != 0)
      return NULL;
    if (tree->type == yajl_t_object)
      {
        size_t i;
        size_t j = 0;
        size_t cnt = tree->u.object.len;
        yajl_val resi = NULL;

        if (ctx->options & OPT_PARSE_FULLKEY)
          {
            resi = calloc (1, sizeof(*tree));
            if (resi == NULL)
              return NULL;

            resi->type = yajl_t_object;
            resi->u.object.keys = calloc (cnt, sizeof (const char *));
            if (resi->u.object.keys == NULL)
              {
                yajl_tree_free (resi);
                return NULL;
              }
            resi->u.object.values = calloc (cnt, sizeof (yajl_val));
            if (resi->u.object.values == NULL)
              {
                yajl_tree_free (resi);
                return NULL;
              }
          }

        for (i = 0; i < tree->u.object.len; i++)
          {
            if (strcmp (tree->u.object.keys[i], "devices")
    && strcmp (tree->u.object.keys[i], "jail")){
                if (ctx->options & OPT_PARSE_FULLKEY)
                  {
                    resi->u.object.keys[j] = tree->u.object.keys[i];
                    tree->u.object.keys[i] = NULL;
                    resi->u.object.values[j] = tree->u.object.values[i];
                    tree->u.object.values[i] = NULL;
                    resi->u.object.len++;
                  }
                j++;
              }
          }

        if ((ctx->options & OPT_PARSE_STRICT) && j > 0 && ctx->errfile != NULL)
          (void) fprintf (ctx->errfile, "WARNING: unknown key found\n");

        if (ctx->options & OPT_PARSE_FULLKEY)
          ret->_residual = resi;
      }
    return move_ptr (ret);
}

void
free_runtime_spec_schema_config_freebsd (runtime_spec_schema_config_freebsd *ptr)
{
    if (ptr == NULL)
        return;
    if (ptr->devices != NULL)
      {
        size_t i;
        for (i = 0; i < ptr->devices_len; i++)
          {
        if (ptr->devices[i] != NULL)
          {
            free_runtime_spec_schema_defs_freebsd_device (ptr->devices[i]);
            ptr->devices[i] = NULL;
          }
        }
        free (ptr->devices);
        ptr->devices = NULL;
    }
    if (ptr->jail != NULL)
      {
        free_runtime_spec_schema_config_freebsd_jail (ptr->jail);
        ptr->jail = NULL;
      }
    yajl_tree_free (ptr->_residual);
    ptr->_residual = NULL;
    free (ptr);
    }
yajl_gen_status
gen_runtime_spec_schema_config_freebsd (yajl_gen g, const runtime_spec_schema_config_freebsd *ptr, const struct parser_context *ctx, parser_error *err)
{
    yajl_gen_status stat = yajl_gen_status_ok;
    *err = NULL;
    (void) ptr;  /* Silence compiler warning.  */
    stat = yajl_gen_map_open ((yajl_gen) g);
    if (stat != yajl_gen_status_ok)
        GEN_SET_ERROR_AND_RETURN (stat, err);
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->devices != NULL))
      {
        size_t len = 0, i;
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("devices"), 7 /* strlen ("devices") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        if (ptr != NULL && ptr->devices != NULL)
            len = ptr->devices_len;
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 0);
        stat = yajl_gen_array_open ((yajl_gen) g);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        for (i = 0; i < len; i++)
          {
            stat = gen_runtime_spec_schema_defs_freebsd_device (g, ptr->devices[i], ctx, err);
            if (stat != yajl_gen_status_ok)
                GEN_SET_ERROR_AND_RETURN (stat, err);
        }
        stat = yajl_gen_array_close ((yajl_gen) g);
        if (!len && !(ctx->options & OPT_GEN_SIMPLIFY))
            yajl_gen_config (g, yajl_gen_beautify, 1);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if ((ctx->options & OPT_GEN_KEY_VALUE) || (ptr != NULL && ptr->jail != NULL))
      {
        stat = yajl_gen_string ((yajl_gen) g, (const unsigned char *)("jail"), 4 /* strlen ("jail") */);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
        stat = gen_runtime_spec_schema_config_freebsd_jail (g, ptr != NULL ? ptr->jail : NULL, ctx, err);
        if (stat != yajl_gen_status_ok)
            GEN_SET_ERROR_AND_RETURN (stat, err);
    }
    if (ptr != NULL && ptr->_residual != NULL)
      {
        stat = gen_yajl_object_residual (ptr->_residual, g, err);
        if (yajl_gen_status_ok != stat)
            GEN_SET_ERROR_AND_RETURN (stat, err);
      }
    stat = yajl_gen_map_close ((yajl_gen) g);
    if (stat != yajl_gen_status_ok)
        GEN_SET_ERROR_AND_RETURN (stat, err);
    return yajl_gen_status_ok;
}

runtime_spec_schema_config_freebsd *
clone_runtime_spec_schema_config_freebsd (runtime_spec_schema_config_freebsd *src)
{
    (void) src;  /* Silence compiler warning.  */
    __auto_cleanup(free_runtime_spec_schema_config_freebsd) runtime_spec_schema_config_freebsd *ret = NULL;

    ret = calloc (1, sizeof (*ret));
    if (ret == NULL)
      return NULL;
    if (src->devices)
      {
        ret->devices_len = src->devices_len;
        ret->devices = calloc (src->devices_len + 1, sizeof (*ret->devices));
        if (ret->devices == NULL)
          return NULL;
        for (size_t i = 0; i < src->devices_len; i++)
          {
            ret->devices[i] = clone_runtime_spec_schema_defs_freebsd_device (src->devices[i]);
            if (ret->devices[i] == NULL)
                return NULL;
        }
        }
    if (src->jail)
      {
        ret->jail = clone_runtime_spec_schema_config_freebsd_jail (src->jail);
        if (ret->jail == NULL)
          return NULL;
      }
    return move_ptr (ret);
}

