include(RunCMake)

run_cmake(CMP0078-WARN)
run_cmake(CMP0078-OLD)
run_cmake(CMP0078-NEW)

run_cmake(CMP0086-WARN)

if (CMake_TEST_FindPython2 OR CMake_TEST_FindPython3)

  macro(run_cmake_target test subtest target)
    set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${test}-build)
    set(RunCMake_TEST_NO_CLEAN 1)
    run_cmake_command(${test}-${subtest} ${CMAKE_COMMAND} --build . --target ${target} ${ARGN})

    unset(RunCMake_TEST_BINARY_DIR)
    unset(RunCMake_TEST_NO_CLEAN)
  endmacro()

  run_cmake(CMP0086-OLD)
  run_cmake_target(CMP0086-OLD build example)
  run_cmake(CMP0086-NEW)
  run_cmake_target(CMP0086-NEW build example)

  block()
    run_cmake(SetPOSTFIX)
    set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/SetPOSTFIX-build)
    set(RunCMake_TEST_NO_CLEAN 1)
    run_cmake_command(SetPOSTFIX-build ${CMAKE_COMMAND} --build . --config $<CONFIG>)
    run_cmake_command(SetPOSTFIX-run ${CMAKE_CTEST_COMMAND} -C $<CONFIG> -V)
  endblock()
endif()

run_cmake(CMP0122-WARN)
run_cmake(CMP0122-OLD)
run_cmake(CMP0122-NEW)
