/***************************************************************
 *
 * Copyright (C) 2024, Pelican Project, Morgridge Institute for Research
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/

#pragma once

#include <map>
#include <string>
#include <string_view>

namespace AWSv4Impl {

std::string pathEncode(const std::string &original);

std::string amazonURLEncode(const std::string &input);

std::string
canonicalizeQueryString(const std::map<std::string, std::string> &qp);

void convertMessageDigestToLowercaseHex(const unsigned char *messageDigest,
										unsigned int mdLength,
										std::string &hexEncoded);

bool doSha256(const std::string_view payload, unsigned char *messageDigest,
			  unsigned int *mdLength);

bool createSignature(const std::string &secretAccessKey,
					 const std::string &date, const std::string &region,
					 const std::string &service,
					 const std::string &stringToSign, std::string &signature);

} // namespace AWSv4Impl
