#pragma once

#ifdef GUI_WIN32

namespace gui {

	/**
	 * Wrapper around the windows MSG struct.
	 */
	class Message : public Printable {
	public:
		Message(const MSG &msg);
		Message(UINT msg, WPARAM wParam, LPARAM lParam);

		UINT msg;
		WPARAM wParam;
		LPARAM lParam;

		// May be extended in the future.

	protected:
		virtual void output(wostream &to) const;
	};

	/**
	 * Result from a message handling function. Returns if there is a response availiable or not as
	 * well as the actual response.
	 */
	struct MsgResult {
		bool any;
		bool notify;
		LRESULT result;
	};

	MsgResult noResult();
	MsgResult noResultNotify();
	MsgResult msgResult(LRESULT result);

}

#endif
