#pragma once
#include "Handle.h"
#include "Core/Graphics/ImageSet.h"

namespace gui {

	/**
	 * An icon is a set of multiple-sized images that represent the same thing. These can be used as
	 * icons for windows, etc.
	 *
	 * In this way, an Icon is similar to ImageSet. This class does, however, provide the ability to
	 * convert an ImageSet into a representation that is more suitable for the current GUI framework.
	 */
	class Icon : public ObjectOn<Ui> {
		STORM_CLASS;
	public:
		// Create.
		STORM_CTOR Icon(ImageSet *from);

		// Destroy.
		virtual ~Icon();

#ifdef GUI_WIN32
		HICON win32Small() const { return smallIcon.icon(); }
		HICON win32Large() const { return largeIcon.icon(); }
#endif
#ifdef GUI_GTK
		GList *gtkList() const;
#endif

	private:
		// For Win32: large and small icons.
		Handle largeIcon;
		Handle smallIcon;

		// For Gtk: list of GdkPixbuf.
		GcArray<GdkPixbuf *> *gtkImages;
	};

}
