---
description: "Learn more about: Forest-Wide Updates"
ms.assetid: 3647b7e3-54a4-46c6-ab68-82fcf3bfacda
title: Active Directory Forest-Wide Updates
author: iainfoulds
ms.author: daveba
manager: daveba
ms.date: 10/29/2018
ms.topic: article
---
# Forest-Wide Updates

>Applies to: Windows Server 2022, Windows Server 2019, Windows Server

You can review the following set of changes to help understand and prepare for the schema updates that are performed by adprep /forestprep in Windows Server 2019.

Beginning in Windows Server 2012, Adprep commands run automatically as needed during AD DS installation. They can also be run separately in advance of AD DS installation. For more information, see [Running Adprep.exe](/previous-versions/windows/it-pro/windows-server-2008-R2-and-2008/dd464018(v=ws.10)).

For more information about how to interpret the access control entry (ACE) strings, see [ACE strings](/windows/win32/secauthz/ace-strings). For more information about how to interpret the security ID (SID) strings, see [SID strings](/windows/win32/secauthz/sid-strings).

## Windows Server 2016: Forest-wide updates

After the operations that are performed by the **forestprep** command in Windows Server 2016 (operations 136-142) are complete, the **revision** attribute for the CN=ActiveDirectoryUpdate,CN=ForestUpdates,CN=Configuration,DC=ForestRootDomain object is set to **16**.

| Operation number and GUID | Description | Attributes | Permissions |
|--|--|--|--|
| **Operation 136**: {328092FB-16E7-4453-9AB8-7592DB56E9C4} | Granting the "CN=Send-As,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |
| **Operation 137**: {3A1C887F-DF0A-489F-B3F2-2D0409095F6E} | Granting the "CN=Receive-As,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |
| **Operation 138**: {232E831F-F988-4444-8E3E-8A352E2FD411} | Granting the "CN=Personal-Information,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |
| **Operation 139**: {DDDDCF0C-BEC9-4A5A-AE86-3CFE6CC6E110} | Granting the "CN=Public-Information,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |
| **Operation 140**: {A0A45AAC-5550-42DF-BB6A-3CC5C46B52F2} | Granting the "CN=Validated-SPN,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |
| **Operation 141**: {3E7645F3-3EA5-4567-B35A-87630449C70C} | Granting the "CN=Allowed-To-Authenticate,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |
| **Operation 142**: {E634067B-E2C4-4D79-B6E8-73C619324D5E} | Granting the "CN=MS-TS-GatewayAccess,CN=Extended-Rights" to gMSA accounts. | N/A | N/A |

## Windows Server 2012 R2: Forest-wide updates

After the operations that are performed by the **forestprep** command in Windows Server 2012 R2 (operations 131-135) are complete, the **revision** attribute for the CN=ActiveDirectoryUpdate,CN=ForestUpdates,CN=Configuration,DC=ForestRootDomain object is set to **15**.

| Operation number and GUID | Description | Attributes | Permissions |
|--|--|--|--|
| **Operation 131**: {b83818c1-01a6-4f39-91b7-a3bb581c3ae3} | Created a new authentication policy configuration container object CN=AuthN Policy Configuration,CN=Services in the Configuration partition. | -   objectClass: container<br />-   displayName: Authentication Policy Configuration<br />-   description: Contains configuration for authentication policy.<br />-   showInAdvancedViewOnly: True | (A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY) |
| **Operation 132**: {bbbb9db0-4009-4368-8c40-6674e980d3c3} | Created a new authentication policies object CN=AuthN Policies,CN=AuthN Policy Configuration,CN=Services in the Configuration partition. | -   objectClass: msDS-AuthNPolicies<br />-   displayName: Authentication Policies<br />-   description: Contains authentication policy objects.<br />-   showInAdvancedViewOnly: True | (A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)<br />(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)<br />(A;;RPLCLORC;;;AU) |
| **Operation 133**: {f754861c-3692-4a7b-b2c2-d0fa28ed0b0b} | Created a new authentication policy silos object CN=AuthN Silos,CN=AuthN Policy Configuration,CN=Services in the Configuration partition. | -   objectClass: msDS-AuthNPolicySilos<br />-   displayName: Authentication Policy Silos<br />-   description: Contains authentication policy silo objects.<br />-   showInAdvancedViewOnly: True | (A;;RPWPCRCCDCLCLOLORCWOWDSDDTDTSW;;;EA)<br />(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)<br />(A;;RPLCLORC;;;AU) |
| **Operation 134**: {d32f499f-3026-4af0-a5bd-13fe5a331bd2} | Created a new authentication silo claim type object CN=ad://ext/AuthenticationSilo,CN=Claim Types,CN=Claims Configuration,CN=Services in the Configuration partition. | -   objectClass: msDS-ClaimType<br />-   displayname: AuthenticationSilo<br />-   name: ad://ext/AuthenticationSilo<br />-   Enabled: True<br />-   msDS-ClaimIsValueSpaceRestricted: True<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-ClaimSourceType: Constructed<br />-   msDS-ClaimValueType: 3<br />-   msDS-ClaimTypeAppliesToClass: CN=User,CN=Schema,%ws<br />-   msDS-ClaimTypeAppliesToClass: CN=Computer,CN=Schema,%ws<br />-   msDS-ClaimTypeAppliesToClass: CN=ms-DS-Managed-Service-Account,CN=Schema,%ws<br />-   msDS-ClaimTypeAppliesToClass: CN=ms-DS-Group-Managed-Service-Account,CN=Schema,%ws | (A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;EA)<br />(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)<br />(A;;RPLCLORC;;;AU) |
| **Operation 135**: {38618886-98ee-4e42-8cf1-d9a2cd9edf8b} | Set the msDS-ClaimIsValueSpaceRestricted attribute on new authentication silo claim type to false | -   msDS-ClaimIsValueSpaceRestricted: False | N/A |

## Windows Server 2012: Forest-wide updates

After the operations that are performed by the **forestprep** command in Windows Server 2012 (operations 84-130) are complete, the **revision** attribute for the CN=ActiveDirectoryUpdate,CN=ForestUpdates,CN=Configuration,DC=ForestRootDomain object is set to **11**.

|Operation number and GUID|Description|Attributes|Permissions|
|-----------------------------|---------------|--------------|---------------|
|**Operation 84**: {4664e973-cb20-4def-b3d5-559d6fe123e0}|Created a new container CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: container|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 85**: {2972d92d-a07a-44ac-9cb0-bf243356f345}|Created a new object CN=Claim Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ClaimTypes<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCDCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 86**: {09a49cb3-6c54-4b83-ab20-8370838ba149}|Created a new object CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperties<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCDCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 87**: {77283e65-ce02-4dc3-8c1e-bf99b22527c2}|Created a new container CN=Resource Property Lists,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: container<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCDCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 88**: {0afb7f53-96bd-404b-a659-89e65c269420}|Created a new object CN=Sam-Domain in the Schema partition.|N/A|Created the following access control entry (ACE) to grant Write Property to Principal Self on the object:<p>(OA;CIIO;WP;ea1b7b93-5e48-46d5-bc6c-4df4fda78a35;bf967a86-0de6-11d0-a285-00aa003049e2;PS)|
|**Operation 89**: {c7f717ef-fdbe-4b4b-8dfc-fa8b839fbcfa}|Created a new object CN=Domain-DNS in the Schema partition.|N/A|Created the following access control entry (ACE) to grant Write Property to Principal Self on the object:<p>(OA;CIIO;WP;ea1b7b93-5e48-46d5-bc6c-4df4fda78a35;bf967a86-0de6-11d0-a285-00aa003049e2;PS)|
|**Operation 90**: {00232167-f3a4-43c6-b503-9acb7a81b01c}|Call back function to upgrade display specifiers.|N/A|N/A|
|**Operation 91**: {73a9515b-511c-44d2-822b-444a33d3bd33}|Created a new container CN=Microsoft SPP,CN=Services in the Configuration partition.|-   objectClass: container<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 92**: {e0c60003-2ed7-4fd3-8659-7655a7e79397}|Created a new Activation Objects container CN=Activation Objects,CN=Microsoft SPP,CN=Services in the Configuration partition.|-   objectClass: msSPP-ActivationObjectsContainer<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 93**: {ed0c8cca-80ab-4b6b-ac5a-59b1d317e11f}|Created a new Central Access Policies container CN=Central Access Policies,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msAuthz-CentralAccessPolicies<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCDCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 94**: {b6a6c19a-afc9-476b-8994-61f5b14b3f05}|Created a new Central Access Policy Entries container CN=Central Access Rules,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msAuthz-CentralAccessRules<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCDCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 95**: {defc28cd-6cb6-4479-8bcb-aabfb41e9713}|Created a new Group Key Distribution service container CN=Group Key Distribution Service,CN=Services in the Configuration partition.|-   objectClass: container<br />-   description: The container contains configuration and data for Group Key Distribution Service.<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 96**: {d6bd96d4-e66b-4a38-9c6b-e976ff58c56d}|Created a new Master Root Keys container CN=Master Root Keys,CN=Group Key Distribution Service,CN=Services in the Configuration partition.|-   objectClass: container<br />-   description: The container contains master root keys for Group Key Distribution Service.<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 97**: {bb8efc40-3090-4fa2-8a3f-7cd1d380e695}|Created a new Server Configuration container CN=Server Configuration,CN=Group Key Distribution Service,CN=Services in the Configuration partition.|-   objectClass: container<br />-   description: The container contains Group Key Distribution Service configurations.<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 98**: {2d6abe1b-4326-489e-920c-76d5337d2dc5}|Created a new Empty server configuration objects container CN=Group Key Distribution Service Server Configuration,CN=Server Configuration,CN=Group Key Distribution Service,CN=Services in the Configuration partition.|-   objectClass: msKds-ProvServerConfiguration<br />-   description: The configuration of cryptography algorithms used by Group Key Distribution Service.<br />-   msKds-Version: 1<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 99**: {6b13dfb5-cecc-4fb8-b28d-0505cea24175}|Created a new Claims Transformation Policies configuration container CN=Claims Transformation Policies,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ClaimsTransformationPolicies<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCDCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 100**: {92e73422-c68b-46c9-b0d5-b55f9c741410}|Created a new Value Types configuration container CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: container<br />-   showInAdvancedViewOnly: True|(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 101**: {c0ad80b4-8e84-4cc4-9163-2f84649bcc42}|Created a new SinglevaluedChoice value type configuration object CN=MS-DS-SinglevaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author a resource property. When assigning value to a resource property of this value type, a user can choose only one entry from a list of suggested values.<br />-   displayname: Single-valued Choice<br />-   msDS-ClaimValueType: 3<br />-   msDS-ClaimIsValueSpaceRestricted: True<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-IsPossibleValuesPresent: True<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 102**: {992fe1d0-6591-4f24-a163-c820fcb7f308}|Created a new YesNo value type configuration object CN=MS-DS-YesNo,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: The valid values for this type are Yes or No.<br />-   displayname: Yes/No<br />-   msDS-ClaimValueType: 6<br />-   msDS-ClaimIsValueSpaceRestricted: False<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-IsPossibleValuesPresent: False<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 103**: {ede85f96-7061-47bf-b11b-0c0d999595b5}|Created a new Number value type configuration object CN=MS-DS-Number,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author resource properties that contain a single number.<br />-   displayname: Number<br />-   msDS-ClaimValueType: 1<br />-   msDS-ClaimIsValueSpaceRestricted: False<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-IsPossibleValuesPresent: False<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 104**: {ee0f3271-eb51-414a-bdac-8f9ba6397a39}|Created a new DateTime value type configuration object CN=MS-DS-DateTime,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author resource properties that are of the date and time format.<br />-   displayname: Date Time<br />-   msDS-ClaimValueType: 1<br />-   msDS-ClaimIsValueSpaceRestricted: False<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-IsPossibleValuesPresent: False<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 105**: {587d52e0-507e-440e-9d67-e6129f33bb68}|Created a new OrderedList value type configuration object CN=MS-DS-OrderedList,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author resource properties that contain a single choice entry that can be compared to other resource properties of the same type. A user typically chooses the entry from a list of ordered suggested values that are provided by ms-DS-Claim-Possible-Values on the resource properties.<br />-   displayname: Ordered List<br />-   msDS-ClaimValueType: 1<br />-   msDS-ClaimIsValueSpaceRestricted: True<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-IsPossibleValuesPresent: True<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 106**: {ce24f0f6-237e-43d6-ac04-1e918ab04aac}|Created a new Text value type configuration object CN=MS-DS-Text,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author resource properties that contain a single text entry.<br />-   displayname: Text<br />-   msDS-ClaimValueType: 3<br />-   msDS-ClaimIsValueSpaceRestricted: False<br />-   msDS-ClaimIsSingleValued: True<br />-   msDS-IsPossibleValuesPresent: False<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 107**: {7f77d431-dd6a-434f-ae4d-ce82928e498f}|Created a new MultivaluedText value type configuration object CN=MS-DS-MultivaluedText,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author resource properties that can have multiple text entries.<br />-   displayname: Multi-valued Text<br />-   msDS-ClaimValueType: 3<br />-   msDS-ClaimIsValueSpaceRestricted: False<br />-   msDS-ClaimIsSingleValued: False<br />-   msDS-IsPossibleValuesPresent: False<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 108**: {ba14e1f6-7cd1-4739-804f-57d0ea74edf4}|Created a new MultivaluedChoice value type configuration object CN=MS-DS-MultivaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ValueType<br />-   description: You can use this type to author resource properties that can have multiple entries that cannot be compared. A user typically chooses each entry from a list of suggested values that are provided by ms-DS-Claim-Possible-Values on the resource properties.<br />-   displayname: Multi-valued Choice<br />-   msDS-ClaimValueType: 3<br />-   msDS-ClaimIsValueSpaceRestricted: True<br />-   msDS-ClaimIsSingleValued: False<br />-   msDS-IsPossibleValuesPresent: True<br />-   showInAdvancedViewOnly: True|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 109**: {156ffa2a-e07c-46fb-a5c4-fbd84a4e5cce}|Created a new Personally Identifiable Information resource property object CN=PII_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Personally Identifiable Information (PII) property specifies whether the resource contains PII and if it does, what the sensitivity level of that information is.<br />-   displayname: Personally Identifiable Information<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-OrderedList,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 110**: {7771d7dd-2231-4470-aa74-84a6f56fc3b6}|Created a new Protected Health Information resource property object CN=ProtectedHealthInformation_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Protected Health Information (PHI) property specifies whether the resource contains any data related to an individual's medical record or medical payment history.<br />-   displayname: Protected Health Information<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-YesNo,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 111**: {49b2ae86-839a-4ea0-81fe-9171c1b98e83}|Created a new Required Clearance resource property object CN=RequiredClearance_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Required Clearance property specifies the level of clearance a user should possess before attempting to access the resource.<br />-   displayname: Required Clearance<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-OrderedList,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 112**: {1b1de989-57ec-4e96-b933-8279a8119da4}|Created a new Confidentiality resource property object CN=Confidentiality_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Confidentiality property specifies the level of confidentiality of the resource, and the potential impact of inadvertent access or disclosure.<br />-   displayname: Confidentiality<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-OrderedList,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 113**: {281c63f0-2c9a-4cce-9256-a238c23c0db9}|Created a new Compliancy resource property object CN=Compliancy_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Compliancy property specifies the compliance frameworks that apply to the resource.<br />-   displayname: Compliancy<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-MultivaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 114**: {4c47881a-f15a-4f6c-9f49-2742f7a11f4b}|Created a new Discoverability resource property object CN=Discoverability_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Discoverability property specifies whether the resource contains potential evidence that might require disclosure to opposing legal counsel during the course of current or future litigation.<br />-   displayname: Discoverability<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-SinglevaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 115**: {2aea2dc6-d1d3-4f0c-9994-66c1da21de0f}|Created a new Immutable resource property object CN=Immutable_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Immutable property specifies whether a user should be allowed to delete a resource or change its contents.<br />-   displayname: Immutable<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-YesNo,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 116**: {ae78240c-43b9-499e-ae65-2b6e0f0e202a}|Created a new Intellectual Property resource property object CN=IntellectualProperty_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Intellectual Property (IP) property specifies whether the resource contains IP, and if so, what kind.<br />-   displayname: Intellectual Property<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-SinglevaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 117**: {261b5bba-3438-4d5c-a3e9-7b871e5f57f0}|Created a new Department resource property object CN=Department_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Department property specifies the name of the department to which  the resource belongs.<br />-   displayname: Department<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-SinglevaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 118**: {3fb79c05-8ea1-438c-8c7a-81f213aa61c2}|Created a new Impact resource property object CN=Impact_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Impact property specifies the degree of organizational impact from inappropriate access or loss of the resource.<br />-   displayname: Impact<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-OrderedList,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain<br />-   msDS-ClaimPossibleValues: High - High business impact (HBI) - 3000, Moderate - Medium business impact (MBI) - 2000, Low - Low business impact (LBI) - 1000>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 119**: {0b2be39a-d463-4c23-8290-32186759d3b1}|Created a new Personal Use resource property object CN=PersonalUse_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Personal Use property specifies whether the file is for personal use (not business related).<br />-   displayname: Personal Use<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-YesNo,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 120**: {f0842b44-bc03-46a1-a860-006e8527fccd}|Created a new Project resource property object CN=Project_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Project property specifies the names of one or more projects that are relevant to the resource.<br />-   displayname: Project<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-MultivaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 121**: {93efec15-4dd9-4850-bc86-a1f2c8e2ebb9}|Created a new Retention Period resource property object CN=RetentionPeriod_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Retention Period property specifies the maximum period for which the file should be retained.<br />-   displayname: Retention Period<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-SinglevaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 122**: {9e108d96-672f-40f0-b6bd-69ee1f0b7ac4}|Created a new Retention Start Date resource property object CN=RetentionStartDate_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Retention Start Date property defines the starting date for a Retention Period. The retention period would begin on the Retention Start Date.<br />-   displayname: Retention Start Date<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: False<br />-   msDS-ValueTypeReference: CN=MS-DS-DateTime,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 123**: {1e269508-f862-4c4a-b01f-420d26c4ff8c}|Created a new Company resource property object CN=Company_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Company property specifies which company the resource belongs to.<br />-   displayname: Company<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: True<br />-   msDS-ValueTypeReference: CN=MS-DS-SinglevaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 125**: {e1ab17ed-5efb-4691-ad2d-0424592c5755} **Note:** Operation 124 was deleted.|Created a new Folder Usage resource property object CN=FolderUsage_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourceProperty<br />-   description: The Folder Usage property specifies the purpose of the folder and the kind of files stored in it.<br />-   displayname: Folder Usage<br />-   Enabled: False<br />-   msDS-IsUsedAsResourceSecurityAttribute: False<br />-   msDS-AppliestoResourceTypes: MS-DS-Container<br />-   msDS-ValueTypeReference: CN=MS-DS-MultivaluedChoice,CN=Value Types,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 126**: {0e848bd4-7c70-48f2-b8fc-00fbaa82e360}|Created a new Global Resource Property List configuration object CN=Global Resource Property List,CN=Resource Property Lists,CN=Claims Configuration,CN=Services in the Configuration partition.|-   objectClass: msDS-ResourcePropertyList<br />-   description: This is a global out of box resource property list that contains all resource properties that can be consumed by applications.<br />-   showInAdvancedViewOnly: True<br />-   msDS-MembersOfResourcePropertyList: CN=PII_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=ProtectedHealthInformation_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=RequiredClearance_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Confidentiality_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Compliancy_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Discoverability_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Immutable_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=IntellectualProperty_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Department_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Impact_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=PersonalUse_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Project_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=RetentionPeriod_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=RetentionStartDate_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=Company_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain><br />-   msDS-MembersOfResourcePropertyList: CN=FolderUsage_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services,CN=Configuration,CN=\<forest root domain>|(D;;SDDT;;;WD)<br />(A;;RPLCLORC;;;AU)<br />(A;;RPWPCRLCLOCCRCWDWOSW;;;EA)<br />(A;;RPWPCRLCLOCCDCRCWDWOSDDTSW;;;SY)|
|**Operation 127**: {016f23f7-077d-41fa-a356-de7cfdb01797}|Call back function to upgrade display specifiers.|N/A|N/A|
|**Operation 128**: {49c140db-2de3-44c2-a99a-bab2e6d2ba81}|Updated strings for Folder Usage resource property object CN=FolderUsage_MS,CN=Resource Properties,CN=Claims Configuration,CN=Services in the Configuration partition.|-   description: The Folder Usage property specifies the purpose of the folder and the kind of files stored in it.|N/A|
|**Operation 129**: {e0b11c80-62c5-47f7-ad0d-3734a71b8312}|Added ACE to grant Principal Self Write Property and Read Property on CN=Sam-Domain object.|N/A|(OA;CIOI;RPWP;3f78c3e5-f79a-46bd-a0b8-9d18116ddc79;;PS)|
|**Operation 130**: {2ada1a2d-b02f-4731-b4fe-59f955e24f71}|Added ACE to grant Principal Self Write Property and Read Property on CN=Domain-DNS object.|N/A|(OA;CIOI;RPWP;3f78c3e5-f79a-46bd-a0b8-9d18116ddc79;;PS)|
