#pragma once
/*
 *  $Id: color-swatch.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_COLOR_SWATCH_H__
#define __GWYUI_COLOR_SWATCH_H__

#include <gtk/gtk.h>
#include <libgwyddion/rgba.h>

G_BEGIN_DECLS

#define GWY_TYPE_COLOR_SWATCH            (gwy_color_swatch_get_type())
#define GWY_COLOR_SWATCH(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_COLOR_SWATCH, GwyColorSwatch))
#define GWY_COLOR_SWATCH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_COLOR_SWATCH, GwyColorSwatchClass))
#define GWY_IS_COLOR_SWATCH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_COLOR_SWATCH))
#define GWY_IS_COLOR_SWATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_COLOR_SWATCH))
#define GWY_COLOR_SWATCH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_COLOR_SWATCH, GwyColorSwatchClass))

typedef struct _GwyColorSwatch             GwyColorSwatch;
typedef struct _GwyColorSwatchClass        GwyColorSwatchClass;
typedef struct _GwyColorSwatchPrivate      GwyColorSwatchPrivate;

struct _GwyColorSwatch {
    GtkWidget widget;
    GwyColorSwatchPrivate *priv;
};

struct _GwyColorSwatchClass {
    GtkWidgetClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType      gwy_color_swatch_get_type     (void)                    G_GNUC_CONST;
GtkWidget* gwy_color_swatch_new          (void);
void       gwy_color_swatch_set_color    (GwyColorSwatch *swatch,
                                          const GwyRGBA *color);
void       gwy_color_swatch_get_color    (GwyColorSwatch *swatch,
                                          GwyRGBA *color);
void       gwy_color_swatch_set_use_alpha(GwyColorSwatch *swatch,
                                          gboolean use_alpha);
gboolean   gwy_color_swatch_get_use_alpha(GwyColorSwatch *swatch);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
