;;; Hoot implementation of Fibers
;;; Copyright (C) 2024 Igalia, S.L.
;;;
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;;
;;;    http://www.apache.org/licenses/LICENSE-2.0
;;;
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

(define-module (fibers scheduler)
  #:use-module (hoot ffi)
  #:export (schedule-task suspend-current-task))

(define-foreign %async-invoke
  "rt" "async_invoke" (ref extern) -> none)
(define-foreign %async-invoke-later
  "rt" "async_invoke_later" (ref extern) f64 -> none)

(define schedule-task
  (case-lambda
   ((thunk)
    (%async-invoke (procedure->external thunk)))
   ((thunk delay)
    (%async-invoke-later (procedure->external thunk) delay))))

(define (suspend-current-task handler)
  (abort-to-prompt (default-prompt-tag) handler))
