//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentGet.json
func ExampleDatabaseVulnerabilityAssessmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseVulnerabilityAssessmentsClient().Get(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessment = armsql.DatabaseVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentCreateMax.json
func ExampleDatabaseVulnerabilityAssessmentsClient_CreateOrUpdate_createADatabasesVulnerabilityAssessmentWithAllParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.DatabaseVulnerabilityAssessment{
		Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
			RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
				EmailSubscriptionAdmins: to.Ptr(true),
				Emails: []*string{
					to.Ptr("email1@mail.com"),
					to.Ptr("email2@mail.com")},
				IsEnabled: to.Ptr(true),
			},
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey:  to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessment = armsql.DatabaseVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentCreateStorageAccessKeyMin.json
func ExampleDatabaseVulnerabilityAssessmentsClient_CreateOrUpdate_createADatabasesVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.DatabaseVulnerabilityAssessment{
		Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessment = armsql.DatabaseVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentCreateContainerSasKeyMin.json
func ExampleDatabaseVulnerabilityAssessmentsClient_CreateOrUpdate_createADatabasesVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.DatabaseVulnerabilityAssessment{
		Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
			StorageContainerPath:   to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessment = armsql.DatabaseVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentDelete.json
func ExampleDatabaseVulnerabilityAssessmentsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDatabaseVulnerabilityAssessmentsClient().Delete(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentListByDatabase.json
func ExampleDatabaseVulnerabilityAssessmentsClient_NewListByDatabasePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseVulnerabilityAssessmentsClient().NewListByDatabasePager("vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatabaseVulnerabilityAssessmentListResult = armsql.DatabaseVulnerabilityAssessmentListResult{
		// 	Value: []*armsql.DatabaseVulnerabilityAssessment{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default"),
		// 			Properties: &armsql.DatabaseVulnerabilityAssessmentProperties{
		// 				RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
		// 					EmailSubscriptionAdmins: to.Ptr(true),
		// 					Emails: []*string{
		// 						to.Ptr("email1@mail.com"),
		// 						to.Ptr("email2@mail.com")},
		// 						IsEnabled: to.Ptr(true),
		// 					},
		// 				},
		// 		}},
		// 	}
	}
}
