/* { dg-do run { target bitint } } */
/* { dg-options "-std=c23 -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 255
struct S255 { unsigned _BitInt(255) a : 255, b : 255, c : 3, d : 235, e : 255; };
struct T255 { unsigned _BitInt(255) a : 255, b : 255, c : 4, d : 235, e : 255; };

__attribute__((noipa)) void
foo255 (struct S255 *p, unsigned _BitInt(129) x, unsigned _BitInt(129) y)
{
  p->d = x + y;
}

__attribute__((noipa)) void
bar255 (struct S255 *p, _BitInt(129) x, _BitInt(129) y)
{
  p->d = x + y;
}

__attribute__((noipa)) void
baz255 (struct T255 *p, unsigned _BitInt(129) x, unsigned _BitInt(129) y)
{
  p->d = x + y;
}

__attribute__((noipa)) void
qux255 (struct T255 *p, _BitInt(129) x, _BitInt(129) y)
{
  p->d = x + y;
}
#endif

#if __BITINT_MAXWIDTH__ >= 2047
struct S2047 { unsigned _BitInt(2047) a : 2047, b : 2047, c : 3, d : 2027, e : 2047; };
struct T2047 { unsigned _BitInt(2047) a : 2047, b : 2047, c : 4, d : 2027, e : 2047; };

__attribute__((noipa)) void
foo2047 (struct S2047 *p, unsigned _BitInt(1025) x, unsigned _BitInt(1025) y)
{
  p->d = x + y;
}

__attribute__((noipa)) void
bar2047 (struct S2047 *p, _BitInt(1025) x, _BitInt(1025) y)
{
  p->d = x + y;
}

__attribute__((noipa)) void
baz2047 (struct T2047 *p, unsigned _BitInt(1025) x, unsigned _BitInt(1025) y)
{
  p->d = x + y;
}

__attribute__((noipa)) void
qux2047 (struct T2047 *p, _BitInt(1025) x, _BitInt(1025) y)
{
  p->d = x + y;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 255
  static struct S255 a255 = {
    53186120754797186577260219566323862446223402596797491351049671033889795175625uwb,
    11016010833798237411188512410350787877773522870186169967060431559664794296995uwb,
    3uwb,
    34443349379822557022031657812343704881254613790161917350775948942333289uwb,
    46115238973717368082068120592131885017219615546561407012172308861631873123384uwb };
  foo255 (&a255, 173345522902299812179061392904021723586uwb,
	  594746496877065132561656166247698268802uwb);
  if (a255.a != 53186120754797186577260219566323862446223402596797491351049671033889795175625uwb
      || a255.b != 11016010833798237411188512410350787877773522870186169967060431559664794296995uwb
      || a255.c != 3uwb
      || a255.d != 87527285937488017813968344288183569476uwb
      || a255.e != 46115238973717368082068120592131885017219615546561407012172308861631873123384uwb)
    __builtin_abort ();
  bar255 (&a255, -295860968706196796751570199618630311203wb,
	  250268150248006479289572648514855658614wb);
  if (a255.a != 53186120754797186577260219566323862446223402596797491351049671033889795175625uwb
      || a255.b != 11016010833798237411188512410350787877773522870186169967060431559664794296995uwb
      || a255.c != 3uwb
      || a255.d != (unsigned _BitInt(235)) -45592818458190317461997551103774652589wb
      || a255.e != 46115238973717368082068120592131885017219615546561407012172308861631873123384uwb)
    __builtin_abort ();
  bar255 (&a255, 295860968706196796751570199618630311203wb,
	  -250268150248006479289572648514855658614wb);
  if (a255.a != 53186120754797186577260219566323862446223402596797491351049671033889795175625uwb
      || a255.b != 11016010833798237411188512410350787877773522870186169967060431559664794296995uwb
      || a255.c != 3uwb
      || a255.d != 45592818458190317461997551103774652589uwb
      || a255.e != 46115238973717368082068120592131885017219615546561407012172308861631873123384uwb)
    __builtin_abort ();
  static struct T255 b255 = {
    22432197631110620165030705848624667816774533044127974798775792394287682890132uwb,
    10434238915154367848470352793005517845706642883922785811579699218726683347492uwb,
    6uwb,
    43803954908428856867451333914918080831779977386765104822182973124878391uwb,
    54440198277989626545578993065515754280754976615499904095101607562511754302923uwb };
  baz255 (&b255, 173345522902299812179061392904021723586uwb,
	  594746496877065132561656166247698268802uwb);
  if (b255.a != 22432197631110620165030705848624667816774533044127974798775792394287682890132uwb
      || b255.b != 10434238915154367848470352793005517845706642883922785811579699218726683347492uwb
      || b255.c != 6uwb
      || b255.d != 87527285937488017813968344288183569476uwb
      || b255.e != 54440198277989626545578993065515754280754976615499904095101607562511754302923uwb)
    __builtin_abort ();
  qux255 (&b255, -295860968706196796751570199618630311203wb,
	  250268150248006479289572648514855658614wb);
  if (b255.a != 22432197631110620165030705848624667816774533044127974798775792394287682890132uwb
      || b255.b != 10434238915154367848470352793005517845706642883922785811579699218726683347492uwb
      || b255.c != 6uwb
      || b255.d != (unsigned _BitInt(235)) -45592818458190317461997551103774652589wb
      || b255.e != 54440198277989626545578993065515754280754976615499904095101607562511754302923uwb)
    __builtin_abort ();
  qux255 (&b255, 295860968706196796751570199618630311203wb,
	  -250268150248006479289572648514855658614wb);
  if (b255.a != 22432197631110620165030705848624667816774533044127974798775792394287682890132uwb
      || b255.b != 10434238915154367848470352793005517845706642883922785811579699218726683347492uwb
      || b255.c != 6uwb
      || b255.d != 45592818458190317461997551103774652589uwb
      || b255.e != 54440198277989626545578993065515754280754976615499904095101607562511754302923uwb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 2047
  static struct S2047 a2047 = {
    6604638284533196604244471973541013618281533226364189685792053875666894057803336566484436573497392167130748586543934163550741401484647771763676964459636106203955755250170376364799937601505200975989859891863753738684249106942944581800126298385951473900411874226237184667785129620838843419470788411304260887793015638605531226504875060604515688332205834200447655374389292019856450089734989539345196623908433705347894829346923489476140677375811732806834772686417478318575505181306534740760690417577911023605293314367340174835343740361087598377394743326663660990223372181490299731215729287633035024377246940630447830332400uwb,
    9137501476482024007629903428591441562584201678803339450640010852682968378249451929368153750949595739310161107210507212794786347440833584007494934546214718055568442143768955715008628409876512331822501562467361613930394370954908550544883438576618916222169914979225020080371038560790263823334259485417483979863747127011670904476684110186667537336894469993151951433629276229957132898606324321221679211292427020775709202822704838337025228478551871438202955358400266599772607383213562964473056897194903298404105599382719634865500654814014675018495924284439422068568299533611891298495087865671200109507464285856856659661117uwb,
    3uwb,
    12047384745489858064414933953772839663477391272220883177150545757891750042677302445853708145531378904722301054376282458120945425051863649661639155209306286061040930046981057924193785105670446755260062214289266936409272622894864999608677838455560347293246296031941665889508903566959506861861990700494312980351508620223759760110137977058814130413350438372974774697932180418893315998700082240773617767158952812989924561352269321428579880535410771704240937834451503845844374401535603729059202374734334220483209556455967311418585395828630127849722973959209786392861438763563084218683015947661969541113478500403696370uwb,
    8804033128404257319436391796247922558656097909723817946206424086107376571363985431643405988715302457119922790818911593984275867659318063980148880188381721682101222175837894550825446110314568257002910318459491664340963523476389547801300395551742633087402381375954250806472095890015415996293082500961651310239841690830469614433038572525199550599988220404857171911882800074918573055686438920724369407729906538787728042731530804134671860407095239208695638067647644314590947763517887856674430537735913123875082727985637440472517467667915231517115684103964725547766722895041192409825339825853271319679650626338206521967332uwb };
  foo2047 (&a2047, 96870374520559877232425023232449835594772020210727763784623672383466424139699010793947506821373137871851733734526750376478351875022731872925672817923968593208680325422683755493846732186980639465537989170494450817375451735480623479375546788222637312722297995519801563871171551494848869504437926131454949049313uwb,
	   204286879211705664548598471253516036336450894944461293280538653272096106720692442407887688865006198655779005102679360128685207761954177030702942577918382309453894659175068179209177965184955019555984495374852658981484737374893252503438668707548935382902024863626525041196947938897658146003104268181146061978016uwb);
  if (a2047.a != 6604638284533196604244471973541013618281533226364189685792053875666894057803336566484436573497392167130748586543934163550741401484647771763676964459636106203955755250170376364799937601505200975989859891863753738684249106942944581800126298385951473900411874226237184667785129620838843419470788411304260887793015638605531226504875060604515688332205834200447655374389292019856450089734989539345196623908433705347894829346923489476140677375811732806834772686417478318575505181306534740760690417577911023605293314367340174835343740361087598377394743326663660990223372181490299731215729287633035024377246940630447830332400uwb
      || a2047.b != 9137501476482024007629903428591441562584201678803339450640010852682968378249451929368153750949595739310161107210507212794786347440833584007494934546214718055568442143768955715008628409876512331822501562467361613930394370954908550544883438576618916222169914979225020080371038560790263823334259485417483979863747127011670904476684110186667537336894469993151951433629276229957132898606324321221679211292427020775709202822704838337025228478551871438202955358400266599772607383213562964473056897194903298404105599382719634865500654814014675018495924284439422068568299533611891298495087865671200109507464285856856659661117uwb
      || a2047.c != 3uwb
      || a2047.d != 301157253732265541781023494485965871931222915155189057065162325655562530860391453201835195686379336527630738837206110505163559636976908903628615395842350902662574984597751934703024697371935659021522484545347109798860189110373875982814215495771572695624322859146326605068119490392507015507542194312601011027329uwb
      || a2047.e != 8804033128404257319436391796247922558656097909723817946206424086107376571363985431643405988715302457119922790818911593984275867659318063980148880188381721682101222175837894550825446110314568257002910318459491664340963523476389547801300395551742633087402381375954250806472095890015415996293082500961651310239841690830469614433038572525199550599988220404857171911882800074918573055686438920724369407729906538787728042731530804134671860407095239208695638067647644314590947763517887856674430537735913123875082727985637440472517467667915231517115684103964725547766722895041192409825339825853271319679650626338206521967332uwb)
    __builtin_abort ();
  bar2047 (&a2047, -107041399279853750538644610804872546664073777262361485051257422505445403341239911024662125357507942225958473152601813095133468813115195351301813567477804225231126164403591882793618380878832817133932293901187006756344358795625819716260192657246036383263988109408466592090784140040462306716053681955947029302372wb,
	   96987190807622698460264889519367881890066987668370388919983053615401815945974432823964979317479611113155186555311657934933783458381323251774060867490977621487683905191843744141366245874982592954856173370276396645258076888821241836201856003528789429151224936212560775299953235914854472460555840121467482998173wb);
  if (a2047.a != 6604638284533196604244471973541013618281533226364189685792053875666894057803336566484436573497392167130748586543934163550741401484647771763676964459636106203955755250170376364799937601505200975989859891863753738684249106942944581800126298385951473900411874226237184667785129620838843419470788411304260887793015638605531226504875060604515688332205834200447655374389292019856450089734989539345196623908433705347894829346923489476140677375811732806834772686417478318575505181306534740760690417577911023605293314367340174835343740361087598377394743326663660990223372181490299731215729287633035024377246940630447830332400uwb
      || a2047.b != 9137501476482024007629903428591441562584201678803339450640010852682968378249451929368153750949595739310161107210507212794786347440833584007494934546214718055568442143768955715008628409876512331822501562467361613930394370954908550544883438576618916222169914979225020080371038560790263823334259485417483979863747127011670904476684110186667537336894469993151951433629276229957132898606324321221679211292427020775709202822704838337025228478551871438202955358400266599772607383213562964473056897194903298404105599382719634865500654814014675018495924284439422068568299533611891298495087865671200109507464285856856659661117uwb
      || a2047.c != 3uwb
      || a2047.d != (unsigned _BitInt(2027)) -10054208472231052078379721285504664774006789593991096131274368890043587395265478200697146040028331112803286597290155160199685354733872099527752699986826603743442259211748138652252135003850224179076120530910610111086281906804577880058336653717246954112763173195905816790830904125607834255497841834479546304199wb
      || a2047.e != 8804033128404257319436391796247922558656097909723817946206424086107376571363985431643405988715302457119922790818911593984275867659318063980148880188381721682101222175837894550825446110314568257002910318459491664340963523476389547801300395551742633087402381375954250806472095890015415996293082500961651310239841690830469614433038572525199550599988220404857171911882800074918573055686438920724369407729906538787728042731530804134671860407095239208695638067647644314590947763517887856674430537735913123875082727985637440472517467667915231517115684103964725547766722895041192409825339825853271319679650626338206521967332uwb)
    __builtin_abort ();
  bar2047 (&a2047, 107041399279853750538644610804872546664073777262361485051257422505445403341239911024662125357507942225958473152601813095133468813115195351301813567477804225231126164403591882793618380878832817133932293901187006756344358795625819716260192657246036383263988109408466592090784140040462306716053681955947029302372wb,
	   -96987190807622698460264889519367881890066987668370388919983053615401815945974432823964979317479611113155186555311657934933783458381323251774060867490977621487683905191843744141366245874982592954856173370276396645258076888821241836201856003528789429151224936212560775299953235914854472460555840121467482998173wb);
  if (a2047.a != 6604638284533196604244471973541013618281533226364189685792053875666894057803336566484436573497392167130748586543934163550741401484647771763676964459636106203955755250170376364799937601505200975989859891863753738684249106942944581800126298385951473900411874226237184667785129620838843419470788411304260887793015638605531226504875060604515688332205834200447655374389292019856450089734989539345196623908433705347894829346923489476140677375811732806834772686417478318575505181306534740760690417577911023605293314367340174835343740361087598377394743326663660990223372181490299731215729287633035024377246940630447830332400uwb
      || a2047.b != 9137501476482024007629903428591441562584201678803339450640010852682968378249451929368153750949595739310161107210507212794786347440833584007494934546214718055568442143768955715008628409876512331822501562467361613930394370954908550544883438576618916222169914979225020080371038560790263823334259485417483979863747127011670904476684110186667537336894469993151951433629276229957132898606324321221679211292427020775709202822704838337025228478551871438202955358400266599772607383213562964473056897194903298404105599382719634865500654814014675018495924284439422068568299533611891298495087865671200109507464285856856659661117uwb
      || a2047.c != 3uwb
      || a2047.d != 10054208472231052078379721285504664774006789593991096131274368890043587395265478200697146040028331112803286597290155160199685354733872099527752699986826603743442259211748138652252135003850224179076120530910610111086281906804577880058336653717246954112763173195905816790830904125607834255497841834479546304199uwb
      || a2047.e != 8804033128404257319436391796247922558656097909723817946206424086107376571363985431643405988715302457119922790818911593984275867659318063980148880188381721682101222175837894550825446110314568257002910318459491664340963523476389547801300395551742633087402381375954250806472095890015415996293082500961651310239841690830469614433038572525199550599988220404857171911882800074918573055686438920724369407729906538787728042731530804134671860407095239208695638067647644314590947763517887856674430537735913123875082727985637440472517467667915231517115684103964725547766722895041192409825339825853271319679650626338206521967332uwb)
    __builtin_abort ();
  static struct T2047 b2047 = {
    8996238020280292957328835089241644192878840856627816196416318709508683098169814577226365258620493076815319486990268281142171221215928011006756119353814278158963533314155524133150379539663994828642659406032292079638106530616220996959709130065598293192861447528701351308436811527532025724876557041408124206634994855959829536357239366288943458437338903780905785942866502425145885283981390432237293769793723111403979497735186231144097215953553454988205125026498825957157417441121856068152040712774023846606695947287461796712589836037950807125680967643300197810011211640702778647554744354944603685620923084456614104269511uwb,
    10984318785160035171394274834520714981439611497142275792263219471171187866412794220589679181825290825434476603425001179842844662351028314167468349845879235198018132318905212119916242949709604719322253068999148260324480265586748667860001776565543787645340459243545680867668449541033392329858909661211654102449948990901244396803735089889644860800279108718607804327932252678544915255476214419499336896882183024344391755469834019036074623457176720435331996267496468629393048786381035430672504168120874305682383085268282415424323567923620247616970537420522283962923432940154412293415792945236923677598283314889480184388928uwb,
    6uwb,
    4790880321170629055903750609772895026632672846986739280016249738812459613115379765419988023638270768078558232945132784525166570715169427772424711358221632774714634926039540434297354515015370752168718157581893336796591613729772599089792047050683360727021739900497232167845699737421642365115219385074831571286354899965772412143441270198896667545966629183706673530731718536536465082401940906390967469028437946614351467520839911469740329315914999526738976943417735745760153747243156855057165807147066483580752278526914784843144575299178410593465362653960651398775135718996282702371931556709069927057814215337263088uwb,
    15898795864009764874305090919753114555137700112966361953790245810709040722233816733280023885873997896242958848192251646902459137691931517631544750216012143606605819071183153530372060489236262856491973841038138316548406269164589694469032205076355057742341341656583075897561909452907012289408703280249378682882696627977625379823499910638320190471165330121795134411615134572598658797215197404325870770080826927165671269527854053737471231889250113654062195345706056764060545970124448748001325886598996898661788527149728584429285239380904550684885882592015572632423663763016881296460620776131666328013362700459054902525252uwb };
  baz2047 (&b2047, 96870374520559877232425023232449835594772020210727763784623672383466424139699010793947506821373137871851733734526750376478351875022731872925672817923968593208680325422683755493846732186980639465537989170494450817375451735480623479375546788222637312722297995519801563871171551494848869504437926131454949049313uwb,
	   204286879211705664548598471253516036336450894944461293280538653272096106720692442407887688865006198655779005102679360128685207761954177030702942577918382309453894659175068179209177965184955019555984495374852658981484737374893252503438668707548935382902024863626525041196947938897658146003104268181146061978016uwb);
  if (b2047.a != 8996238020280292957328835089241644192878840856627816196416318709508683098169814577226365258620493076815319486990268281142171221215928011006756119353814278158963533314155524133150379539663994828642659406032292079638106530616220996959709130065598293192861447528701351308436811527532025724876557041408124206634994855959829536357239366288943458437338903780905785942866502425145885283981390432237293769793723111403979497735186231144097215953553454988205125026498825957157417441121856068152040712774023846606695947287461796712589836037950807125680967643300197810011211640702778647554744354944603685620923084456614104269511uwb
      || b2047.b != 10984318785160035171394274834520714981439611497142275792263219471171187866412794220589679181825290825434476603425001179842844662351028314167468349845879235198018132318905212119916242949709604719322253068999148260324480265586748667860001776565543787645340459243545680867668449541033392329858909661211654102449948990901244396803735089889644860800279108718607804327932252678544915255476214419499336896882183024344391755469834019036074623457176720435331996267496468629393048786381035430672504168120874305682383085268282415424323567923620247616970537420522283962923432940154412293415792945236923677598283314889480184388928uwb
      || b2047.c != 6uwb
      || b2047.d != 301157253732265541781023494485965871931222915155189057065162325655562530860391453201835195686379336527630738837206110505163559636976908903628615395842350902662574984597751934703024697371935659021522484545347109798860189110373875982814215495771572695624322859146326605068119490392507015507542194312601011027329uwb
      || b2047.e != 15898795864009764874305090919753114555137700112966361953790245810709040722233816733280023885873997896242958848192251646902459137691931517631544750216012143606605819071183153530372060489236262856491973841038138316548406269164589694469032205076355057742341341656583075897561909452907012289408703280249378682882696627977625379823499910638320190471165330121795134411615134572598658797215197404325870770080826927165671269527854053737471231889250113654062195345706056764060545970124448748001325886598996898661788527149728584429285239380904550684885882592015572632423663763016881296460620776131666328013362700459054902525252uwb)
    __builtin_abort ();
  qux2047 (&b2047, -107041399279853750538644610804872546664073777262361485051257422505445403341239911024662125357507942225958473152601813095133468813115195351301813567477804225231126164403591882793618380878832817133932293901187006756344358795625819716260192657246036383263988109408466592090784140040462306716053681955947029302372wb,
	   96987190807622698460264889519367881890066987668370388919983053615401815945974432823964979317479611113155186555311657934933783458381323251774060867490977621487683905191843744141366245874982592954856173370276396645258076888821241836201856003528789429151224936212560775299953235914854472460555840121467482998173wb);
  if (b2047.a != 8996238020280292957328835089241644192878840856627816196416318709508683098169814577226365258620493076815319486990268281142171221215928011006756119353814278158963533314155524133150379539663994828642659406032292079638106530616220996959709130065598293192861447528701351308436811527532025724876557041408124206634994855959829536357239366288943458437338903780905785942866502425145885283981390432237293769793723111403979497735186231144097215953553454988205125026498825957157417441121856068152040712774023846606695947287461796712589836037950807125680967643300197810011211640702778647554744354944603685620923084456614104269511uwb
      || b2047.b != 10984318785160035171394274834520714981439611497142275792263219471171187866412794220589679181825290825434476603425001179842844662351028314167468349845879235198018132318905212119916242949709604719322253068999148260324480265586748667860001776565543787645340459243545680867668449541033392329858909661211654102449948990901244396803735089889644860800279108718607804327932252678544915255476214419499336896882183024344391755469834019036074623457176720435331996267496468629393048786381035430672504168120874305682383085268282415424323567923620247616970537420522283962923432940154412293415792945236923677598283314889480184388928uwb
      || b2047.c != 6uwb
      || b2047.d != (unsigned _BitInt(2027)) -10054208472231052078379721285504664774006789593991096131274368890043587395265478200697146040028331112803286597290155160199685354733872099527752699986826603743442259211748138652252135003850224179076120530910610111086281906804577880058336653717246954112763173195905816790830904125607834255497841834479546304199wb
      || b2047.e != 15898795864009764874305090919753114555137700112966361953790245810709040722233816733280023885873997896242958848192251646902459137691931517631544750216012143606605819071183153530372060489236262856491973841038138316548406269164589694469032205076355057742341341656583075897561909452907012289408703280249378682882696627977625379823499910638320190471165330121795134411615134572598658797215197404325870770080826927165671269527854053737471231889250113654062195345706056764060545970124448748001325886598996898661788527149728584429285239380904550684885882592015572632423663763016881296460620776131666328013362700459054902525252uwb)
    __builtin_abort ();
  qux2047 (&b2047, 107041399279853750538644610804872546664073777262361485051257422505445403341239911024662125357507942225958473152601813095133468813115195351301813567477804225231126164403591882793618380878832817133932293901187006756344358795625819716260192657246036383263988109408466592090784140040462306716053681955947029302372wb,
	   -96987190807622698460264889519367881890066987668370388919983053615401815945974432823964979317479611113155186555311657934933783458381323251774060867490977621487683905191843744141366245874982592954856173370276396645258076888821241836201856003528789429151224936212560775299953235914854472460555840121467482998173wb);
  if (b2047.a != 8996238020280292957328835089241644192878840856627816196416318709508683098169814577226365258620493076815319486990268281142171221215928011006756119353814278158963533314155524133150379539663994828642659406032292079638106530616220996959709130065598293192861447528701351308436811527532025724876557041408124206634994855959829536357239366288943458437338903780905785942866502425145885283981390432237293769793723111403979497735186231144097215953553454988205125026498825957157417441121856068152040712774023846606695947287461796712589836037950807125680967643300197810011211640702778647554744354944603685620923084456614104269511uwb
      || b2047.b != 10984318785160035171394274834520714981439611497142275792263219471171187866412794220589679181825290825434476603425001179842844662351028314167468349845879235198018132318905212119916242949709604719322253068999148260324480265586748667860001776565543787645340459243545680867668449541033392329858909661211654102449948990901244396803735089889644860800279108718607804327932252678544915255476214419499336896882183024344391755469834019036074623457176720435331996267496468629393048786381035430672504168120874305682383085268282415424323567923620247616970537420522283962923432940154412293415792945236923677598283314889480184388928uwb
      || b2047.c != 6uwb
      || b2047.d != 10054208472231052078379721285504664774006789593991096131274368890043587395265478200697146040028331112803286597290155160199685354733872099527752699986826603743442259211748138652252135003850224179076120530910610111086281906804577880058336653717246954112763173195905816790830904125607834255497841834479546304199uwb
      || b2047.e != 15898795864009764874305090919753114555137700112966361953790245810709040722233816733280023885873997896242958848192251646902459137691931517631544750216012143606605819071183153530372060489236262856491973841038138316548406269164589694469032205076355057742341341656583075897561909452907012289408703280249378682882696627977625379823499910638320190471165330121795134411615134572598658797215197404325870770080826927165671269527854053737471231889250113654062195345706056764060545970124448748001325886598996898661788527149728584429285239380904550684885882592015572632423663763016881296460620776131666328013362700459054902525252uwb)
    __builtin_abort ();
#endif
}
