import { VerdaConfig } from "../config";
import Director from "../core/director";
import { ExportBuildRecipe, Goal, GoalMatcher, Rule } from "../core/interface";
import { FileExecArgs } from "./matchers";
import { RuleBase } from "./rule-base";
export declare function GoalBuilder<T, A extends any[], F>(matcher: GoalMatcher<A>, rule: Rule<T, A>): (literals: string | TemplateStringsArray, ...placeholders: F[]) => Goal<T, A>;
export declare function MakeGoalBuilder<T, A extends any[], K extends string[]>(matcher: GoalMatcher<A>, rule: Rule<T, A>): (...args: K) => Goal<T, A>;
export declare function SinglePlural_F<R, T>(rulePrefix: string, dir: Director, cfg: VerdaConfig, RuleBuilder: (matcher: GoalMatcher<FileExecArgs>, FRecipe: ExportBuildRecipe<R, FileExecArgs>) => RuleBase<FileExecArgs> & Rule<T, FileExecArgs>): {
    glob: (pattern: string, FRecipe: ExportBuildRecipe<R, FileExecArgs>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => Goal<T, [import("..").ParsedPath, ...string[]]>;
    exact: (pattern: string, FRecipe: ExportBuildRecipe<R, FileExecArgs>) => Goal<T, [import("..").ParsedPath, ...string[]]>;
    make: <K extends string[]>(mk: (...args: K) => string, FRecipe: ExportBuildRecipe<R, FileExecArgs>) => (...args: K) => Goal<T, FileExecArgs>;
};
export declare function SinglePlural_T(rulePrefix: string, dir: Director, RuleBuilder: <T>(pattern: GoalMatcher<string[]>, FRecipe: ExportBuildRecipe<T, string[]>) => RuleBase<string[]> & Rule<T, string[]>): {
    glob: <T>(pattern: string, FRecipe: ExportBuildRecipe<T, string[]>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => Goal<T, string[]>;
    exact: <T>(pattern: string, FRecipe: ExportBuildRecipe<T, string[]>) => Goal<T, string[]>;
    subPrefix: <T>(_subPrefix: string, FRecipe: ExportBuildRecipe<T, string[]>) => (literals: string | TemplateStringsArray, ...placeholders: unknown[]) => Goal<T, string[]>;
    make: <T, K extends string[]>(mk: (...args: K) => string, FRecipe: ExportBuildRecipe<T, string[]>) => (...args: K) => Goal<T, string[]>;
};
