"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuppressedReporter = void 0;
class SuppressedReporter {
    constructor(m_reporter) {
        this.m_reporter = m_reporter;
    }
    start() { }
    end(wrong) {
        return this.m_reporter.end(wrong);
    }
    get verbosity() {
        return this.m_reporter.verbosity;
    }
    targetStart(name) { }
    targetSkip(name) { }
    targetEnd(name) { }
    targetHalt(name) { }
    targetUnHalt(name) { }
    systemError(e) {
        return this.m_reporter.systemError(e);
    }
    targetError(name, e) {
        return this.m_reporter.targetError(name, e);
    }
    redirectStdout(line) {
        return this.m_reporter.redirectStdout(line);
    }
    redirectStderr(line) {
        return this.m_reporter.redirectStderr(line);
    }
    actions(lines, style) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.actions(lines, style);
    }
    debug(...line) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.debug(...line);
    }
    info(...line) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.info(...line);
    }
    echo(...line) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.echo(...line);
    }
    warn(...line) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.warn(...line);
    }
    note(...line) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.note(...line);
    }
    success(...line) {
        if (this.verbosity < 7)
            return;
        return this.m_reporter.success(...line);
    }
    fail(...line) {
        return this.m_reporter.fail(...line);
    }
    error(...line) {
        return this.m_reporter.error(...line);
    }
    fatal(...line) {
        return this.m_reporter.fatal(...line);
    }
}
exports.SuppressedReporter = SuppressedReporter;
