"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const posixify_path_1 = tslib_1.__importDefault(require("./posixify-path"));
const splitPathRe = /^([a-zA-Z\-:]+:|)(\/|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
class ParsedPathImpl {
    constructor(_s, $ = []) {
        this.$ = $;
        const s = (0, posixify_path_1.default)(_s);
        const allParts = splitPathRe.exec(s);
        if (!allParts || allParts.length !== 6) {
            throw new TypeError("Invalid path '" + s + "'");
        }
        allParts[1] = allParts[1] || "";
        allParts[2] = allParts[2] || "";
        allParts[3] = allParts[3] || "";
        allParts[4] = allParts[4] || "";
        allParts[5] = allParts[5] || "";
        this.full = s;
        this.prefix = allParts[1];
        this.root = allParts[2];
        this.dir = allParts[3].slice(0, -1);
        this.base = allParts[4];
        this.ext = allParts[5];
        this.name = this.base.slice(0, this.base.length - this.ext.length);
    }
}
exports.default = ParsedPathImpl;
