"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createKit_File = createKit_File;
const tslib_1 = require("tslib");
const fs = tslib_1.__importStar(require("fs-extra"));
const path = tslib_1.__importStar(require("path"));
function createKit_File(ce) {
    return {
        cp: (from, to) => fs.copy(path.resolve(ce.cd, from + ""), path.resolve(ce.cd, to + ""), {
            overwrite: true,
        }),
        mv: (from, to) => fs.move(path.resolve(ce.cd, from + ""), path.resolve(ce.cd, to + ""), {
            overwrite: true,
        }),
        rm: (file) => fs.remove(path.resolve(ce.cd, file + "")),
        exists: (file) => fs.pathExists(path.resolve(ce.cd, file + "")),
        touch: (file) => fs.ensureFile(path.resolve(ce.cd, file + "")),
        mkdir: (d) => fs.ensureDir(path.resolve(ce.cd, d + "")),
        chmod: (file, mode) => fs.chmod(path.resolve(ce.cd, file + ""), mode),
    };
}
