import { Arc, Arcs } from "../derivable";
export interface IBezierGeometrySink {
    beginShape(): void;
    moveTo(x: number, y: number): void;
    lineTo(x: number, y: number): void;
    curveTo(x1: number, y1: number, x2: number, y2: number): void;
    cubicTo(x1: number, y1: number, x2: number, y2: number, x: number, y: number): void;
    endShape(): void;
}
export interface IArcGeometrySink {
    beginShape(): void;
    moveTo(x: number, y: number): void;
    lineTo(x: number, y: number): void;
    arcTo(arc: Arc, x: number, y: number): void;
    endShape(): void;
}
export declare function transferBezArcShape(shape: Arcs.Bez3[][], sink: IBezierGeometrySink, tolerance?: number): void;
export declare function transferGenericShape(shape: Arc[][], sink: IArcGeometrySink, tolerance?: number): void;
export { convertShapeToBez3 } from "../bez-tool/shape-to-bez3";
export declare function transferGenericShapeAsBezier(shape: Arc[][], sink: IBezierGeometrySink, tolerance?: number): void;
