"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jacobian2 = void 0;
class Jacobian2 {
    constructor(dxx, dxy, dyx, dyy) {
        this.dxx = dxx;
        this.dxy = dxy;
        this.dyx = dyx;
        this.dyy = dyy;
    }
    static from(j) {
        return new Jacobian2(j.dxx, j.dxy, j.dyx, j.dyy);
    }
    static multiply(l, r) {
        return new Jacobian2(l.dxx * r.dxx + l.dxy * r.dyx, l.dxx * r.dxy + l.dxy * r.dyy, l.dyx * r.dxx + l.dyy * r.dyx, l.dyx * r.dxy + l.dyy * r.dyy);
    }
}
exports.Jacobian2 = Jacobian2;
Jacobian2.identity = new Jacobian2(1, 0, 0, 1);
