"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FairizeCombinedArc = void 0;
const derivable_1 = require("../../derivable");
const arcs_1 = require("../../derivable/arcs");
const fn_1 = require("../../fn");
const point_1 = require("../../point/point");
const Bez3Measurer = {
    measureLength(a) {
        return a.getLength();
    }
};
class FairizeCombinedArc extends arcs_1.CombinedArc {
    constructor(arcs) {
        super(Bez3Measurer, arcs);
    }
    reduceIfStraight() {
        if (!this.segments.length)
            return this;
        const z0 = this.segments[0].a, z1 = this.segments[this.segments.length - 1].d;
        for (const seg of this.segments) {
            if (!(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.a)) ||
                !(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.b)) ||
                !(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.c)) ||
                !(0, fn_1.numberClose)(0, point_1.Point2.pointLineDist(z0, z1, seg.d))) {
                return this;
            }
        }
        return new derivable_1.Arcs.StraightSegment(z0, z1);
    }
}
exports.FairizeCombinedArc = FairizeCombinedArc;
