/// <reference path="../../../src/bez-tool/boolean/clipper-lib.d.ts" />
import { IIntPoint, IntPoint } from "clipper-lib";
import { Bez3Slice } from "../shared/slice-arc";
import { FIntersection } from "./intersections";
export type IntKnot = IIntPoint & {
    t: number;
};
export declare class SegHashStore {
    private terms;
    addStart(z: IIntPoint): SegStart;
    getStart(z: IIntPoint): undefined | SegStart;
    getSegment(start: IIntPoint, end: IIntPoint): SegEntry | undefined;
}
export declare class SegStart {
    private segments;
    addEnd(dest: IIntPoint, entry: SegEntry): void;
    getEnd(dest: IIntPoint): undefined | SegEntry;
}
export declare class SegEntry {
    readonly arc: Bez3Slice;
    start: number;
    end: number;
    readonly sid: number;
    readonly jid: number;
    readonly kid: number;
    constructor(arc: Bez3Slice, start: number, end: number, sid?: number, jid?: number, kid?: number);
    compare(b: SegEntry): number;
    tryAnnex(b: SegEntry): boolean;
    toArc(): Bez3Slice;
}
export declare function toPoly(shape: Bez3Slice[][], sid: number, splats: FIntersection[][], segHash: SegHashStore, resolution: number): IntPoint[][];
