"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Os2Stat = void 0;
const variance_1 = require("@ot-builder/variance");
class Os2Stat {
    constructor(os2, outer) {
        this.os2 = os2;
        this.outer = outer;
        this.metricsCount = 0;
        this.metricsSum = 0;
    }
    setNumGlyphs(count) {
        if (this.outer)
            this.outer.setNumGlyphs(count);
    }
    setMetric(gid, horizontal, vertical, extent) {
        if (this.outer)
            this.outer.setMetric(gid, horizontal, vertical, extent);
        const adv = variance_1.OtVar.Ops.originOf(horizontal.end) - variance_1.OtVar.Ops.originOf(horizontal.start);
        if (adv > 0) {
            this.metricsCount += 1;
            this.metricsSum += adv;
        }
    }
    simpleGlyphStat(st) {
        if (this.outer)
            this.outer.simpleGlyphStat(st);
    }
    complexGlyphStat(st) {
        if (this.outer)
            this.outer.complexGlyphStat(st);
    }
    instructionsStat(size) {
        if (this.outer)
            this.outer.instructionsStat(size);
    }
    settle() {
        if (this.outer)
            this.outer.settle();
        if (this.metricsCount > 0) {
            this.os2.xAvgCharWidth = Math.round(this.metricsSum / this.metricsCount);
        }
        else {
            this.os2.xAvgCharWidth = 0;
        }
    }
}
exports.Os2Stat = Os2Stat;
//# sourceMappingURL=os2.js.map