"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsEncodingMapT = void 0;
class VsEncodingMapT {
    constructor(init) {
        this.sizeCache = undefined;
        this.mapping = new Map();
        if (init) {
            for (const [code, vs, glyph] of init) {
                this.set(code, vs, glyph);
            }
        }
    }
    get size() {
        if (this.sizeCache != null)
            return this.sizeCache;
        this.sizeCache = 0;
        for (const selector of this.mapping.values())
            this.sizeCache += selector.size;
        return this.sizeCache;
    }
    get(code, vs) {
        const blossom = this.mapping.get(vs);
        if (!blossom)
            return undefined;
        else
            return blossom.get(code);
    }
    set(code, vs, glyph) {
        this.sizeCache = undefined;
        let blossom = this.mapping.get(vs);
        if (!blossom) {
            blossom = new Map();
            this.mapping.set(vs, blossom);
        }
        blossom.set(code, glyph);
    }
    delete(code, vs) {
        this.sizeCache = undefined;
        const blossom = this.mapping.get(vs);
        if (blossom) {
            blossom.delete(code);
            if (!blossom.size)
                this.mapping.delete(vs);
        }
    }
    clear() {
        this.mapping = new Map();
    }
    *entries() {
        for (const [vs, blossom] of this.mapping) {
            for (const [code, glyph] of blossom) {
                yield [code, vs, glyph];
            }
        }
    }
}
exports.VsEncodingMapT = VsEncodingMapT;
//# sourceMappingURL=vs-encoding-map-impl.js.map