import { Frag } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Gpos } from "@ot-builder/ot-layout";
import { Data } from "@ot-builder/prelude";
import { WriteTimeIVS } from "@ot-builder/var-store";
import { LookupWriter, SubtableWriteContext } from "../gsub-gpos-shared/general";
import { CovAuxMappingT } from "../shared/coverage";
type SingleMarkRecord<G> = {
    glyph: G;
    class: number;
    anchor: Gpos.Anchor;
};
type MarkClassRelocation = {
    forward: number[];
    reward: number[];
};
interface MarkPlanClass<G, B> {
    new (marks: SingleMarkRecord<G>[], bases: Map<G, B>): MarkWritePlan<G, B>;
    baseCoversMarkClass(mc: number, base: B): boolean;
}
declare abstract class MarkWritePlan<G, B> {
    readonly marks: SingleMarkRecord<G>[];
    protected readonly relocation: MarkClassRelocation;
    readonly bases: Map<G, B>;
    constructor(marks: SingleMarkRecord<G>[], rawBases: Map<G, B>);
    abstract measure(ivs: Data.Maybe<WriteTimeIVS>): number;
    protected abstract baseIsSubstantial(base: B): boolean;
    protected abstract sub(marks: SingleMarkRecord<G>[], bases: Map<G, B>): MarkWritePlan<G, B>;
    abstract write(frag: Frag, ctx: SubtableWriteContext<Gpos.Lookup>): void;
    isEmpty(): boolean;
    private getMarkPlanRelocation;
    autoBisect(ivs: Data.Maybe<WriteTimeIVS>, limit: number, d?: number): MarkWritePlan<G, B>[];
    protected bisect(ivs: Data.Maybe<WriteTimeIVS>): [MarkWritePlan<G, B>, MarkWritePlan<G, B>] | null;
    protected bisectImplByMarks(): [MarkWritePlan<G, B>, MarkWritePlan<G, B>];
    protected bisectImplByBases(): [MarkWritePlan<G, B>, MarkWritePlan<G, B>];
    protected getMarkAxm(gOrd: Data.Order<G>): CovAuxMappingT<SingleMarkRecord<G>>;
}
declare abstract class GposMarkWriterBase<G, B> {
    protected createSubtableFragmentsImpl(cls: MarkPlanClass<G, B>, marks: Map<G, Gpos.MarkRecord>, bases: Map<G, B>, ctx: SubtableWriteContext<Gpos.Lookup>): Frag[];
    private getInitialPlans;
    private getMaxAnchorClass;
    private fetchValidPlan;
    private basesHasAtLeastOneBaseInThisClass;
}
export declare class GposMarkToBaseWriter extends GposMarkWriterBase<OtGlyph, Gpos.BaseRecord> implements LookupWriter<Gpos.Lookup, Gpos.MarkToBase> {
    canBeUsed(l: Gpos.Lookup): l is Gpos.MarkToBase;
    getLookupType(): number;
    getLookupTypeSymbol(): symbol;
    createSubtableFragments(lookup: Gpos.MarkToBase, ctx: SubtableWriteContext<Gpos.Lookup>): Frag[];
}
export declare class GposMarkToLigatureWriter extends GposMarkWriterBase<OtGlyph, Gpos.LigatureBaseRecord> implements LookupWriter<Gpos.Lookup, Gpos.MarkToLigature> {
    canBeUsed(l: Gpos.Lookup): l is Gpos.MarkToLigature;
    getLookupType(): number;
    getLookupTypeSymbol(): symbol;
    createSubtableFragments(lookup: Gpos.MarkToLigature, ctx: SubtableWriteContext<Gpos.Lookup>): Frag[];
}
export declare class GposMarkToMarkWriter extends GposMarkWriterBase<OtGlyph, Gpos.BaseRecord> implements LookupWriter<Gpos.Lookup, Gpos.MarkToMark> {
    protected baseCoversMarkClass(mc: number, br: Gpos.BaseRecord): boolean;
    canBeUsed(l: Gpos.Lookup): l is Gpos.MarkToMark;
    getLookupType(): number;
    getLookupTypeSymbol(): symbol;
    createSubtableFragments(lookup: Gpos.MarkToMark, ctx: SubtableWriteContext<Gpos.Lookup>): Frag[];
}
export {};
//# sourceMappingURL=gpos-mark-write.d.ts.map