"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CFeatureVariations = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const errors_1 = require("@ot-builder/errors");
const primitive_1 = require("@ot-builder/primitive");
const feature_list_1 = require("./feature-list");
class CFeatureTableSubstitution {
    read(view, fOrd, lOrd) {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        errors_1.Assert.SubVersionSupported("FeatureTableSubstitution", majorVersion, minorVersion, [1, 0]);
        const subst = new Map();
        const count = view.uint16();
        for (let iFs = 0; iFs < count; iFs++) {
            const feature = fOrd.at(view.uint16());
            const altFeature = view.ptr32().next(new feature_list_1.CFeatureTable(), lOrd, feature.tag);
            subst.set(feature, altFeature);
        }
        return subst;
    }
    write(frag, subst, fOrd, lOrd) {
        frag.uint16(1).uint16(0).uint16(subst.size);
        for (const [from, to] of subst) {
            frag.uint16(fOrd.reverse(from));
            frag.ptr32New().push(new feature_list_1.CFeatureTable(), to, lOrd);
        }
    }
}
const ConditionTable = {
    read(view, designSpace) {
        const format = view.uint16();
        errors_1.Assert.FormatSupported(`ConditionTable`, format, 1);
        const dim = designSpace.at(view.uint16());
        const min = view.next(primitive_1.F2D14);
        const max = view.next(primitive_1.F2D14);
        return { dim, min, max };
    },
    write(frag, condition, designSpace) {
        frag.uint16(1)
            .uint16(designSpace.reverse(condition.dim))
            .push(primitive_1.F2D14, condition.min)
            .push(primitive_1.F2D14, condition.max);
    }
};
const Ptr32Condition = (0, bin_composite_types_1.NonNullablePtr32)(ConditionTable);
const ConditionSet = (0, bin_composite_types_1.SimpleArray)(primitive_1.UInt16, Ptr32Condition);
class CFeatureVariationRecord {
    read(view, designSpace, fOrd, lOrd) {
        const conditions = view.ptr32().next(ConditionSet, designSpace);
        const substitutions = view.ptr32().next(new CFeatureTableSubstitution(), fOrd, lOrd);
        return { conditions, substitutions };
    }
    write(frag, fv, designSpace, fOrd, lOrd) {
        frag.ptr32New().push(ConditionSet, fv.conditions, designSpace);
        frag.ptr32New().push(new CFeatureTableSubstitution(), fv.substitutions, fOrd, lOrd);
    }
}
function CFeatureVariationRecordList() {
    return (0, bin_composite_types_1.SimpleArray)(primitive_1.UInt32, new CFeatureVariationRecord());
}
class CFeatureVariations {
    read(view, designSpace, fOrd, lOrd) {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        errors_1.Assert.SubVersionSupported("FeatureTableSubstitution", majorVersion, minorVersion, [1, 0]);
        return view.next(CFeatureVariationRecordList(), designSpace, fOrd, lOrd);
    }
    write(frag, fv, designSpace, fOrd, lOrd) {
        frag.uint16(1).uint16(0);
        frag.push(CFeatureVariationRecordList(), fv, designSpace, fOrd, lOrd);
    }
}
exports.CFeatureVariations = CFeatureVariations;
//# sourceMappingURL=feature-variation.js.map