"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeGlyphStore = writeGlyphStore;
const stat_glyphs_1 = require("@ot-builder/stat-glyphs");
const write_1 = require("../shared-metrics/write");
function writeGlyphStore(
// out
sink, 
// in
cfg, 
// inOut
md, 
// in
coGlyphs, gOrd, extraInfoSink, cb) {
    const { head, maxp, fvar, os2, hhea, vhea } = md;
    const designSpace = fvar ? fvar.getDesignSpace() : null;
    // stat stages
    const statHead = new stat_glyphs_1.HeadExtendStat(head);
    const statMaxp = new stat_glyphs_1.MaxpStat(maxp, statHead);
    let stat = statMaxp;
    const statOs2 = os2 && cfg.glyphStore.statOs2XAvgCharWidth ? new stat_glyphs_1.Os2Stat(os2, stat) : null;
    if (statOs2)
        stat = statOs2;
    const statHmtx = hhea ? new stat_glyphs_1.HmtxStat(hhea, md.head, fvar, stat) : null;
    if (statHmtx)
        stat = statHmtx;
    const statVmtx = vhea ? new stat_glyphs_1.VmtxStat(vhea, fvar, stat) : null;
    if (statVmtx)
        stat = statVmtx;
    // Build glyphs and co-glyphs
    stat.setNumGlyphs(gOrd.length);
    cb.writeGlyphs(sink, cfg, coGlyphs, gOrd, {
        head,
        maxp,
        designSpace: designSpace,
        stat,
        extraInfoSink
    });
    stat.settle();
    // Write metrics
    (0, write_1.writeHMetrics)(sink, cb.writeMetricVariance, hhea, statHmtx, gOrd, designSpace);
    (0, write_1.writeVMetrics)(sink, cb.writeMetricVariance, vhea, statVmtx, gOrd, designSpace);
}
//# sourceMappingURL=write.js.map