import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Head, Maxp, OtFontIoMetadata } from "@ot-builder/ot-metadata";
import { Sfnt } from "@ot-builder/ot-sfnt";
import { Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
import { GlyphStoreCfg } from "../cfg/glyph-store-cfg";
export type GlyphStoreReadImplCtx = {
    head: Head.Table;
    maxp: Maxp.Table;
    designSpace?: Data.Maybe<OtVar.DesignSpace>;
    coStat: OtGlyph.CoStat.Source;
    hMetricVariable?: boolean;
    vMetricVariable?: boolean;
};
export interface ReadGlyphStoreImpl<C, T> {
    readGlyphs(sfnt: Sfnt, cfg: C, gOrd: Data.Order<OtGlyph>, ctx: GlyphStoreReadImplCtx): T;
}
export declare function readGlyphStore<C, T, S extends Data.OrderStore<OtGlyph>>(sfnt: Sfnt, cfg: C & GlyphStoreCfg, md: OtFontIoMetadata, gsf: Data.OrderStoreFactoryWithDefault<OtGlyph, S>, cb: ReadGlyphStoreImpl<C, T>): {
    glyphs: S;
    gOrd: Data.Order<OtGlyph>;
    coGlyphs: T;
};
//# sourceMappingURL=read.d.ts.map