"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffOffset = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const primitive_1 = require("@ot-builder/primitive");
exports.CffOffset = {
    ...(0, bin_util_1.Read)((view, size) => {
        switch (size) {
            case 1:
                return view.uint8() - 1;
            case 2:
                return view.uint16() - 1;
            case 3:
                return view.next(primitive_1.UInt24) - 1;
            default:
                return view.uint32() - 1;
        }
    }),
    ...(0, bin_util_1.Write)((frag, offset, size) => {
        switch (size) {
            case 1:
                return frag.uint8(offset + 1);
            case 2:
                return frag.uint16(offset + 1);
            case 3:
                return frag.push(primitive_1.UInt24, offset + 1);
            default:
                return frag.uint32(offset + 1);
        }
    })
};
//# sourceMappingURL=offset.js.map