"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cff2Header = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
exports.Cff2Header = {
    ...(0, bin_util_1.Read)(view => {
        return {
            majorVersion: view.uint8(),
            minorVersion: view.uint8(),
            headerSize: view.uint8(),
            topDictLength: view.uint16()
        };
    }),
    ...(0, bin_util_1.Write)((frag, header) => {
        frag.uint8(header.majorVersion);
        frag.uint8(header.minorVersion);
        frag.uint8(header.headerSize);
        frag.uint16(header.topDictLength);
    })
};
//# sourceMappingURL=cff2-header.js.map