"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cff1Header = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
exports.Cff1Header = {
    ...(0, bin_util_1.Read)(view => {
        return {
            majorVersion: view.uint8(),
            minorVersion: view.uint8(),
            headerSize: view.uint8(),
            offSize: view.uint8()
        };
    }),
    ...(0, bin_util_1.Write)((frag, header) => {
        frag.uint8(header.majorVersion);
        frag.uint8(header.minorVersion);
        frag.uint8(header.headerSize);
        frag.uint8(header.offSize);
    })
};
//# sourceMappingURL=cff1-header.js.map