"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotOverflow = exports.OffsetMatch = exports.TagMatch = exports.SizeMatch = exports.FormatSupported = exports.SubVersionSupported = exports.VersionSupported = void 0;
exports.NoGap = NoGap;
const Errors = require("../errors");
const VersionSupported = (kind1, actual, ...expected) => {
    for (const x of expected)
        if (actual === x)
            return;
    throw Errors.VersionNotSupported(kind1, actual);
};
exports.VersionSupported = VersionSupported;
const SubVersionSupported = (kind1, major, minor, ...expected) => {
    for (const [eMaj, eMin] of expected)
        if (major === eMaj && minor === eMin)
            return;
    throw Errors.VersionNotSupported(kind1, `${major}.${minor}`);
};
exports.SubVersionSupported = SubVersionSupported;
const FormatSupported = (kind1, actual, ...expected) => {
    for (const x of expected)
        if (actual === x)
            return;
    throw Errors.FormatNotSupported(kind1, actual, ...expected);
};
exports.FormatSupported = FormatSupported;
const SizeMatch = (kind1, actual, ...expected) => {
    for (const x of expected)
        if (actual === x)
            return;
    throw Errors.SizeMismatch(kind1, actual, ...expected);
};
exports.SizeMatch = SizeMatch;
const TagMatch = (kind1, actual, ...expected) => {
    for (const x of expected)
        if (actual === x)
            return;
    throw Errors.TagMismatch(kind1, actual, ...expected);
};
exports.TagMatch = TagMatch;
const OffsetMatch = (kind1, actual, ...expected) => {
    for (const x of expected)
        if (actual === x)
            return;
    throw Errors.OffsetMismatch(kind1, actual, ...expected);
};
exports.OffsetMatch = OffsetMatch;
const NotOverflow = (kind1, actual, limit) => {
    if (actual < limit)
        return;
    throw Errors.OffsetMismatch(kind1, actual);
};
exports.NotOverflow = NotOverflow;
function NoGap(kind, arr) {
    for (let index = 0; index < arr.length; index++) {
        if (arr[index] === undefined)
            throw new TypeError(`Gap found in array ${kind}`);
    }
}
//# sourceMappingURL=common.js.map