"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const ava_1 = tslib_1.__importDefault(require("ava"));
const matchers_1 = require("../matchers");
(0, ava_1.default)("String pattern matcher test", t => {
    const stm = new matchers_1.MakeMatcher((a, b, c) => `${a}/${b}/${c}`);
    t.is(stm.createGoalIdFromArgs(["a", "b", "c"]).id, "a/b/c");
    t.is(stm.matchGoalID("a/b/c", ["a", "b", "c"]).id, "a/b/c");
    t.is(stm.matchGoalID("a/b/d", ["a", "b", "c"]), null);
});
(0, ava_1.default)("Prefix matcher test", t => {
    const stm = new matchers_1.KindMatcherT("Prefix::", new matchers_1.MakeMatcher((a, b, c) => `${a}/${b}/${c}`));
    t.is(stm.createGoalIdFromArgs(["a", "b", "c"]).id, "Prefix::a/b/c");
    t.is(stm.matchGoalID("Prefix::a/b/c", ["a", "b", "c"]).id, "Prefix::a/b/c");
    t.is(stm.matchGoalID("Prefix::a/b/d", ["a", "b", "c"]), null);
    t.is(stm.matchGoalID("a/b/c", ["a", "b", "c"]), null);
    t.is(stm.matchGoalID("a/b/d", ["a", "b", "c"]), null);
});
