"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OtVarMasterSet = void 0;
const ImpLib = require("@ot-builder/common-impl");
class OtVarMasterSet {
    constructor() {
        this.nAxes = 0;
        this.axisMap = new WeakMap();
        this.masterList = [];
        this.masterMap = new ImpLib.PathMapImpl();
        this.masterMapCache = new WeakMap();
    }
    putAxis(a) {
        const axisIndex = this.axisMap.get(a);
        if (axisIndex)
            return axisIndex;
        this.nAxes += 1;
        this.axisMap.set(a, this.nAxes);
        return this.nAxes;
    }
    getStepNumbers(master) {
        const steps = [];
        for (const region of master.regions) {
            const aid = this.putAxis(region.dim);
            steps[aid] = [region.min, region.peak, region.max];
        }
        const stepNumbers = [];
        for (let aid = 0; aid < steps.length; aid++) {
            const step = steps[aid];
            if (step)
                stepNumbers.push(aid, step[0], step[1], step[2]);
        }
        return stepNumbers;
    }
    getImpl(master) {
        const stepNumbers = this.getStepNumbers(master);
        const lens = this.masterMap.createLens();
        lens.focus(stepNumbers);
        return lens.get();
    }
    getOrPutImpl(master) {
        const stepNumbers = this.getStepNumbers(master);
        const lens = this.masterMap.createLens();
        lens.focus(stepNumbers);
        const existing = lens.get();
        if (existing)
            return existing;
        const record = { master: master, index: this.masterList.length };
        this.masterList[record.index] = record;
        lens.set(record);
        return record;
    }
    get(master) {
        if (master.isInvalid())
            return undefined;
        else
            return this.getImpl(master);
    }
    getOrPush(master) {
        if (master.isInvalid()) {
            return undefined;
        }
        else {
            const cached = this.masterMapCache.get(master);
            if (cached)
                return cached;
            const put = this.getOrPutImpl(master);
            this.masterMapCache.set(master, put);
            return put;
        }
    }
    get size() {
        return this.masterList.length;
    }
    *[Symbol.iterator]() {
        for (const item of this.masterList)
            yield [item.master, item.index];
    }
}
exports.OtVarMasterSet = OtVarMasterSet;
//# sourceMappingURL=master-set.js.map