"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectDeltaData = exports.DelayDeltaValue = exports.TvsCollector = void 0;
const ImpLib = require("@ot-builder/common-impl");
const variance_1 = require("@ot-builder/variance");
const value_collector_1 = require("../../common/value-collector");
class TvsCollector extends value_collector_1.DelayValueCollector {
    constructor() {
        super(variance_1.OtVar.Ops, new variance_1.OtVar.MasterSet());
    }
    createCollectedValue(origin, deltaMA) {
        return new DelayDeltaValue(this, origin, deltaMA);
    }
}
exports.TvsCollector = TvsCollector;
class DelayDeltaValue {
    constructor(col, origin, deltaMA) {
        this.col = col;
        this.origin = origin;
        this.deltaMA = deltaMA;
    }
    resolve() {
        return this.col.resolveDeltas(this.deltaMA);
    }
}
exports.DelayDeltaValue = DelayDeltaValue;
function collectDeltaData(mc, dimensions, data) {
    const ans = [];
    for (const contour of data) {
        const z = [];
        const n = ImpLib.Arith.rowCount(contour, dimensions);
        for (let zid = 0; zid < n; zid++) {
            for (let dim = 0; dim < dimensions; dim++) {
                z[ImpLib.Arith.d2(dimensions, zid, dim)] = mc.collect(contour[ImpLib.Arith.d2(dimensions, zid, dim)]);
            }
        }
        ans.push(z);
    }
    mc.settleDown();
    return ans;
}
exports.collectDeltaData = collectDeltaData;
//# sourceMappingURL=collect.js.map