"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RectifyImpl = void 0;
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
// Rectifiable implementation methods
var RectifyImpl;
(function (RectifyImpl) {
    function Id(r, x) {
        return x;
    }
    RectifyImpl.Id = Id;
    function maybeT(rec, x, fn) {
        if (!x)
            return x;
        else
            return fn(rec, x);
    }
    RectifyImpl.maybeT = maybeT;
    function maybe2T(rec1, rec2, x, fn) {
        if (!x)
            return x;
        else
            return fn(rec1, rec2, x);
    }
    RectifyImpl.maybe2T = maybe2T;
    function setAllT(rec, xs, fn) {
        const xs1 = new Set();
        for (const x of xs) {
            const x1 = fn(rec, x);
            if (x1)
                xs1.add(x1);
            else
                return null;
        }
        return xs1;
    }
    RectifyImpl.setAllT = setAllT;
    function setSomeT(rec, xs, fn) {
        const xs1 = new Set();
        for (const x of xs) {
            const x1 = fn(rec, x);
            if (x1)
                xs1.add(x1);
        }
        return xs1;
    }
    RectifyImpl.setSomeT = setSomeT;
    function listAllT(rectifier, m, fn) {
        const m1 = [];
        for (const x of m) {
            const x1 = fn(rectifier, x);
            if (x1 == null)
                return null;
            else
                m1.push(x1);
        }
        return m1;
    }
    RectifyImpl.listAllT = listAllT;
    function listAll2T(rectifier1, rectifier2, m, fn) {
        const m1 = [];
        for (const x of m) {
            const x1 = fn(rectifier1, rectifier2, x);
            if (x1 == null)
                return null;
            else
                m1.push(x1);
        }
        return m1;
    }
    RectifyImpl.listAll2T = listAll2T;
    function listSomeT(rectifier, m, fn) {
        const m1 = [];
        for (const x of m) {
            const x1 = fn(rectifier, x);
            if (x1 != null)
                m1.push(x1);
        }
        return m1;
    }
    RectifyImpl.listSomeT = listSomeT;
    function listSome2T(rectifier1, rectifier2, m, fn) {
        const m1 = [];
        for (const x of m) {
            const x1 = fn(rectifier1, rectifier2, x);
            if (x1 != null)
                m1.push(x1);
        }
        return m1;
    }
    RectifyImpl.listSome2T = listSome2T;
    function listSparseT(rectifier, m, fn) {
        const m1 = [];
        for (const x of m) {
            if (x == null)
                m1.push(x);
            else
                m1.push(fn(rectifier, x));
        }
        return m1;
    }
    RectifyImpl.listSparseT = listSparseT;
    function mapAllT(rectifier, m, fnX, fnY) {
        const m1 = new Map();
        for (const [x, y] of m) {
            const x1 = fnX(rectifier, x);
            if (x1 == null)
                return null;
            const y1 = fnY(rectifier, y);
            if (y1 == null)
                return null;
            m1.set(x1, y1);
        }
        return m1;
    }
    RectifyImpl.mapAllT = mapAllT;
    function mapAllT2(rectifier, m, fnX, fnY) {
        const m1 = new Map();
        for (const [x, y] of m) {
            const x1 = fnX(rectifier, x);
            if (x1 == null)
                return null;
            const y1 = fnY(rectifier, x1, y);
            if (y1 == null)
                return null;
            m1.set(x1, y1);
        }
        return m1;
    }
    RectifyImpl.mapAllT2 = mapAllT2;
    function bimapSomeT(rectifier1, rectifier2, m, fnX, fnY) {
        const m1 = new Map();
        for (const [x, y] of m) {
            const x1 = fnX(rectifier1, x);
            if (x1 == null)
                continue;
            const y1 = fnY(rectifier2, y);
            if (y1 == null)
                continue;
            m1.set(x1, y1);
        }
        return m1;
    }
    RectifyImpl.bimapSomeT = bimapSomeT;
    function bimapSome2T(rectifier1, rectifier2, m, fnX, fnY) {
        const m1 = new Map();
        for (const [x, y] of m) {
            const x1 = fnX(rectifier1, x);
            if (x1 == null)
                continue;
            const y1 = fnY(rectifier1, rectifier2, y);
            if (y1 == null)
                continue;
            m1.set(x1, y1);
        }
        return m1;
    }
    RectifyImpl.bimapSome2T = bimapSome2T;
    function mapSomeT(rectifier, m, fnX, fnY) {
        return bimapSomeT(rectifier, rectifier, m, fnX, fnY);
    }
    RectifyImpl.mapSomeT = mapSomeT;
    function bimapSomeT2(rectifier1, rectifier2, m, fnX, fnY) {
        const m1 = new Map();
        for (const [x, y] of m) {
            const x1 = fnX(rectifier1, x);
            if (x1 == null)
                continue;
            const y1 = fnY(rectifier2, x1, y);
            if (y1 == null)
                continue;
            m1.set(x1, y1);
        }
        return m1;
    }
    RectifyImpl.bimapSomeT2 = bimapSomeT2;
    function mapSomeT2(rectifier, m, fnX, fnY) {
        return bimapSomeT2(rectifier, rectifier, m, fnX, fnY);
    }
    RectifyImpl.mapSomeT2 = mapSomeT2;
    let Glyph;
    (function (Glyph) {
        function single(rectifier, g) {
            return rectifier.glyphRef(g);
        }
        Glyph.single = single;
        function setAll(rec, gs) {
            return RectifyImpl.setAllT(rec, gs, single);
        }
        Glyph.setAll = setAll;
        function setSome(rec, gs) {
            return RectifyImpl.setSomeT(rec, gs, single);
        }
        Glyph.setSome = setSome;
        function setSomeN(rec, gs) {
            if (!gs)
                return null;
            const gs1 = RectifyImpl.setSomeT(rec, gs, single);
            if (!gs1.size)
                return null;
            else
                return gs1;
        }
        Glyph.setSomeN = setSomeN;
        function listAll(rec, gs) {
            return RectifyImpl.listAllT(rec, gs, single);
        }
        Glyph.listAll = listAll;
        function listSome(rec, gs) {
            return RectifyImpl.listSomeT(rec, gs, single);
        }
        Glyph.listSome = listSome;
        function listSparse(rec, gs) {
            return RectifyImpl.listSparseT(rec, gs, single);
        }
        Glyph.listSparse = listSparse;
        function bimapAll(rec, gm) {
            return RectifyImpl.mapAllT(rec, gm, single, single);
        }
        Glyph.bimapAll = bimapAll;
        function bimapSome(rec, gm) {
            return RectifyImpl.mapSomeT(rec, gm, single, single);
        }
        Glyph.bimapSome = bimapSome;
        function mapAll(rec, gm) {
            return RectifyImpl.mapAllT(rec, gm, single, (r, x) => x);
        }
        Glyph.mapAll = mapAll;
        function mapSome(rec, gm) {
            return RectifyImpl.mapSomeT(rec, gm, single, (r, x) => x);
        }
        Glyph.mapSome = mapSome;
        function comapAll(rec, gm) {
            return RectifyImpl.mapAllT(rec, gm, (r, x) => x, single);
        }
        Glyph.comapAll = comapAll;
        function comapSome(rec, gm) {
            return RectifyImpl.mapSomeT(rec, gm, (r, x) => x, single);
        }
        Glyph.comapSome = comapSome;
        function mapAllTX(rec, gm, fn) {
            return RectifyImpl.mapAllT(rec, gm, single, fn);
        }
        Glyph.mapAllTX = mapAllTX;
        function mapSomeTX(rec, gm, fn) {
            return RectifyImpl.mapSomeT(rec, gm, single, fn);
        }
        Glyph.mapSomeTX = mapSomeTX;
        function mapSomeTY(rec, rec2, gm, fn) {
            return RectifyImpl.bimapSomeT(rec, rec2, gm, single, fn);
        }
        Glyph.mapSomeTY = mapSomeTY;
        function mapSomeTY2(rec, rec2, gm, fn) {
            return RectifyImpl.bimapSome2T(rec, rec2, gm, single, fn);
        }
        Glyph.mapSomeTY2 = mapSomeTY2;
        function comapAllTY(rec, gm, fn) {
            return RectifyImpl.mapAllT(rec, gm, fn, single);
        }
        Glyph.comapAllTY = comapAllTY;
        function comapSomeTY(rec, gm, fn) {
            return RectifyImpl.mapSomeT(rec, gm, fn, single);
        }
        Glyph.comapSomeTY = comapSomeTY;
    })(Glyph = RectifyImpl.Glyph || (RectifyImpl.Glyph = {}));
    let Coord;
    (function (Coord) {
        function single(rec, x) {
            return rec.coord(x);
        }
        function list(rec, arr) {
            return RectifyImpl.listSomeT(rec, arr, single);
        }
        Coord.list = list;
    })(Coord = RectifyImpl.Coord || (RectifyImpl.Coord = {}));
    let Elim;
    (function (Elim) {
        function findInSet(l, ls) {
            if (l == null || !ls.has(l))
                return null;
            else
                return l;
        }
        Elim.findInSet = findInSet;
        function findInMap(l, ls) {
            if (l == null)
                return null;
            return ls.get(l);
        }
        Elim.findInMap = findInMap;
        function comapSomeT(a, fn, ...args) {
            const a1 = new Map();
            for (const [key, value] of a) {
                const l1 = fn(value, ...args);
                if (l1 != null)
                    a1.set(key, l1);
            }
            return a1;
        }
        Elim.comapSomeT = comapSomeT;
        function listSomeT(a, fn, ...args) {
            const a1 = [];
            for (const item of a) {
                const l1 = fn(item, ...args);
                if (l1 != null)
                    a1.push(l1);
            }
            return a1;
        }
        Elim.listSomeT = listSomeT;
        function listSome(a, ls) {
            const a1 = [];
            for (const item of a) {
                const l1 = findInSet(item, ls);
                if (l1 != null)
                    a1.push(l1);
            }
            return a1;
        }
        Elim.listSome = listSome;
        function listSomeOpt(a, ls) {
            const a1 = [];
            for (const item of a) {
                const l1 = findInSet(item, ls);
                if (l1 != null)
                    a1.push(l1);
            }
            if (!a1.length)
                return null;
            return a1;
        }
        Elim.listSomeOpt = listSomeOpt;
    })(Elim = RectifyImpl.Elim || (RectifyImpl.Elim = {}));
    function getGlyphPoints(g) {
        return ot_glyphs_1.OtGeometryUtil.apply(ot_glyphs_1.OtGeometryUtil.ListPoint, g.geometry);
    }
    RectifyImpl.getGlyphPoints = getGlyphPoints;
})(RectifyImpl = exports.RectifyImpl || (exports.RectifyImpl = {}));
//# sourceMappingURL=index.js.map