"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PointOps = exports.CPoint = exports.PointType = void 0;
const variance_1 = require("@ot-builder/variance");
const GeneralGlyph = require("../general-glyph");
var PointType;
(function (PointType) {
    PointType[PointType["Corner"] = 0] = "Corner";
    PointType[PointType["Lead"] = 1] = "Lead";
    PointType[PointType["Follow"] = 2] = "Follow";
    PointType[PointType["Quad"] = 3] = "Quad";
})(PointType = exports.PointType || (exports.PointType = {}));
class CPoint {
    constructor(x, y, kind) {
        this.x = x;
        this.y = y;
        this.kind = kind;
    }
    static create(x, y, kind = PointType.Corner) {
        return new CPoint(x || 0, y || 0, kind);
    }
}
exports.CPoint = CPoint;
exports.PointOps = new GeneralGlyph.Point.OpT(variance_1.OtVar.Ops, CPoint);
//# sourceMappingURL=point.js.map