"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OtGlyph = void 0;
const prelude_1 = require("@ot-builder/prelude");
const Lib_General_Point = require("../general-glyph/point/ref");
const TAG_GeometryType = require("../general-glyph/type-tags/geometry-type");
const TAG_HintType = require("../general-glyph/type-tags/hint-type");
const OtGlyphCoStat = require("./co-stat");
const Lib_Point = require("./point");
const OtGlyphStat = require("./stat");
// This dual-export is intensional.
// eslint-disable-next-line import/export
class OtGlyph {
    constructor() {
        this.horizontal = { start: 0, end: 0 };
        this.vertical = { start: 0, end: 0 };
        this.geometry = null;
        this.hints = null;
    }
    static shallowCopy(g) {
        const g1 = new OtGlyph();
        g1.name = g.name;
        g1.horizontal = g.horizontal;
        g1.vertical = g.vertical;
        g1.geometry = g.geometry;
        g1.hints = g.hints;
        return g1;
    }
}
exports.OtGlyph = OtGlyph;
// eslint-disable-next-line import/export
(function (OtGlyph) {
    OtGlyph.ContourSet = (0, prelude_1.CaseCreator)(TAG_GeometryType.ContourSet, (contours = []) => ({ contours: [...contours] }));
    OtGlyph.GeometryList = (0, prelude_1.CaseCreator)(TAG_GeometryType.GeometryList, (items = []) => ({ items: [...items] }));
    OtGlyph.TtReference = (0, prelude_1.CaseCreator)(TAG_GeometryType.TtReference, (to, transform) => ({ to, transform }));
    OtGlyph.TtInstruction = (0, prelude_1.CaseCreator)(TAG_HintType.TtInstruction, (instructions) => ({ instructions }));
    OtGlyph.CffHint = Object.assign((0, prelude_1.CaseCreator)(TAG_HintType.CffHint, () => ({
        hStems: [],
        vStems: [],
        hintMasks: [],
        counterMasks: []
    })), {
        createStem(start, end) {
            return { start, end };
        },
        createMask(at, maskH, maskV) {
            return { at, maskH, maskV };
        }
    });
    // Point re-exports
    OtGlyph.PointType = Lib_Point.PointType;
    let Point;
    (function (Point) {
        function create(x, y, kind = OtGlyph.PointType.Corner) {
            return new Lib_Point.CPoint(x || 0, y || 0, kind);
        }
        Point.create = create;
    })(Point = OtGlyph.Point || (OtGlyph.Point = {}));
    OtGlyph.PointOps = Lib_Point.PointOps;
    OtGlyph.PointRef = Lib_General_Point.PointRef;
    let Transform2X3;
    (function (Transform2X3) {
        Transform2X3.Identity = {
            scaledOffset: false,
            xx: 1,
            yx: 0,
            xy: 0,
            yy: 1,
            dx: 0,
            dy: 0
        };
        function Scale(s) {
            return { scaledOffset: false, xx: s, yx: 0, xy: 0, yy: s, dx: 0, dy: 0 };
        }
        Transform2X3.Scale = Scale;
        function Translate(dx, dy) {
            return { scaledOffset: false, xx: 1, yx: 0, xy: 0, yy: 1, dx: dx, dy: dy };
        }
        Transform2X3.Translate = Translate;
        function Rotate(angle) {
            const c = Math.cos(angle), s = Math.sin(angle);
            return { scaledOffset: false, xx: c, yx: -s, xy: s, yy: c, dx: 0, dy: 0 };
        }
        Transform2X3.Rotate = Rotate;
    })(Transform2X3 = OtGlyph.Transform2X3 || (OtGlyph.Transform2X3 = {}));
    // Stat
    OtGlyph.Stat = OtGlyphStat;
    OtGlyph.CoStat = OtGlyphCoStat;
    OtGlyph.GeometryType = TAG_GeometryType;
    OtGlyph.HintType = TAG_HintType;
})(OtGlyph = exports.OtGlyph || (exports.OtGlyph = {}));
//# sourceMappingURL=index.js.map