"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readSfntTtc = exports.readSfntTtcView = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_sfnt_1 = require("@ot-builder/ot-sfnt");
const primitive_1 = require("@ot-builder/primitive");
function readSfntTtcView(view) {
    const sfntList = [];
    const _ttcTag = view.uint32();
    const majorVersion = view.uint16();
    const minorVersion = view.uint16();
    errors_1.Assert.SubVersionSupported("TTC", majorVersion, minorVersion, [1, 0], [2, 0]);
    const numFonts = view.uint32();
    for (let fid = 0; fid < numFonts; fid++) {
        const vSfnt = view.lift(view.uint32());
        const version = vSfnt.uint32();
        const numTables = vSfnt.uint16();
        const _searchRange = vSfnt.uint16();
        const _entrySelector = vSfnt.uint16();
        const _rangeShift = vSfnt.uint16();
        const sfnt = new ot_sfnt_1.Sfnt(version);
        for (let mu = 0; mu < numTables; mu++) {
            const tag = vSfnt.next(primitive_1.Tag);
            const _checkSum = vSfnt.uint32();
            const tableOffset = vSfnt.uint32();
            const length = vSfnt.uint32();
            sfnt.tables.set(tag, view.lift(tableOffset).bytes(length));
        }
        sfntList.push(sfnt);
    }
    return sfntList;
}
exports.readSfntTtcView = readSfntTtcView;
function readSfntTtc(buf) {
    return readSfntTtcView(new bin_util_1.BinaryView(buf));
}
exports.readSfntTtc = readSfntTtc;
//# sourceMappingURL=read.js.map