/// <reference types="node" />
import { Tag } from "@ot-builder/primitive";
export type TableSlice = {
    data: Buffer;
    start: number;
    length: number;
};
export type TableSliceCollection = {
    readonly version: number;
    tables: Map<string, TableSlice>;
};
export interface TableBlob {
    offset: number;
    content: Buffer;
    checksum: number;
}
export type BlobStore = Map<string, TableBlob>;
export interface TableRecord {
    tag: Tag;
    blob: TableBlob;
    start: number;
    length: number;
}
export declare function BufferToSlice(buf: Buffer): TableSlice;
export declare function collectTableData(tag: Tag, slice: TableSlice, blobStore: BlobStore): TableRecord;
export declare function calculateChecksum(buf: Buffer): number;
export declare function allocateBlobOffsets(store: BlobStore): void;
//# sourceMappingURL=collector.d.ts.map