import { BinaryView, Frag, Read, Write } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
export type CovAuxMappingT<T> = Array<[number, T]>;
export type CovSplitLists<T> = {
    gidList: Array<number>;
    values: Array<T>;
};
export declare const MaxCovItemWords = 3;
export declare namespace CovUtils {
    function sortAuxMap<T>(axm: CovAuxMappingT<T>): [number, T][];
    function sortGidList(gids: number[]): number[];
    function gidListFromAuxMap<T>(axm: CovAuxMappingT<T>): number[];
    function valueListFromAuxMap<T>(axm: CovAuxMappingT<T>): T[];
    function auxMapFromMap<G, T>(mapping: Iterable<[G, T]>, gOrd: Data.Order<G>): CovAuxMappingT<T>;
    function auxMapFromMapExcl<G, T>(mapping: Iterable<[G, T]>, gOrd: Data.Order<G>, exclude: ReadonlySet<G>): CovAuxMappingT<T>;
    function auxMapFromExtractor<G, T>(mapping: Iterable<T>, gOrd: Data.Order<G>, extract: (from: T) => G): CovAuxMappingT<T>;
    function mapFromNumbers<G, T>(gids: ReadonlyArray<number>, values: ReadonlyArray<T>, gOrd: Data.Order<G>): IterableIterator<[G, T]>;
    function splitListFromMap<G, T>(mapping: Iterable<[G, T]>, gOrd: Data.Order<G>): CovSplitLists<T>;
    function glyphsFromGidList<G>(gids: Iterable<number>, gOrd: Data.Order<G>): IterableIterator<G>;
    function glyphSetFromGidList<G>(gids: Iterable<number>, gOrd: Data.Order<G>): Set<G>;
    function gidListFromGlyphSet<G>(glyphs: Iterable<G>, gOrd: Data.Order<G>): number[];
}
export declare const GlyphCoverage: {
    read(view: BinaryView, gOrd: Data.Order<OtGlyph>): Set<OtGlyph>;
    write(frag: Frag, gs: ReadonlySet<OtGlyph>, gOrd: Data.Order<OtGlyph>, trick?: number): void;
};
export declare const NullablePtr16GlyphCoverage: Read<Set<OtGlyph> | null | undefined, [gOrd: Data.Order<OtGlyph>]> & Write<ReadonlySet<OtGlyph> | null | undefined, [gOrd: Data.Order<OtGlyph>, trick?: number | undefined]>;
export declare const Ptr16GlyphCoverage: Read<Set<OtGlyph>, [gOrd: Data.Order<OtGlyph>]> & Write<ReadonlySet<OtGlyph>, [gOrd: Data.Order<OtGlyph>, trick?: number | undefined]>;
export declare const GidCoverage: {
    write(target: Frag, t: readonly number[], trick?: number | undefined): void;
    read(view: BinaryView): number[];
};
export declare const NullablePtr16GidCoverage: Read<number[] | null | undefined, []> & Write<readonly number[] | null | undefined, [trick?: number | undefined]>;
export declare const Ptr16GidCoverage: Read<number[], []> & Write<readonly number[], [trick?: number | undefined]>;
//# sourceMappingURL=coverage.d.ts.map