"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GdefTableIo = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const var_store_1 = require("@ot-builder/var-store");
const class_def_1 = require("../shared/class-def");
const attachment_point_1 = require("./attachment-point");
const lig_caret_list_1 = require("./lig-caret-list");
const mark_glyph_sets_1 = require("./mark-glyph-sets");
exports.GdefTableIo = {
    ...(0, bin_util_1.Read)((view, gOrd, designSpace) => {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        errors_1.Assert.SubVersionSupported(`GDEF`, majorVersion, minorVersion, [1, 0], [1, 2], [1, 3]);
        const pGlyphClassDef = view.ptr16Nullable();
        const pAttachList = view.ptr16Nullable();
        const pLigCaretList = view.ptr16Nullable();
        const pMarkAttachClassDef = view.ptr16Nullable();
        const pMarkGlyphSetsDef = minorVersion >= 2 ? view.ptr16Nullable() : null;
        const pIVS = minorVersion >= 3 ? view.ptr32Nullable() : null;
        const ivs = pIVS && designSpace ? pIVS.next(var_store_1.ReadTimeIVS, designSpace) : null;
        const gdef = new ot_layout_1.Gdef.Table();
        gdef.glyphClassDef = pGlyphClassDef ? pGlyphClassDef.next(class_def_1.ClassDef, gOrd) : null;
        gdef.attachList = pAttachList ? pAttachList.next(attachment_point_1.GdefAttachmentPointList, gOrd) : null;
        gdef.ligCarets = pLigCaretList ? pLigCaretList.next(lig_caret_list_1.LigCaretList, gOrd, ivs) : null;
        gdef.markAttachClassDef = pMarkAttachClassDef
            ? pMarkAttachClassDef.next(class_def_1.ClassDef, gOrd)
            : null;
        gdef.markGlyphSets = pMarkGlyphSetsDef
            ? pMarkGlyphSetsDef.next(mark_glyph_sets_1.MarkGlyphSets, gOrd)
            : null;
        return { gdef, ivs };
    }),
    ...(0, bin_util_1.Write)((frag, gdef, cfg, gOrd, ivs, designSpace) => {
        const trick = cfg.layout.gdefWriteTrick || 0;
        const fClassDef = gdef.glyphClassDef
            ? bin_util_1.Frag.from(class_def_1.ClassDef, gdef.glyphClassDef, gOrd, trick)
            : null;
        const fAttachList = gdef.attachList
            ? bin_util_1.Frag.from(attachment_point_1.GdefAttachmentPointList, gdef.attachList, cfg, gOrd)
            : null;
        const fLigCaretList = gdef.ligCarets
            ? bin_util_1.Frag.from(lig_caret_list_1.LigCaretList, gdef.ligCarets, cfg, gOrd, ivs)
            : null;
        const fMarkAttachClassDef = gdef.markAttachClassDef
            ? bin_util_1.Frag.from(class_def_1.ClassDef, gdef.markAttachClassDef, gOrd, trick)
            : null;
        const fMarkGlyphSets = gdef.markGlyphSets
            ? bin_util_1.Frag.from(mark_glyph_sets_1.MarkGlyphSets, gdef.markGlyphSets, cfg, gOrd)
            : null;
        const fIVS = !ivs || !designSpace || ivs.isEmpty()
            ? null
            : bin_util_1.Frag.from(var_store_1.WriteTimeIVS, ivs, { designSpace });
        let minorVersion = 3;
        if (!fIVS)
            minorVersion = 2;
        if (!fMarkGlyphSets && !fIVS)
            minorVersion = 0;
        frag.uint16(1).uint16(minorVersion);
        frag.ptr16(fClassDef);
        frag.ptr16(fAttachList);
        frag.ptr16(fLigCaretList);
        frag.ptr16(fMarkAttachClassDef);
        if (minorVersion >= 2)
            frag.ptr16(fMarkGlyphSets);
        if (minorVersion >= 3)
            frag.ptr32(fIVS);
    })
};
//# sourceMappingURL=index.js.map