import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { CffReadContext } from "../context/read";
import { CffCharSetSink } from "./io";
export declare class CffGlyphNaming<G extends OtGlyph> implements Data.Naming.Source<G> {
    private mapping;
    getName(g: G): string | undefined;
    setName(g: G, name: string): void;
}
export declare class CffGlyphNameCharsetSink<G extends OtGlyph> implements CffCharSetSink {
    private glyphs;
    private naming;
    private ctx;
    constructor(glyphs: Data.Order<G>, naming: null | CffGlyphNaming<G>, ctx: CffReadContext);
    getGlyphCount(): number;
    put(gid: number, chr: number): void;
}
export declare class CffCidCharsetSink<G extends OtGlyph> implements CffCharSetSink {
    private glyphs;
    private naming;
    private cidMap;
    constructor(glyphs: Data.Order<G>, naming: null | CffGlyphNaming<G>, cidMap: Map<number, OtGlyph>);
    getGlyphCount(): number;
    put(gid: number, chr: number): void;
}
//# sourceMappingURL=glyph-data-sink.d.ts.map