"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MinimalDrawCallOptimizers = exports.StandardDrawCallOptimizers = void 0;
const hhvv_curveto_1 = require("./hhvv-curveto");
const hv_lineto_1 = require("./hv-lineto");
const hv_moveto_1 = require("./hv-moveto");
const hvvh_curveto_1 = require("./hvvh-curveto");
function StandardDrawCallOptimizers(ctx) {
    return [
        new hv_lineto_1.RLineToHVLine(ctx),
        new hvvh_curveto_1.RRCurveToHVVHCurve(ctx),
        new hhvv_curveto_1.RRCurveToHHVVCurve(ctx),
        new hv_moveto_1.RMoveToHVMove(ctx),
        new hv_moveto_1.RMoveToHVMoveW(ctx)
    ];
}
exports.StandardDrawCallOptimizers = StandardDrawCallOptimizers;
function MinimalDrawCallOptimizers(ctx) {
    return [];
}
exports.MinimalDrawCallOptimizers = MinimalDrawCallOptimizers;
//# sourceMappingURL=index.js.map