"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlyphCountMismatch = exports.GlyphNotFound = exports.GeneralOverflow = exports.MissingKeyTable = exports.OffsetMismatch = exports.TagMismatch = exports.SizeMismatch = exports.VersionNotSupported = exports.FormatNotSupported = exports.NullPtr = exports.Unreachable = void 0;
const Unreachable = () => new Error("Unreachable");
exports.Unreachable = Unreachable;
const NullPtr = (reason) => new TypeError(`Null pointer detected${reason ? " : " + reason : ""}`);
exports.NullPtr = NullPtr;
const FormatNotSupported = (what, ver, ...expected) => new TypeError(`${what} format unsupported : ${ver} (Expected: ${expected})`);
exports.FormatNotSupported = FormatNotSupported;
const VersionNotSupported = (what, ver) => new TypeError(`${what} version unsupported : ${ver}`);
exports.VersionNotSupported = VersionNotSupported;
const SizeMismatch = (what, actual, ...expected) => new TypeError(`${what} size mismatch : ${actual} (Expected: ${expected})`);
exports.SizeMismatch = SizeMismatch;
const TagMismatch = (what, actual, ...expected) => new TypeError(`${what} tag mismatch : ${actual} (Expected: ${expected})`);
exports.TagMismatch = TagMismatch;
const OffsetMismatch = (what, actual, ...expected) => new TypeError(`${what} offset mismatch : ${expected} (Expected: ${expected})`);
exports.OffsetMismatch = OffsetMismatch;
const MissingKeyTable = (tag) => new TypeError(`Table ${tag} missing.`);
exports.MissingKeyTable = MissingKeyTable;
const GeneralOverflow = (kind, value) => new RangeError(`${kind} overflow: ${value}.`);
exports.GeneralOverflow = GeneralOverflow;
const GlyphNotFound = (where) => new RangeError(`Glyph not found in ${where}`);
exports.GlyphNotFound = GlyphNotFound;
const GlyphCountMismatch = (where) => new RangeError(`Glyph count mismatch at ${where}`);
exports.GlyphCountMismatch = GlyphCountMismatch;
//# sourceMappingURL=common.js.map