"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtCountArray = exports.SimpleArray = void 0;
function SimpleArray(n, r) {
    return {
        read: (view, ...ar) => {
            const conditionCount = view.next(n);
            return view.array(conditionCount, r, ...ar);
        },
        write: (frag, t, ...aw) => {
            frag.push(n, t.length);
            frag.array(r, t, ...aw);
        }
    };
}
exports.SimpleArray = SimpleArray;
function ExtCountArray(r) {
    return {
        read: (view, n, ...ar) => {
            return view.array(n, r, ...ar);
        },
        write: (frag, t, n, ...aw) => {
            frag.arrayN(r, n, t, ...aw);
        }
    };
}
exports.ExtCountArray = ExtCountArray;
//# sourceMappingURL=simple-array.js.map