%%%----------------------------------------------------------------------
%%%
%%% ejabberd, Copyright (C) 2002-2026   ProcessOne
%%%
%%% This program is free software; you can redistribute it and/or
%%% modify it under the terms of the GNU General Public License as
%%% published by the Free Software Foundation; either version 2 of the
%%% License, or (at your option) any later version.
%%%
%%% This program is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%%% General Public License for more details.
%%%
%%% You should have received a copy of the GNU General Public License along
%%% with this program; if not, write to the Free Software Foundation, Inc.,
%%% 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%%%
%%%----------------------------------------------------------------------

-record(archive_msg,
	{us = {<<"">>, <<"">>}                :: {binary(), binary()},
	 id = <<>>                            :: binary(),
	 timestamp = erlang:timestamp()       :: erlang:timestamp(),
	 peer = {<<"">>, <<"">>, <<"">>}      :: ljid() | undefined,
	 bare_peer = {<<"">>, <<"">>, <<"">>} :: ljid(),
	 packet = #xmlel{}                    :: xmlel() | message(),
	 nick = <<"">>                        :: binary(),
	 type = chat                          :: chat | groupchat,
         origin_id = <<"">>                   :: binary()}).

-record(archive_prefs,
	{us = {<<"">>, <<"">>} :: {binary(), binary()},
	 default = never       :: never | always | roster,
	 always = []           :: [ljid()],
	 never = []            :: [ljid()]}).
